/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.gendoc.documents.IMimeHtmlService;
import org.eclipse.gendoc.documents.MimeTypes;
import org.eclipse.gendoc.documents.url.FileUrlTransformer;
import org.eclipse.gendoc.documents.url.UrlTransformer;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.UnknownMimeTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MimeHtmlService
extends AbstractService
implements IMimeHtmlService {
    protected static final String MIME_VERSION = "MIME-Version: 1.0";
    protected static final String MIME_CONTENT = "Content-Type: multipart/related;boundary=";
    protected static final String MIME_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
    protected static final String MIME_HEAD = "</head>";
    protected static final String MIME_META = "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head>";
    protected static final String MIME_HTML_TYPE = "Content-Type: text/html;";
    protected static final String MIME_HTML_TRANSFERT = "Content-Transfer-Encoding: quoted-printable";
    protected static final String MIME_RESSOURCE_TYPE = "Content-Type:";
    protected static final String MIME_RESSOURCE_TRANSFERT = "Content-Transfer-Encoding: base64";
    protected static final String MIME_RESSOURCE_LOCATION = "Content-Location:";
    protected static final String MIME_SEP = "--";
    protected static final String MHT_IDF = "mhtTOPCASEDgenereted";
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final String REG_FIND1 = "src=\"";
    protected static final String REG_TABLE1 = "<table";
    protected static final String REG_TABLE2 = "<td";
    protected static final String REG_TABLE3 = "<tr";
    protected static final String REG_TABLE4 = "<td";
    protected static final String REG_LINK = "\"";
    protected static final String REG_OPEN = "<";
    protected static final String REG_CLOSE = ">";
    protected static final String REG_3D_ORI = "=";
    protected static final String REG_3D_FINAL = "=3D";
    protected String currentProtocol;
    protected Set<String> fileExtensions;
    protected String beginPart;
    protected String endPart;
    protected Map<String, UrlTransformer> protocolMap = new HashMap<String, UrlTransformer>();

    public MimeHtmlService() {
        this.fileExtensions = new HashSet<String>();
        this.protocolMap.put("file:/", new FileUrlTransformer());
    }

    public void clear() {
    }

    @Override
    public abstract String convertToMimeHtml(String var1);

    protected int findExternalLink(String html, int minPos) {
        int dFind = html.substring(minPos).indexOf(REG_FIND1);
        this.currentProtocol = "file:/";
        return dFind < 0 ? dFind : minPos + dFind + REG_FIND1.length();
    }

    protected int findTable(String html, int minPos) {
        int dFind4;
        int dFind3;
        int dFind2;
        String tHtml = html.substring(minPos);
        int dFind = -1;
        int dFind1 = tHtml.indexOf(REG_TABLE1);
        if (dFind1 > -1) {
            if (dFind == -1) {
                dFind = dFind1;
            } else if (dFind > dFind1) {
                dFind = dFind1;
            }
        }
        if ((dFind2 = tHtml.indexOf("<td")) > -1) {
            if (dFind == -1) {
                dFind = dFind2;
            } else if (dFind > dFind2) {
                dFind = dFind2;
            }
        }
        if ((dFind3 = tHtml.indexOf(REG_TABLE3)) > -1) {
            if (dFind == -1) {
                dFind = dFind3;
            } else if (dFind > dFind3) {
                dFind = dFind3;
            }
        }
        if ((dFind4 = tHtml.indexOf("<td")) > -1) {
            if (dFind == -1) {
                dFind = dFind4;
            } else if (dFind > dFind4) {
                dFind = dFind4;
            }
        }
        return dFind < 0 ? dFind : minPos + dFind;
    }

    protected String getExternalLink(String html, int pos) {
        int dFind = html.substring(pos).indexOf(REG_LINK);
        String sFind = html.substring(pos, pos + dFind);
        String sFind2 = Path.fromOSString((String)sFind).toString();
        if (!sFind2.startsWith(this.currentProtocol)) {
            sFind = null;
        }
        return sFind2;
    }

    protected int findOpen(String html, int pos) {
        int dFind = html.substring(0, pos).lastIndexOf(REG_OPEN);
        return dFind;
    }

    protected int findClose(String html, int pos) {
        int dFind = html.substring(pos).indexOf(REG_CLOSE);
        return dFind + pos + 1;
    }

    protected String add3D(String html, boolean transform) {
        String s3D = html.replaceAll(REG_3D_ORI, REG_3D_FINAL);
        if (transform) {
            UrlTransformer urlTransformer = this.protocolMap.get(this.currentProtocol);
            if (urlTransformer == null) {
                return s3D;
            }
            s3D = urlTransformer.getConvertMhtUrl(s3D);
        }
        return s3D;
    }

    protected String generateBase64(String urlToConvert) {
        UrlTransformer urlTransformer = this.protocolMap.get(this.currentProtocol);
        String code64 = "";
        String extension = "";
        int bytes = 0;
        if (urlTransformer == null) {
            return code64;
        }
        try {
            BufferedInputStream bis = urlTransformer.getInputStream(urlToConvert);
            if (bis == null) {
                return code64;
            }
            extension = urlTransformer.getExtention();
            bytes = urlTransformer.getSizeOfStream();
            if (bytes <= 0) {
                return code64;
            }
            byte[] buffer = new byte[bytes];
            bis.read(buffer);
            bis.close();
            String coded = DataValue.Base64.encode((byte[])buffer);
            String mimeUrl = urlTransformer.getConvertMhtUrl(urlToConvert);
            String mimeType = MimeTypes.getMimeTypefromExtension(extension);
            this.fileExtensions.add(extension);
            code64 = "--mhtTOPCASEDgenereted" + LINE_SEP + MIME_RESSOURCE_TYPE + " " + mimeType + LINE_SEP + MIME_RESSOURCE_TRANSFERT + LINE_SEP + MIME_RESSOURCE_LOCATION + " " + mimeUrl + LINE_SEP + LINE_SEP + coded + LINE_SEP + LINE_SEP;
        }
        catch (IOException iOException) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Unable to read stream", 4);
        }
        catch (UnknownMimeTypeException unknownMimeTypeException) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Unable to find mime type of " + extension, 4);
        }
        return code64;
    }

    @Override
    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    @Override
    public String getBeginPart() {
        return this.beginPart;
    }

    @Override
    public String getEndPart() {
        return this.endPart;
    }
}

