/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.services.AbstractExtension;
import org.eclipse.gendoc.services.IService;
import org.eclipse.gendoc.services.ServiceTypeExtension;
import org.eclipse.gendoc.services.ServiceTypesExtensionPoint;
import org.eclipse.gendoc.services.ServicesExtensionPoint;

class ServiceExtension
extends AbstractExtension {
    private final String id;
    private final String serviceTypeId;
    private final boolean isDefaultService;

    public ServiceExtension(IConfigurationElement configElement) {
        super(configElement);
        this.id = this.parseStringAttribute(configElement, ServicesExtensionPoint.SERVICE_ID, true);
        this.serviceTypeId = this.parseStringAttribute(configElement, ServicesExtensionPoint.SERVICE_SERVICE_TYPE, true);
        this.isDefaultService = this.parseBooleanAttribute(configElement, ServicesExtensionPoint.SERVICE_DEFAULT, true);
        this.parseStringAttribute(configElement, ServicesExtensionPoint.SERVICE_CLASS, true);
    }

    public String getId() {
        return this.id;
    }

    public IService getService() {
        try {
            return (IService)this.getConfigElement().createExecutableExtension(ServicesExtensionPoint.SERVICE_CLASS);
        }
        catch (CoreException e) {
            String message = "Failed to create service " + this.id + " from " + this.getConfigElement().getDeclaringExtension().getNamespaceIdentifier();
            ServiceExtension.log(message, (Exception)((Object)e));
            return null;
        }
    }

    public ServiceTypeExtension getServiceType() {
        return ServiceTypesExtensionPoint.getDefault().getServiceType(this.serviceTypeId);
    }

    public String getServiceTypeId() {
        return this.serviceTypeId;
    }

    public boolean isDefault() {
        return this.isDefaultService;
    }
}

