/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.process.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.process.IProcessExtensionService;
import org.eclipse.gendoc.process.impl.ProcessExtension;
import org.eclipse.gendoc.process.impl.ProcessesExtensionPoint;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.exception.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExtensionService
extends AbstractService
implements IProcessExtensionService {
    private List<ProcessExtension> waiting = new LinkedList<ProcessExtension>();
    private List<ProcessExtension> ready = new ArrayList<ProcessExtension>();
    private List<ProcessExtension> current = new ArrayList<ProcessExtension>();

    public ProcessExtensionService() throws ServiceException {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(ProcessesExtensionPoint.EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ProcessExtension extension = new ProcessExtension(element);
            this.waiting.add(extension);
            ++n2;
        }
        for (ProcessExtension extension : this.waiting) {
            for (String ref : extension.getPredecessors()) {
                ProcessExtension predecessor = this.getProcessExtension(ref);
                if (predecessor == null) continue;
                extension.getDependencies().add(predecessor);
            }
            for (String ref : extension.getSuccessors()) {
                ProcessExtension successor = this.getProcessExtension(ref);
                if (successor == null) continue;
                successor.getDependencies().add(extension);
            }
        }
        StringBuffer message = new StringBuffer("Cyclic dependency detected in process extensions: ");
        for (ProcessExtension processExtension : this.waiting) {
            if (!processExtension.findCyclicDependencies(message)) continue;
            ((IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class)).addDiagnostic(4, message.toString(), null);
            throw new ServiceException(message.toString());
        }
    }

    @Override
    public int getNumProcesses() {
        return this.waiting.size() + this.ready.size() + this.current.size();
    }

    @Override
    public List<ProcessExtension> getProcesses() {
        return this.current;
    }

    public ProcessExtension getProcessExtension(String id) {
        for (ProcessExtension processExtension : this.waiting) {
            if (!id.equals(processExtension.getId())) continue;
            return processExtension;
        }
        return null;
    }

    @Override
    public boolean next() {
        this.current.clear();
        for (ProcessExtension waiting : this.waiting) {
            if (!waiting.getDependencies().isEmpty()) continue;
            this.ready.add(waiting);
        }
        this.waiting.removeAll(this.ready);
        Collections.sort(this.ready);
        if (!this.ready.isEmpty()) {
            ProcessExtension first = this.ready.get(0);
            this.ready.remove(0);
            this.current.add(first);
            if (first.isParallel()) {
                for (ProcessExtension next : this.ready) {
                    if (!next.isParallel() || !next.getPriority().equals((Object)first.getPriority())) continue;
                    this.current.add(next);
                }
            }
            this.ready.removeAll(this.current);
            for (ProcessExtension waiting : this.waiting) {
                waiting.getDependencies().removeAll(this.current);
            }
        }
        if (this.current.isEmpty() && !this.waiting.isEmpty()) {
            throw new RuntimeException("Unable to satisfy dependencies for remaining processes.");
        }
        return !this.current.isEmpty();
    }
}

