/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.impactanalyzer.configuration.ActivationOption;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequest;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSetFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.Tuple;

public class TracebackCache {
    private final Map<Tuple.Triple<TracebackStep, AnnotatedEObject, UnusedEvaluationRequestSet>, OperationCallExpKeyedSet> navigateCache = new HashMap<Tuple.Triple<TracebackStep, AnnotatedEObject, UnusedEvaluationRequestSet>, OperationCallExpKeyedSet>();
    private final Map<UnusedEvaluationRequest, Object> unusedEvaluationCache = new HashMap<UnusedEvaluationRequest, Object>();
    private final ActivationOption configuration;
    private final UnusedEvaluationRequestFactory unusedEvaluationRequestFactory;
    private final OperationCallExpKeyedSetFactory operationCallExpKeyedSetFactory;

    public TracebackCache(ActivationOption configuration, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        this.configuration = configuration;
        this.unusedEvaluationRequestFactory = unusedEvaluationRequestFactory;
        this.operationCallExpKeyedSetFactory = new OperationCallExpKeyedSetFactory(configuration.isOperationCallSelectionActive());
    }

    public ActivationOption getConfiguration() {
        return this.configuration;
    }

    public OperationCallExpKeyedSet get(TracebackStep step, AnnotatedEObject from, UnusedEvaluationRequestSet pendingUnusedEvaluationRequests) {
        OperationCallExpKeyedSet result = this.navigateCache.get(new Tuple.Triple<TracebackStep, AnnotatedEObject, UnusedEvaluationRequestSet>(step, from, pendingUnusedEvaluationRequests));
        return result;
    }

    public void put(TracebackStep step, AnnotatedEObject from, UnusedEvaluationRequestSet pendingUnusedEvaluationRequests, OperationCallExpKeyedSet result) {
        this.navigateCache.put(new Tuple.Triple<TracebackStep, AnnotatedEObject, UnusedEvaluationRequestSet>(step, from, pendingUnusedEvaluationRequests), result);
    }

    public Object getCachedEvaluationResult(UnusedEvaluationRequest request) {
        return this.unusedEvaluationCache.get(request);
    }

    public void cacheEvaluationResult(UnusedEvaluationRequest request, Object evaluationResult) {
        this.unusedEvaluationCache.put(request, evaluationResult);
    }

    public UnusedEvaluationRequestFactory getUnusedEvaluationRequestFactory() {
        return this.unusedEvaluationRequestFactory;
    }

    public OperationCallExpKeyedSetFactory getOperationCallExpKeyedSetFactory() {
        return this.operationCallExpKeyedSetFactory;
    }
}

