/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.internal.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class MetaInfMavenScanner<T> {
    private static final String META_INF_MAVEN = "META-INF/maven";

    public List<T> scan(File file, String filename) {
        ArrayList result = new ArrayList();
        if (file != null) {
            if (file.isDirectory()) {
                this.scanFilesystem(new File(file, META_INF_MAVEN), filename, result);
            } else if (file.isFile()) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (JarFile jar = new JarFile(file);){
                        this.scanJar(jar, filename, result);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private void scanJar(JarFile jar, String filename, List<T> result) throws IOException {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).startsWith(META_INF_MAVEN) || !name.endsWith(filename)) continue;
            try {
                T t = this.visitJarEntry(jar, entry);
                if (t == null) continue;
                result.add(t);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void scanFilesystem(File dir, String filename, List<T> result) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.scanFilesystem(file, filename, result);
            } else if (file.isFile() && filename.equals(file.getName())) {
                try {
                    T t = this.visitFile(file);
                    if (t != null) {
                        result.add(t);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    protected abstract T visitFile(File var1) throws IOException;

    protected abstract T visitJarEntry(JarFile var1, JarEntry var2) throws IOException;
}

