/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.commons;

import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.junit.Assert;

@SuppressWarnings("all")
public class EMFCompareUtil {
  public static List<Diff> compare(final EObject rootCurrent, final EObject rootExpected) {
    final DefaultComparisonScope _defaultComparisonScope = new DefaultComparisonScope(rootCurrent, rootExpected, 
      null);
    final IComparisonScope scope = _defaultComparisonScope;
    final EMFCompare.Builder _builder = EMFCompare.builder();
    final EMFCompare _build = _builder.build();
    final Comparison comparison = _build.compare(scope);
    return comparison.getDifferences();
  }

  public static void assertEqualsEMF(final String message, final EObject rootCurrent, final EObject rootExpected) {
    final List<Diff> differences = EMFCompareUtil.compare(rootCurrent, rootExpected);
    for (final Diff d : differences) {
      {
        final String _string = d.toString();
        final String _plus = ("Checking:[" + _string);
        final String _plus_1 = (_plus + "]");
        final DifferenceKind _kind = d.getKind();
        InputOutput.<String>println(_plus_1);
        Assert.assertEquals(((message + " - ") + _plus_1), DifferenceKind.MOVE, _kind);
      }
    }
  }
}
