/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.gexpressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GAdditionOperator implements Enumerator
{
    ADDITION(0, "ADDITION", "+"),
    SUBTRACTION(1, "SUBTRACTION", "-");

    public static final int ADDITION_VALUE = 0;
    public static final int SUBTRACTION_VALUE = 1;
    private static final GAdditionOperator[] VALUES_ARRAY;
    public static final List<GAdditionOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GAdditionOperator[]{ADDITION, SUBTRACTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GAdditionOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GAdditionOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GAdditionOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GAdditionOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GAdditionOperator get(int value) {
        switch (value) {
            case 0: {
                return ADDITION;
            }
            case 1: {
                return SUBTRACTION;
            }
        }
        return null;
    }

    private GAdditionOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

