/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.deciders.LogicalStepDeciderFactory;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.ILogicalStepDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.deciders.DeciderSpecificationExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.deciders.DeciderSpecificationExtensionPoint;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionPlatform;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;

public abstract class BaseConcurrentModelExecutionContext<R extends IConcurrentRunConfiguration, P extends IExecutionPlatform, L extends LanguageDefinitionExtension>
extends AbstractConcurrentModelExecutionContext<R, P, L> {
    protected ILogicalStepDecider _logicalStepDecider;
    protected MSEModel _mseModel;

    public BaseConcurrentModelExecutionContext(R runConfiguration, ExecutionMode executionMode) throws EngineContextException {
        super(runConfiguration, executionMode);
        try {
            this._logicalStepDecider = executionMode.equals((Object)ExecutionMode.Run) ? this.createRunDecider() : LogicalStepDeciderFactory.createDecider(runConfiguration.getDeciderName(), executionMode);
        }
        catch (CoreException e) {
            EngineContextException exception = new EngineContextException("Cannot initialize the execution context, see inner exception.", (Exception)((Object)e));
            throw exception;
        }
    }

    public void dispose() {
        super.dispose();
        this._logicalStepDecider.dispose();
    }

    public final ILogicalStepDecider getLogicalStepDecider() {
        return this._logicalStepDecider;
    }

    public final MSEModel getMSEModel() {
        if (this._mseModel == null) {
            this.setUpMSEModel();
        }
        return this._mseModel;
    }

    public final void setUpMSEModel() {
        URI msemodelPlatformURI = URI.createPlatformResourceURI((String)this.getWorkspace().getMSEModelPath().removeFileExtension().addFileExtension("msemodel").toString(), (boolean)true);
        try {
            Resource resource = this.getResourceModel().getResourceSet().getResource(msemodelPlatformURI, true);
            this._mseModel = (MSEModel)resource.getContents().get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ILogicalStepDecider createRunDecider() throws CoreException {
        DeciderSpecificationExtension extension = DeciderSpecificationExtensionPoint.findDefinition((String)this.getDefaultRunDeciderName());
        return extension.instanciateDecider();
    }
}

