/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.parser.xtext;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import fr.inria.aoste.timesquare.ccslkernel.model.utils.CCSLKernelUtils;
import fr.inria.aoste.timesquare.ccslkernel.parser.xtext.EventResourceDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;

public final class CCSLImportUriGlobalScopeProvider
extends ImportUriGlobalScopeProvider {
    @Inject
    IQualifiedNameConverter qualifiedNameConverter;
    private HashMap<Resource, EventResourceDescription> resourceDescriptionCache = new HashMap();

    protected LinkedHashSet<URI> getImportedUris(Resource resource) {
        LinkedHashSet uniqueImportURIs = super.getImportedUris(resource);
        Iterator uriIter = uniqueImportURIs.iterator();
        while (uriIter.hasNext()) {
            URI uri = (URI)uriIter.next();
            if (uri != null && uri.toString().length() != 0) continue;
            uriIter.remove();
        }
        return uniqueImportURIs;
    }

    protected IScope getScope(Resource resource, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        LinkedHashSet<URI> uniqueImportURIs = this.getImportedUris(resource);
        IResourceDescriptions descriptions = this.getResourceDescriptions(resource, uniqueImportURIs);
        ArrayList urisAsList = Lists.newArrayList(uniqueImportURIs);
        Collections.reverse(urisAsList);
        IScope scope = IScope.NULLSCOPE;
        for (URI uri : urisAsList) {
            scope = this.createLazyResourceScope(resource, scope, uri, descriptions, type, filter, ignoreCase);
        }
        return scope;
    }

    protected EventResourceDescription getOrCreateResourceDescription(Resource resource, String prefix) {
        EventResourceDescription resourceDescription = this.resourceDescriptionCache.get(resource);
        if (resourceDescription != null && !resource.isModified()) {
            boolean samePrefix = true;
            samePrefix = prefix == null ? resourceDescription.getPrefix() == null : prefix.equals(resourceDescription.getPrefix());
            if (samePrefix) {
                return resourceDescription;
            }
        }
        resourceDescription = new EventResourceDescription(resource, prefix, this.qualifiedNameConverter);
        resource.setModified(false);
        resource.setTrackingModification(true);
        this.resourceDescriptionCache.put(resource, resourceDescription);
        return resourceDescription;
    }

    protected IScope createLazyResourceScope(Resource importingResource, IScope parent, URI uri, IResourceDescriptions descriptions, EClass type, Predicate<IEObjectDescription> filter, boolean ignoreCase) {
        Object description = null;
        try {
            description = descriptions.getResourceDescription(uri);
        }
        catch (IllegalStateException e) {
            Resource importedResource = EcoreUtil2.getResource((Resource)importingResource, (String)uri.toString());
            String importAlias = CCSLKernelUtils.getImportAlias((Resource)importingResource, (Resource)importedResource);
            description = this.getOrCreateResourceDescription(importedResource, importAlias);
        }
        return SelectableBasedScope.createScope((IScope)parent, (ISelectable)description, filter, (EClass)type, (boolean)ignoreCase);
    }
}

