/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Position implements Enumerator
{
    NORTH_LITERAL(0, "NORTH", "NORTH"),
    WEST_LITERAL(1, "WEST", "WEST"),
    SOUTH_LITERAL(2, "SOUTH", "SOUTH"),
    EAST_LITERAL(3, "EAST", "EAST"),
    NORTH_WEST_LITERAL(4, "NORTH_WEST", "NORTH_WEST"),
    NORTH_EAST_LITERAL(5, "NORTH_EAST", "NORTH_EAST"),
    SOUTH_WEST_LITERAL(6, "SOUTH_WEST", "SOUTH_WEST"),
    SOUTH_EAST_LITERAL(7, "SOUTH_EAST", "SOUTH_EAST"),
    CENTER_LITERAL(8, "CENTER", "CENTER");

    public static final int NORTH = 0;
    public static final int WEST = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int NORTH_WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int SOUTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int CENTER = 8;
    private static final Position[] VALUES_ARRAY;
    public static final List<Position> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Position[]{NORTH_LITERAL, WEST_LITERAL, SOUTH_LITERAL, EAST_LITERAL, NORTH_WEST_LITERAL, NORTH_EAST_LITERAL, SOUTH_WEST_LITERAL, SOUTH_EAST_LITERAL, CENTER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Position get(String literal) {
        Position[] positionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            Position result = positionArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static Position getByName(String name) {
        Position[] positionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            Position result = positionArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static Position get(int value) {
        switch (value) {
            case 0: {
                return NORTH_LITERAL;
            }
            case 1: {
                return WEST_LITERAL;
            }
            case 2: {
                return SOUTH_LITERAL;
            }
            case 3: {
                return EAST_LITERAL;
            }
            case 4: {
                return NORTH_WEST_LITERAL;
            }
            case 5: {
                return NORTH_EAST_LITERAL;
            }
            case 6: {
                return SOUTH_WEST_LITERAL;
            }
            case 7: {
                return SOUTH_EAST_LITERAL;
            }
            case 8: {
                return CENTER_LITERAL;
            }
        }
        return null;
    }

    private Position(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

