/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public final class DViewHelper {
    private DViewHelper() {
    }

    public static void refreshViewContents(DView self) {
        HashSet<DRepresentation> representationsToDelete = new HashSet<DRepresentation>();
        for (DRepresentation dRepresentation : new DViewQuery(self).getLoadedRepresentations()) {
            if (dRepresentation instanceof DSemanticDecorator && ((DSemanticDecorator)((Object)dRepresentation)).getTarget() == null) {
                representationsToDelete.add(dRepresentation);
            }
            if (representationsToDelete.contains(dRepresentation)) continue;
            DialectManager.INSTANCE.refresh(dRepresentation, (IProgressMonitor)new NullProgressMonitor());
        }
        for (EObject eObject : representationsToDelete) {
            Session session = eObject instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)eObject).getTarget()) : SessionManager.INSTANCE.getSession(eObject);
            SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(eObject).eDelete(eObject, session != null ? session.getSemanticCrossReferencer() : null);
        }
    }
}

