/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.DomainReflectivePackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorType;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class ExecutorStandardLibrary
extends ExecutableStandardLibrary {
    private @NonNull Map<@NonNull String, WeakReference<EcoreExecutorPackage>> ePackageMap = new WeakHashMap<String, WeakReference<EcoreExecutorPackage>>();
    private Map<@NonNull Package, WeakReference<DomainReflectivePackage>> asPackageMap = null;
    private Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions = null;
    private Class classType = null;
    private Class enumerationType = null;

    public ExecutorStandardLibrary(EcoreExecutorPackage ... execPackages) {
        OCLstdlibTables.PACKAGE.getClass();
        EcoreExecutorPackage[] ecoreExecutorPackageArray = execPackages;
        int n = execPackages.length;
        int n2 = 0;
        while (n2 < n) {
            EcoreExecutorPackage execPackage = ecoreExecutorPackageArray[n2];
            assert (execPackage != null);
            this.addPackage(execPackage, null);
            ++n2;
        }
    }

    public void addExtension(@NonNull EcoreExecutorPackage basePackage, @NonNull EcoreExecutorPackage extensionPackage) {
        List<EcoreExecutorPackage> list;
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 == null) {
            this.extensions = extensions2 = new HashMap<EcoreExecutorPackage, List<EcoreExecutorPackage>>();
        }
        if ((list = extensions2.get(basePackage)) == null) {
            list = new ArrayList<EcoreExecutorPackage>();
            extensions2.put(basePackage, list);
        }
        list.add(extensionPackage);
    }

    public synchronized void addPackage(@NonNull EcoreExecutorPackage execPackage, @Nullable EcoreExecutorPackage extendedPackage) {
        String uri = execPackage.getURI();
        assert (uri != null);
        WeakReference<EcoreExecutorPackage> oldExecPackage = this.ePackageMap.put(uri, new WeakReference<EcoreExecutorPackage>(execPackage));
    }

    @Override
    public @NonNull Class getClassType() {
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 == null) {
            throw new IllegalStateException("No extension package registered to define Class type");
        }
        if (this.classType != null) {
            return this.classType;
        }
        this.classType = this.getPivotType("Class");
        if (this.classType != null) {
            return this.classType;
        }
        throw new IllegalStateException("No extension package defines Class type");
    }

    @Override
    public @NonNull Class getEnumerationType() {
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 == null) {
            throw new IllegalStateException("No extension package registered to define Enumeration type");
        }
        if (this.enumerationType != null) {
            return this.enumerationType;
        }
        this.enumerationType = this.getPivotType("Enumeration");
        if (this.enumerationType != null) {
            return this.enumerationType;
        }
        throw new IllegalStateException("No extension package defines Enumeration type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull Class asClass) {
        Map<Package, WeakReference<DomainReflectivePackage>> asPackageMap2;
        Class containerType;
        if (asClass instanceof CompleteInheritance) {
            return (CompleteInheritance)((Object)asClass);
        }
        if (asClass instanceof CollectionType && (containerType = ((CollectionType)asClass).getContainerType()) != asClass) {
            return containerType.getInheritance(this);
        }
        if (asClass instanceof MapType && (containerType = ((MapType)asClass).getContainerType()) != asClass) {
            return containerType.getInheritance(this);
        }
        Package asPackage = asClass.getOwningPackage();
        Object object = this;
        synchronized (object) {
            EcoreExecutorPackage ecoreExecutorPackage;
            String nsURI = asPackage.getURI();
            EcoreExecutorPackage ecoreExecutorPackage2 = ecoreExecutorPackage = nsURI != null ? this.weakGet(this.ePackageMap, nsURI) : null;
            if (ecoreExecutorPackage != null) {
                List<EcoreExecutorPackage> packages;
                String name = asClass.getName();
                ExecutorType executorType = ecoreExecutorPackage.getOwnedClass(name);
                if (executorType != null) {
                    return executorType;
                }
                Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
                if (extensions2 != null && (packages = extensions2.get(ecoreExecutorPackage)) != null) {
                    for (EcoreExecutorPackage extensionPackage : packages) {
                        executorType = extensionPackage.getOwnedClass(name);
                        if (executorType != null) break;
                    }
                }
                if (executorType != null) {
                    return executorType;
                }
            }
            if ((asPackageMap2 = this.asPackageMap) == null) {
                asPackageMap2 = this.asPackageMap = new WeakHashMap<Package, WeakReference<DomainReflectivePackage>>();
            }
        }
        object = asPackageMap2;
        synchronized (object) {
            DomainReflectivePackage executorPackage = this.weakGet(asPackageMap2, asPackage);
            if (executorPackage == null) {
                executorPackage = new DomainReflectivePackage(this, asPackage);
                asPackageMap2.put(asPackage, new WeakReference<DomainReflectivePackage>(executorPackage));
            }
            return executorPackage.getInheritance(asClass);
        }
    }

    @Override
    public @Nullable Class getNestedType(@NonNull Package parentPackage, @NonNull String name) {
        Class nestedType = NameUtil.getNameable(parentPackage.getOwnedClasses(), name);
        if (nestedType != null) {
            return nestedType;
        }
        nestedType = this.getPivotType(name);
        return nestedType;
    }

    @Override
    public Package getNsURIPackage(@NonNull String nsURI) {
        WeakReference<EcoreExecutorPackage> weakReference = this.ePackageMap.get(nsURI);
        if (weakReference == null) {
            return null;
        }
        return (Package)weakReference.get();
    }

    @Override
    public @NonNull Set<@NonNull String> getNsURIs() {
        return this.ePackageMap.keySet();
    }

    @Override
    public @NonNull Operation getOclInvalidOperation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Property getOclInvalidProperty() {
        throw new UnsupportedOperationException();
    }

    public synchronized @Nullable EcoreExecutorPackage getPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        return nsURI != null ? this.weakGet(this.ePackageMap, nsURI) : null;
    }

    @Override
    public synchronized Class getOclType(@NonNull String typeName) {
        for (WeakReference<EcoreExecutorPackage> dPackage : this.ePackageMap.values()) {
            ExecutorType type;
            EcoreExecutorPackage packageRef;
            if (dPackage == null || (packageRef = (EcoreExecutorPackage)dPackage.get()) == null || (type = packageRef.getOwnedClass(typeName)) == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public @Nullable Class getPivotType(@NonNull String className) {
        Map<EcoreExecutorPackage, List<EcoreExecutorPackage>> extensions2 = this.extensions;
        if (extensions2 != null) {
            for (List<EcoreExecutorPackage> packages : extensions2.values()) {
                for (EcoreExecutorPackage extensionPackage : packages) {
                    ExecutorType executorType = extensionPackage.getOwnedClass(className);
                    if (executorType == null) continue;
                    return executorType;
                }
            }
        }
        return null;
    }
}

