/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.executionframework.debugger.Activator;
import org.eclipse.gemoc.executionframework.debugger.GenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.engine.core.EngineStoppedException;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExplorer;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewNotifier;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class OmniscientGenericSequentialModelDebugger
extends GenericSequentialModelDebugger
implements ITraceViewListener {
    private ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer;
    private int steppingOverStackFrameIndex = -1;
    private int steppingReturnStackFrameIndex = -1;
    private final List<EObject> callerStack = new ArrayList<EObject>();
    private final List<Step<?>> previousCallStack = new ArrayList();

    public OmniscientGenericSequentialModelDebugger(IDSLDebugEventProcessor target, IExecutionEngine<?> engine) {
        super(target, engine);
    }

    private void pushStackFrame(String threadName, Step<?> step, EObject specificInstruction) {
        GenericSequentialModelDebugger.MSEFrameInformation info = this.getMSEFrameInformation(step);
        this.pushStackFrame(threadName, info.prettyLabel, info.caller, specificInstruction);
        this.callerStack.add(0, info.caller);
    }

    private void pushStackFrame(String threadName, Step<?> step) {
        GenericSequentialModelDebugger.MSEFrameInformation info = this.getMSEFrameInformation(step);
        this.pushStackFrame(threadName, info.prettyLabel, info.caller, info.caller);
        this.callerStack.add(0, info.caller);
    }

    @Override
    public void popStackFrame(String threadName) {
        super.popStackFrame(threadName);
        this.callerStack.remove(0);
    }

    @Override
    public void aboutToExecuteStep(IExecutionEngine<?> executionEngine, Step<?> step) {
        boolean shallContinue;
        MSEOccurrence mseOccurrence = step.getMseoccurrence();
        if (mseOccurrence != null && !(shallContinue = this.control("Model debugging", (EObject)step))) {
            throw new EngineStoppedException("Debug thread has stopped.");
        }
    }

    public void resume() {
        if (!this.executionTerminated) {
            boolean _isInReplayMode = this.traceExplorer.isInReplayMode();
            if (_isInReplayMode) {
                this.traceExplorer.loadLastState();
            }
            super.resume();
        }
    }

    public void resume(String threadName) {
        if (!this.executionTerminated) {
            boolean _isInReplayMode = this.traceExplorer.isInReplayMode();
            if (_isInReplayMode) {
                this.traceExplorer.loadLastState();
            }
            super.resume(threadName);
        }
    }

    @Override
    public void terminate() {
        super.terminate();
        Activator _default = Activator.getDefault();
        Supplier<OmniscientGenericSequentialModelDebugger> _function = () -> null;
        _default.setDebuggerSupplier(_function);
    }

    @Override
    protected void setupStepOverPredicateBreak() {
        if (this.steppingOverStackFrameIndex != -1) {
            final IExecutionEngine seqEngine = this.engine;
            List stack = this.traceExplorer.getCallStack();
            int _size = stack.size();
            int _minus = _size - this.steppingOverStackFrameIndex;
            int idx = _minus - 1;
            abstract class __OmniscientGenericSequentialModelDebugger_1
            implements BiPredicate<IExecutionEngine<?>, Step<?>> {
                Step<?> steppedOver;

                __OmniscientGenericSequentialModelDebugger_1() {
                }
            }
            __OmniscientGenericSequentialModelDebugger_1 ___OmniscientGenericSequentialModelDebugger_1 = new __OmniscientGenericSequentialModelDebugger_1(this, stack, idx){
                {
                    this.steppedOver = (Step)list.get(n);
                }

                @Override
                public boolean test(IExecutionEngine<?> t, Step<?> u) {
                    boolean _contains = seqEngine.getCurrentStack().contains(this.steppedOver);
                    return !_contains;
                }
            };
            this.addPredicateBreak(___OmniscientGenericSequentialModelDebugger_1);
            this.steppingOverStackFrameIndex = -1;
        } else {
            super.setupStepOverPredicateBreak();
        }
    }

    public void stepInto(String threadName) {
        if (this.traceExplorer.isInReplayMode() || this.executionTerminated) {
            if (!this.traceExplorer.stepInto() && !this.executionTerminated) {
                this.traceExplorer.loadLastState();
                super.stepInto(threadName);
            }
        } else {
            super.stepInto(threadName);
        }
    }

    public void stepOver(String threadName) {
        if (this.traceExplorer.isInReplayMode() || this.executionTerminated) {
            if (!this.traceExplorer.stepOver() && !this.executionTerminated) {
                this.steppingOverStackFrameIndex = this.nbStackFrames - 1;
                this.traceExplorer.loadLastState();
                super.stepOver(threadName);
            }
        } else {
            super.stepOver(threadName);
        }
    }

    @Override
    protected void setupStepReturnPredicateBreak() {
        if (this.steppingReturnStackFrameIndex != -1) {
            final IExecutionEngine seqEngine = this.engine;
            List stack = this.traceExplorer.getCallStack();
            int _size = stack.size();
            int _minus = _size - this.steppingReturnStackFrameIndex;
            int idx = _minus - 1;
            abstract class __OmniscientGenericSequentialModelDebugger_2
            implements BiPredicate<IExecutionEngine<?>, Step<?>> {
                Step<?> steppedReturn;

                __OmniscientGenericSequentialModelDebugger_2() {
                }
            }
            __OmniscientGenericSequentialModelDebugger_2 ___OmniscientGenericSequentialModelDebugger_2 = new __OmniscientGenericSequentialModelDebugger_2(this, stack, idx){
                {
                    this.steppedReturn = (Step)list.get(n);
                }

                @Override
                public boolean test(IExecutionEngine<?> t, Step<?> u) {
                    boolean _contains = seqEngine.getCurrentStack().contains(this.steppedReturn);
                    return !_contains;
                }
            };
            this.addPredicateBreak(___OmniscientGenericSequentialModelDebugger_2);
            this.steppingReturnStackFrameIndex = -1;
        } else {
            super.setupStepReturnPredicateBreak();
        }
    }

    public void stepReturn(String threadName) {
        if (this.traceExplorer.isInReplayMode() || this.executionTerminated) {
            if (!this.traceExplorer.stepReturn() && !this.executionTerminated) {
                this.steppingReturnStackFrameIndex = this.nbStackFrames - 2;
                this.traceExplorer.loadLastState();
                super.stepReturn(threadName);
            }
        } else {
            super.stepReturn(threadName);
        }
    }

    public void stepBackInto() {
        this.traceExplorer.stepBackInto();
    }

    public void stepBackOver() {
        this.traceExplorer.stepBackOver();
    }

    public void stepBackOut() {
        this.traceExplorer.stepBackOut();
    }

    public boolean canStepBackInto() {
        return this.traceExplorer.canStepBackInto();
    }

    public boolean canStepBackOver() {
        return this.traceExplorer.canStepBackOver();
    }

    public boolean canStepBackOut() {
        return this.traceExplorer.canStepBackOut();
    }

    @Override
    public boolean validateVariableValue(String threadName, String variableName, String value) {
        boolean _isInReplayMode = this.traceExplorer.isInReplayMode();
        if (_isInReplayMode) {
            Status _status = new Status(4, "org.eclipse.gemoc.executionframework.debugger", "Illegal variable value set");
            ErrorDialog.openError(null, (String)"Illegal variable value set", (String)"Cannot set the value of a variable when in replay mode", (IStatus)_status);
            return false;
        }
        return super.validateVariableValue(threadName, variableName, value);
    }

    @Override
    public void engineStarted(IExecutionEngine<?> executionEngine) {
        Activator activator = Activator.getDefault();
        Supplier<OmniscientGenericSequentialModelDebugger> _function = () -> this;
        activator.setDebuggerSupplier(_function);
        super.engineStarted(executionEngine);
        Set traceAddons = executionEngine.getAddonsTypedBy(IMultiDimensionalTraceAddon.class);
        IMultiDimensionalTraceAddon traceAddon = (IMultiDimensionalTraceAddon)traceAddons.iterator().next();
        this.traceExplorer = traceAddon.getTraceExplorer();
        ITraceViewNotifier.TraceViewCommand _function_1 = () -> this.update();
        this.traceExplorer.registerCommand((ITraceViewListener)this, _function_1);
    }

    @Override
    public void engineAboutToStop(IExecutionEngine<?> engine) {
        this.traceExplorer.loadLastState();
        super.engineAboutToStop(engine);
    }

    @Override
    public void engineStopped(IExecutionEngine<?> executionEngine) {
        Activator activator = Activator.getDefault();
        activator.setDebuggerSupplier(null);
        super.engineStopped(executionEngine);
    }

    @Override
    public void updateStack(String threadName, EObject instruction) {
        int i = 0;
        while (i < this.previousCallStack.size() && i < this.traceExplorer.getCallStack().size() && Objects.equal(this.previousCallStack.get(i), this.traceExplorer.getCallStack().get(i))) {
            ++i;
        }
        int j = i;
        while (j < this.previousCallStack.size()) {
            this.popStackFrame(threadName);
            ++j;
        }
        int callStackSize = this.traceExplorer.getCallStack().size();
        int j2 = i;
        while (j2 < callStackSize) {
            boolean _not;
            if (j2 > 0) {
                GenericSequentialModelDebugger.MSEFrameInformation info = this.getMSEFrameInformation((Step)this.traceExplorer.getCallStack().get(j2));
                this.setCurrentInstruction(threadName, info.caller);
            }
            if (j2 < callStackSize - 1) {
                Step childStep = (Step)this.traceExplorer.getCallStack().get(j2 + 1);
                EObject childCaller = this.getMSEFrameInformation(childStep).caller;
                this.pushStackFrame(threadName, (Step)this.traceExplorer.getCallStack().get(j2), childCaller);
            } else {
                this.pushStackFrame(threadName, (Step)this.traceExplorer.getCallStack().get(j2));
            }
            boolean _isEmpty = this.callerStack.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.setCurrentInstruction(threadName, this.callerStack.get(0));
            }
            ++j2;
        }
        this.previousCallStack.clear();
        this.previousCallStack.addAll(this.traceExplorer.getCallStack());
    }

    public void update() {
        block4: {
            if (this.executedModelRoot != null) {
                try {
                    boolean _not;
                    boolean _isEmpty = this.callerStack.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        Functions.Function1 _function = it -> true;
                        this.updateData("Model debugging", (EObject)IterableExtensions.findFirst(this.callerStack, (Functions.Function1)_function));
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof IllegalStateException) break block4;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }
}

