/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.addon.eaop.server.rpclaunch;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.gemoc.executionframework.addon.eaop.server.rpclaunch.EaopRemoteEndpoint;
import org.eclipse.gemoc.protocols.eaop.api.json.EaopMessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;

public class EaopJsonRPCLauncher {
    private EaopJsonRPCLauncher() {
    }

    public static <T> Launcher<T> createLauncher(Object localService, Class<T> remoteInterface, InputStream in, OutputStream out) {
        return new Builder().setLocalService(localService).setRemoteInterface(remoteInterface).setInput(in).setOutput(out).create();
    }

    public static class Builder<T>
    extends Launcher.Builder<T> {
        protected MessageJsonHandler createJsonHandler() {
            Map supportedMethods = this.getSupportedMethods();
            if (this.configureGson != null) {
                return new EaopMessageJsonHandler(supportedMethods, this.configureGson);
            }
            return new EaopMessageJsonHandler(supportedMethods);
        }

        protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
            try {
                StreamMessageConsumer outgoingMessageStream = new StreamMessageConsumer(this.output, jsonHandler);
                outgoingMessageStream = this.wrapMessageConsumer((MessageConsumer)outgoingMessageStream);
                Endpoint localEndpoint = ServiceEndpoints.toEndpoint((Collection)this.localServices);
                EaopRemoteEndpoint remoteEndpoint = this.exceptionHandler == null ? new EaopRemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint) : new EaopRemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint, this.exceptionHandler);
                jsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
                return remoteEndpoint;
            }
            catch (Exception e) {
                System.out.println("   issue in createRemoteEndpoint" + e);
                e.printStackTrace();
                return null;
            }
        }
    }
}

