/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.moccmlxdsml.metaprog;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.ILanguageComponentValidator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Message;
import org.eclipse.gemoc.xdsmlframework.api.extensions.metaprog.Severity;
import org.eclipse.ocl.xtext.basecs.PathElementWithURICS;
import org.eclipse.ocl.xtext.completeoclcs.impl.ClassifierContextDeclCSImpl;
import org.eclipse.ocl.xtext.completeoclcs.impl.PackageDeclarationCSImpl;

public class MOCCMLRule
implements ILanguageComponentValidator {
    public Message validate(Entry entry) {
        if ("ecl".matches(entry.getKey())) {
            URI uri = URI.createURI((String)("platform:/resource/" + entry.getValue()));
            if (!uri.isPlatformResource()) {
                return new Message("File for \"ale\" entry not in the workspace", Severity.ERROR);
            }
            ResourceSetImpl rs = new ResourceSetImpl();
            String ecoreModel = "";
            Boolean hasPackage = false;
            Boolean hasContext = false;
            try {
                Resource res = rs.getResource(uri, true);
                EList contents = ((EObject)res.getContents().get(0)).eContents();
                if (contents.isEmpty()) {
                    return new Message("No content in the ecl file", Severity.WARNING);
                }
                TreeIterator tree = res.getAllContents();
                while (tree.hasNext()) {
                    EObject node = (EObject)tree.next();
                    if (node instanceof PathElementWithURICS) {
                        PathElementWithURICS node2 = (PathElementWithURICS)node;
                        ecoreModel = node2.toString().replaceAll("'", "");
                    }
                    if (node instanceof PackageDeclarationCSImpl) {
                        hasPackage = true;
                    }
                    if (!(node instanceof ClassifierContextDeclCSImpl)) continue;
                    hasContext = true;
                }
                TreeIterator treeDSL = entry.eContainer().eAllContents();
                while (treeDSL.hasNext()) {
                    Entry node2;
                    EObject node = (EObject)treeDSL.next();
                    if (!(node instanceof Entry) || !"ecore".matches((node2 = (Entry)node).getKey()) || node2.getValue().matches(ecoreModel)) continue;
                    return new Message("Ecore model for ecl file not matching Ecore model in the dsl file.", Severity.WARNING);
                }
                if (!hasPackage.booleanValue()) {
                    return new Message("No package in the ecl file.", Severity.WARNING);
                }
                if (!hasContext.booleanValue()) {
                    return new Message("No context in the ecl file.", Severity.WARNING);
                }
            }
            catch (RuntimeException e) {
                return new Message("The file for the \"ecl\" does not exist", Severity.ERROR);
            }
        }
        return new Message("", Severity.DEFAULT);
    }
}

