/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.AbstractConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.ILogicalStepDecider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.DeciderException;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.core.AbstractExecutionEngine;
import org.eclipse.gemoc.executionframework.engine.core.EngineStoppedException;
import org.eclipse.gemoc.trace.commons.model.trace.ParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;

public abstract class AbstractConcurrentExecutionEngine<C extends AbstractConcurrentModelExecutionContext<R, ?, ?>, R extends IConcurrentRunConfiguration>
extends AbstractExecutionEngine<C, R> {
    private ILogicalStepDecider _logicalStepDecider;
    protected List<Step<?>> _possibleLogicalSteps = new ArrayList();
    private Step<?> _selectedLogicalStep;

    protected abstract List<Step<?>> computePossibleLogicalSteps();

    protected abstract void doAfterLogicalStepExecution(Step<?> var1);

    protected abstract void executeSmallStep(SmallStep<?> var1) throws CodeExecutionException;

    protected abstract void performSpecificInitialize(C var1);

    protected void beforeStart() {
    }

    public final void changeLogicalStepDecider(ILogicalStepDecider newDecider) {
        this._logicalStepDecider = newDecider;
    }

    public final ILogicalStepDecider getLogicalStepDecider() {
        return this._logicalStepDecider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Step<?> getSelectedLogicalStep() {
        AbstractConcurrentExecutionEngine abstractConcurrentExecutionEngine = this;
        synchronized (abstractConcurrentExecutionEngine) {
            return this._selectedLogicalStep;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSelectedLogicalStep(Step<?> ls) {
        AbstractConcurrentExecutionEngine abstractConcurrentExecutionEngine = this;
        synchronized (abstractConcurrentExecutionEngine) {
            this._selectedLogicalStep = ls;
        }
    }

    protected final void switchDeciderIfNecessary() {
        if (this.getLogicalStepDecider() != null && this.getLogicalStepDecider() != this._logicalStepDecider) {
            this._logicalStepDecider = this.getLogicalStepDecider();
        }
    }

    protected final void performStart() {
        this.engineStatus.setNbLogicalStepRun(0L);
        try {
            while (!this._isStopped) {
                this.performExecutionStep();
            }
        }
        catch (EngineStoppedException ese) {
            throw ese;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected final void performStop() {
        this.setSelectedLogicalStep(null);
        if (this.getLogicalStepDecider() != null) {
            this.getLogicalStepDecider().preempt();
        }
    }

    protected final void executeSelectedLogicalStep() throws CodeExecutionException {
        if (!this._isStopped) {
            this.beforeExecutionStep(this._selectedLogicalStep);
            for (Step step : ((ParallelStep)this._selectedLogicalStep).getSubSteps()) {
                SmallStep sstep = (SmallStep)step;
                this.executeSmallStep(sstep);
            }
            this.afterExecutionStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Step<?>> getPossibleLogicalSteps() {
        AbstractConcurrentExecutionEngine abstractConcurrentExecutionEngine = this;
        synchronized (abstractConcurrentExecutionEngine) {
            return new ArrayList(this._possibleLogicalSteps);
        }
    }

    protected final Step<?> selectAndExecuteLogicalStep() throws CodeExecutionException, DeciderException {
        this.setEngineStatus(EngineStatus.RunStatus.WaitingLogicalStepSelection);
        this.notifyAboutToSelectLogicalStep();
        Step<?> selectedLogicalStep = this.getLogicalStepDecider().decide(this, this.getPossibleLogicalSteps());
        if (selectedLogicalStep != null) {
            this.setSelectedLogicalStep(selectedLogicalStep);
            this.setEngineStatus(EngineStatus.RunStatus.Running);
            this.notifyLogicalStepSelected();
            this.executeSelectedLogicalStep();
        }
        return selectedLogicalStep;
    }

    protected void performExecutionStep() {
        this.switchDeciderIfNecessary();
        this._possibleLogicalSteps = this.computePossibleLogicalSteps();
        if (this._possibleLogicalSteps.size() == 0) {
            Activator.getDefault().debug("No more LogicalStep to run");
            this.stop();
        } else {
            try {
                Step<?> selectedLogicalStep = this.selectAndExecuteLogicalStep();
                if (selectedLogicalStep != null) {
                    this.doAfterLogicalStepExecution(selectedLogicalStep);
                    this.engineStatus.incrementNbLogicalStepRun();
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    protected final void performInitialize(C executionContext) {
        this.changeLogicalStepDecider(((AbstractConcurrentModelExecutionContext)((Object)executionContext)).getLogicalStepDecider());
        this.performSpecificInitialize(executionContext);
        Activator.getDefault().debug("*** Engine initialization done. ***");
    }

    protected final void notifyAboutToSelectLogicalStep() {
        for (IEngineAddon addon : ((AbstractConcurrentModelExecutionContext)this.getExecutionContext()).getExecutionPlatform().getEngineAddons()) {
            try {
                addon.aboutToSelectStep((IExecutionEngine)this, this.getPossibleLogicalSteps());
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception in Addon " + addon + ", " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected final void notifyLogicalStepSelected() {
        for (IEngineAddon addon : ((AbstractConcurrentModelExecutionContext)this.getExecutionContext()).getExecutionPlatform().getEngineAddons()) {
            try {
                addon.stepSelected((IExecutionEngine)this, this.getSelectedLogicalStep());
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception in Addon " + addon + ", " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected final void notifyProposedLogicalStepsChanged() {
        for (IEngineAddon addon : ((AbstractConcurrentModelExecutionContext)this.getExecutionContext()).getExecutionPlatform().getEngineAddons()) {
            try {
                addon.proposedStepsChanged((IExecutionEngine)this, this.getPossibleLogicalSteps());
            }
            catch (Exception e) {
                Activator.getDefault().error("Exception in Addon " + addon + ", " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

