/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.diffviewer.views;

import java.util.Map;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gemoc.addon.diffviewer.Activator;
import org.eclipse.gemoc.addon.diffviewer.views.TimelineDiffViewerRenderer;
import org.eclipse.gemoc.addon.diffviewer.views.TraceSectionsDialog;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.AbstractEngineAction;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.traceaddon.AbstractTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class TimelineDiffViewerViewPart
extends ViewPart {
    public static final String ID = "org.eclipse.gemoc.addon.diffviewer.views.TimelineDiffViewerRenderer";
    private FXCanvas fxCanvas;
    private TimelineDiffViewerRenderer diffViewer;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor1;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> extractor2;

    public void createPartControl(Composite parent) {
        this.fxCanvas = new FXCanvas(parent, 0);
        this.diffViewer = new TimelineDiffViewerRenderer();
        Scene scene = new Scene((Parent)this.diffViewer);
        this.fxCanvas.setScene(scene);
        parent.getShell().addListener(11, e -> this.diffViewer.refresh());
        this.buildMenu(parent.getShell());
    }

    private void buildMenu(final Shell shell) {
        this.addActionToToolbar((Action)new AbstractEngineAction(1){
            private FileDialog fileDialog;

            protected void init() {
                super.init();
                this.setText("Compare Traces");
                this.setToolTipText("Compare Traces");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.diffviewer", (String)"icons/insp_sbook.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
                this.fileDialog = new FileDialog(shell, 4096);
                this.fileDialog.setFilterExtensions(new String[]{"*.trace"});
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                this.fileDialog.setText("Choose a first trace to load");
                String filePath1 = this.fileDialog.open();
                if (filePath1 != null && !filePath1.equals("")) {
                    this.fileDialog.setText("Choose a second trace to load");
                    String filePath2 = this.fileDialog.open();
                    if (filePath2 != null && !filePath2.equals("")) {
                        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                        Map m = reg.getExtensionToFactoryMap();
                        m.put("trace", new XMIResourceFactoryImpl());
                        ResourceSetImpl resSet = new ResourceSetImpl();
                        URI filePath1URI = URI.createFileURI((String)filePath1);
                        Resource traceResource1 = resSet.getResource(filePath1URI, true);
                        EcoreUtil.resolveAll((Resource)traceResource1);
                        URI filePath2URI = URI.createFileURI((String)filePath2);
                        Resource traceResource2 = resSet.getResource(filePath2URI, true);
                        EcoreUtil.resolveAll((Resource)traceResource2);
                        AbstractTraceAddon newTraceAddon = null;
                        try {
                            IExtensionRegistry extReg = Platform.getExtensionRegistry();
                            IExtensionPoint ep = extReg.getExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.engine_addon");
                            IExtension[] extensions = ep.getExtensions();
                            int i = 0;
                            while (i < extensions.length && newTraceAddon == null) {
                                IExtension ext = extensions[i];
                                IConfigurationElement[] confElements = ext.getConfigurationElements();
                                int j = 0;
                                while (j < confElements.length) {
                                    AbstractTraceAddon obj_cast;
                                    Object obj;
                                    IConfigurationElement confElement = confElements[j];
                                    String attr = confElement.getAttribute("Class");
                                    if (attr != null && (obj = confElement.createExecutableExtension("Class")) instanceof AbstractTraceAddon && (obj_cast = (AbstractTraceAddon)obj).isAddonForTrace((EObject)traceResource1.getContents().get(0)) && obj_cast.isAddonForTrace((EObject)traceResource2.getContents().get(0))) {
                                        newTraceAddon = obj_cast;
                                        break;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        if (newTraceAddon != null) {
                            newTraceAddon.load(traceResource1);
                            TimelineDiffViewerViewPart.this.extractor1 = newTraceAddon.getTraceExtractor();
                            newTraceAddon.load(traceResource2);
                            TimelineDiffViewerViewPart.this.extractor2 = newTraceAddon.getTraceExtractor();
                            TimelineDiffViewerViewPart.this.diffViewer.loadTraces(TimelineDiffViewerViewPart.this.extractor1, TimelineDiffViewerViewPart.this.extractor2);
                        }
                    }
                }
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(1){

            protected void init() {
                super.init();
                this.setText("Select Trace Sections");
                this.setToolTipText("Select Trace Sections");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.diffviewer", (String)"icons/scoped_ovr.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                TraceSectionsDialog dialog = new TraceSectionsDialog(shell, TimelineDiffViewerViewPart.this.extractor1, TimelineDiffViewerViewPart.this.extractor2);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    TimelineDiffViewerViewPart.this.diffViewer.loadTraces(TimelineDiffViewerViewPart.this.extractor1, TimelineDiffViewerViewPart.this.extractor2, dialog.getS1(), dialog.getS2(), dialog.getE1(), dialog.getE2());
                }
            }
        });
    }

    private void addActionToToolbar(Action action) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)action);
    }

    public void setFocus() {
        if (this.fxCanvas != null) {
            this.fxCanvas.setFocus();
        }
    }
}

