/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.sirius;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.generic.api.scopes.IPersistentDataScope;
import org.eclipse.emf.diffmerge.gmf.GMFScope;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public class SiriusScope
extends GMFScope {
    public static final String SESSION_RESOURCE_FRAGMENT_EXTENSION = "airdfragment";
    public static final Collection<String> SIRIUS_FILE_EXTENSIONS = Arrays.asList("aird", "airdfragment");
    protected static final Collection<? extends EPackage> SIRIUS_PACKAGES = Arrays.asList(ViewpointPackage.eINSTANCE, StylePackage.eINSTANCE, NotationPackage.eINSTANCE, DiagramPackage.eINSTANCE);
    protected static final EReference SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE = ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Representation();
    protected final Map<String, DRepresentationDescriptor> _idToDescriptor = new HashMap<String, DRepresentationDescriptor>();

    public SiriusScope(URI uri_p, EditingDomain domain, boolean readOnly_p) {
        super(uri_p, domain, readOnly_p);
    }

    public SiriusScope(URI uri_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        super(uri_p, resourceSet_p, readOnly_p);
    }

    public SiriusScope(Collection<URI> uris_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        super(uris_p, editingDomain_p, readOnly_p);
    }

    public SiriusScope(Collection<URI> uris_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        super(uris_p, resourceSet_p, readOnly_p);
    }

    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result;
        boolean isDescriptorToRepresentation;
        boolean bl = isDescriptorToRepresentation = reference_p == SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE;
        if (isDescriptorToRepresentation) {
            this.add(value_p);
        }
        if ((result = super.add(source_p, reference_p, value_p)) && isDescriptorToRepresentation) {
            this.registerRepresentationDescriptor((DRepresentationDescriptor)source_p);
        }
        return result;
    }

    public EObject getContainer(EObject element_p) {
        if (element_p instanceof DRepresentationDescriptor) {
            this.registerRepresentationDescriptor((DRepresentationDescriptor)element_p);
        }
        EObject basicContainer = super.getContainer(element_p);
        Object result = element_p instanceof DRepresentation && basicContainer == null ? this.getRepresentationDescriptor((DRepresentation)element_p) : basicContainer;
        return result;
    }

    public EReference getContainment(EObject element_p) {
        EReference result = element_p instanceof DRepresentation ? (this.getContainer(element_p) instanceof DRepresentationDescriptor ? SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE : super.getContainment(element_p)) : super.getContainment(element_p);
        return result;
    }

    public List<EObject> getContents() {
        List superResult = super.getContents();
        FArrayList result = new FArrayList((Collection)superResult, null);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            EObject current = (EObject)it.next();
            if (!(current instanceof DRepresentation) || this.getContainer(current) == null) continue;
            it.remove();
        }
        return Collections.unmodifiableList(result);
    }

    public List<EObject> getContents(EObject element_p) {
        List result = super.getContents(element_p);
        if (element_p instanceof DRepresentationDescriptor) {
            DRepresentationDescriptor descriptor = (DRepresentationDescriptor)element_p;
            this.registerRepresentationDescriptor(descriptor);
            DRepresentation referenced = descriptor.getRepresentation();
            if (referenced != null) {
                List originalResult = result;
                result = new FArrayList(originalResult.size() + 1, null);
                result.addAll(originalResult);
                result.add(referenced);
            }
        }
        return result;
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        Collection result = super.getCrossReferencesInScope(element_p);
        if (element_p instanceof DSemanticDecorator) {
            result.add(ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        } else if (element_p instanceof DAnalysis) {
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_ReferencedAnalysis());
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_Models());
        } else if (element_p instanceof DRepresentationDescriptor) {
            result.add(SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE);
        }
        return result;
    }

    protected String getReferencedUID(DRepresentationDescriptor descriptor_p) {
        URI uri;
        String result = null;
        ResourceDescriptor rDescriptor = descriptor_p.getRepPath();
        if (rDescriptor != null && (uri = rDescriptor.getResourceURI()) != null) {
            result = uri.fragment();
        }
        return result;
    }

    public DRepresentationDescriptor getRepresentationDescriptor(DRepresentation representation_p) {
        String repID = representation_p.getUid();
        DRepresentationDescriptor result = this._idToDescriptor.get(repID);
        if (result == null) {
            DRepresentationQuery rep2descQuery = new DRepresentationQuery(representation_p);
            result = rep2descQuery.getRepresentationDescriptor();
            if (result == null) {
                result = this.getRepresentationDescriptorByExploration(representation_p);
            }
            if (result != null) {
                this.registerRepresentationDescriptor(result);
            }
        }
        return result;
    }

    protected DRepresentationDescriptor getRepresentationDescriptorByExploration(DRepresentation representation_p) {
        return SiriusScope.getRepresentationDescriptorByPhysicalExploration(representation_p, (IPersistentDataScope<EObject>)this);
    }

    public static DRepresentationDescriptor getRepresentationDescriptorByPhysicalExploration(DRepresentation representation_p, IPersistentDataScope<EObject> scope_p) {
        List roots = scope_p.getRawRoots();
        for (EObject root : roots) {
            if (!(root instanceof DAnalysis)) continue;
            for (DView view : ((DAnalysis)root).getOwnedViews()) {
                for (DRepresentationDescriptor descriptor : view.getOwnedRepresentationDescriptors()) {
                    if (descriptor.getRepresentation() != representation_p) continue;
                    return descriptor;
                }
            }
        }
        return null;
    }

    protected Resource getSessionResource() {
        for (Resource candidate : this.getResources()) {
            if (!this.isSessionResource(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public Session getSession() {
        Session sessionForURI;
        Resource sessionResource;
        Session result = null;
        if (this.getEditingDomain() != null && (sessionResource = this.getSessionResource()) != null && (sessionForURI = SessionManager.INSTANCE.getExistingSession(sessionResource.getURI())) != null && sessionForURI.getSessionResource() == sessionResource) {
            result = sessionForURI;
        }
        return result;
    }

    protected boolean isSessionResource(Resource resource_p) {
        URI uri = resource_p.getURI();
        return uri != null && this.isSessionResourceURI(uri);
    }

    protected boolean isSessionResourceURI(URI uri_p) {
        return "aird".equals(uri_p.fileExtension());
    }

    protected boolean isSiriusElement(EObject element_p) {
        EPackage pack = element_p.eClass().getEPackage();
        return SIRIUS_PACKAGES.contains(pack) || element_p instanceof DRepresentation;
    }

    protected boolean isSiriusResource(Resource resource_p) {
        String extension;
        boolean result = false;
        if (resource_p.getURI() != null && (extension = resource_p.getURI().fileExtension()) != null) {
            extension = extension.toLowerCase();
            result = SIRIUS_FILE_EXTENSIONS.contains(extension);
        }
        return result;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        boolean result = this.isSiriusResource(resource_p) == this.isSiriusElement(root_p);
        return result;
    }

    public boolean mIsContainmentReference(Object reference_p) {
        return reference_p == SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE || super.mIsContainmentReference(reference_p);
    }

    protected void notifyExplored(EObject element_p) {
        if (element_p instanceof DRepresentationDescriptor) {
            this.registerRepresentationDescriptor((DRepresentationDescriptor)element_p);
        }
    }

    protected void registerRepresentationDescriptor(DRepresentationDescriptor descriptor_p) {
        String uid = this.getReferencedUID(descriptor_p);
        if (uid != null) {
            this._idToDescriptor.put(uid, descriptor_p);
        }
    }

    public boolean remove(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result;
        boolean isDescriptorToRepresentation = reference_p == SIRIUS_DESCRIPTOR_TO_REPRESENTATION_FEATURE;
        String uid = null;
        if (isDescriptorToRepresentation) {
            uid = this.getReferencedUID((DRepresentationDescriptor)source_p);
        }
        if ((result = super.remove(source_p, reference_p, value_p)) && isDescriptorToRepresentation) {
            this._idToDescriptor.remove(uid);
        }
        return result;
    }

    public IStatus save() {
        IStatus result;
        Session session = this.getSession();
        if (session != null) {
            session.save((IProgressMonitor)new NullProgressMonitor());
            result = Status.OK_STATUS;
        } else {
            result = super.save();
        }
        return result;
    }
}

