/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import org.eclipse.elk.alg.rectpacking.util.DrawingDataDescriptor;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;

public class DrawingData {
    private double scaleMeasure;
    private double drawingWidth;
    private double drawingHeight;
    private double area;
    private double aspectRatio;
    private double dar;
    private DrawingDataDescriptor placementOption;
    private double nextXcoordinate;
    private double nextYcoordinate;

    public DrawingData(double dar, double drawingWidth, double drawingHeight, DrawingDataDescriptor placementOption) {
        this(dar, drawingWidth, drawingHeight, placementOption, 0.0, 0.0);
    }

    public DrawingData(double dar, double drawingWidth, double drawingHeight, DrawingDataDescriptor placementOption, double nextXcoord, double nextYcoord) {
        this.dar = dar;
        this.drawingWidth = drawingWidth;
        this.drawingHeight = drawingHeight;
        this.placementOption = placementOption;
        this.nextXcoordinate = nextXcoord;
        this.nextYcoordinate = nextYcoord;
        this.calcAreaAspectRatioScaleMeasure();
    }

    private void calcAreaAspectRatioScaleMeasure() {
        if (this.drawingWidth > 0.0 && this.drawingHeight > 0.0) {
            this.area = this.drawingWidth * this.drawingHeight;
            this.aspectRatio = this.drawingWidth / this.drawingHeight;
            this.scaleMeasure = DrawingUtil.computeScaleMeasure(this.drawingWidth, this.drawingHeight, this.dar);
        }
    }

    public double getDrawingWidth() {
        return this.drawingWidth;
    }

    public void setDrawingWidth(double drawingWidth) {
        this.drawingWidth = drawingWidth;
        this.calcAreaAspectRatioScaleMeasure();
    }

    public double getDrawingHeight() {
        return this.drawingHeight;
    }

    public void setDrawingHeight(double drawingHeight) {
        this.drawingHeight = drawingHeight;
        this.calcAreaAspectRatioScaleMeasure();
    }

    public double getScaleMeasure() {
        return this.scaleMeasure;
    }

    public double getArea() {
        return this.area;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public DrawingDataDescriptor getPlacementOption() {
        return this.placementOption;
    }

    public void setPlacementOption(DrawingDataDescriptor placementOption) {
        this.placementOption = placementOption;
    }

    public double getNextXcoordinate() {
        return this.nextXcoordinate;
    }

    public void setNextXcoordinate(double potentialX) {
        this.nextXcoordinate = potentialX;
    }

    public double getNextYcoordinate() {
        return this.nextYcoordinate;
    }

    public void setNextYcoordinate(double potentialY) {
        this.nextYcoordinate = potentialY;
    }
}

