/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.helpers;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.BDDHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;

public abstract class AbstractSemanticHelper {
    private BuDDyFactory BuDDyFactory;
    private BDDHelper bddHelper;

    public AbstractSemanticHelper(BDDHelper bddHelper) {
        this.setBDDHelper(bddHelper);
        this.setBuddyFactory(bddHelper.getFactory());
    }

    protected BDDHelper getBDDHelper() {
        return this.bddHelper;
    }

    protected BDDHelper getBddHelper() {
        return this.bddHelper;
    }

    protected void setBDDHelper(BDDHelper bddHelper) {
        this.bddHelper = bddHelper;
    }

    protected BuDDyFactory getBuddyFactory() {
        return this.BuDDyFactory;
    }

    protected void setBuddyFactory(BuDDyFactory BuDDyFactory2) {
        this.BuDDyFactory = BuDDyFactory2;
    }

    public BuDDyFactory.BuDDyBDD getBDDVariable(RuntimeClock clk) {
        return this.getBuddyFactory().ithVar(clk.bddVariableNumber);
    }

    public BuDDyFactory.BuDDyBDD getFalseBDDVariable(RuntimeClock clk) {
        return this.createNot(clk);
    }

    public BuDDyFactory.BuDDyBDD createAnd(RuntimeClock c1, RuntimeClock c2) {
        BuDDyFactory.BuDDyBDD arg1 = this.getBuddyFactory().ithVar(c1.bddVariableNumber);
        BuDDyFactory.BuDDyBDD arg2 = this.getBuddyFactory().ithVar(c2.bddVariableNumber);
        return arg1.and(arg2);
    }

    public BuDDyFactory.BuDDyBDD createAnd(BuDDyFactory.BuDDyBDD t1, BuDDyFactory.BuDDyBDD t2) {
        return t1.andWith(t2);
    }

    public BuDDyFactory.BuDDyBDD createNot(RuntimeClock clk) {
        BuDDyFactory.BuDDyBDD arg = this.getBuddyFactory().nithVar(clk.bddVariableNumber);
        return arg;
    }

    public BuDDyFactory.BuDDyBDD createImplies(RuntimeClock c1, RuntimeClock c2) {
        if (c1 == c2 || c1.bddVariableNumber == c2.bddVariableNumber) {
            return this.createOne();
        }
        BuDDyFactory.BuDDyBDD arg1 = this.getBuddyFactory().ithVar(c1.bddVariableNumber);
        BuDDyFactory.BuDDyBDD arg2 = this.getBuddyFactory().ithVar(c2.bddVariableNumber);
        return arg1.imp(arg2);
    }

    public BuDDyFactory.BuDDyBDD createEqual(RuntimeClock c1, RuntimeClock c2) {
        if (c1 == c2 || c1.bddVariableNumber == c2.bddVariableNumber) {
            return this.createOne();
        }
        return this.getBddHelper().createEqual(c1.bddVariableNumber, c2.bddVariableNumber);
    }

    public BuDDyFactory.BuDDyBDD createEqual(RuntimeClock clk, BuDDyFactory.BuDDyBDD term) {
        return this.getBddHelper().createEqual(this.getBuddyFactory().ithVar(clk.bddVariableNumber), term);
    }

    public BuDDyFactory.BuDDyBDD createEqual(BuDDyFactory.BuDDyBDD t1, BuDDyFactory.BuDDyBDD t2) {
        return this.getBddHelper().createEqual(t1, t2);
    }

    public BuDDyFactory.BuDDyBDD createExclusion(RuntimeClock c1, RuntimeClock c2) {
        BuDDyFactory.BuDDyBDD res = this.getBddHelper().createExclusion(c1.bddVariableNumber, c2.bddVariableNumber);
        return res;
    }

    public BuDDyFactory.BuDDyBDD createUnion(RuntimeClock c1, RuntimeClock c2) {
        return this.getBddHelper().createUnion(c1.bddVariableNumber, c2.bddVariableNumber);
    }

    public BuDDyFactory.BuDDyBDD createIntersection(RuntimeClock c1, RuntimeClock c2) {
        return this.getBddHelper().createInter(c1.bddVariableNumber, c2.bddVariableNumber);
    }

    public BuDDyFactory.BuDDyBDD createIntersection(RuntimeClock clk, BuDDyFactory.BuDDyBDD term) {
        return this.getBddHelper().createInter(this.getBuddyFactory().ithVar(clk.bddVariableNumber), term);
    }

    public BuDDyFactory.BuDDyBDD createOne() {
        return this.getBuddyFactory().one();
    }

    public void inhibitClock(RuntimeClock clk) {
        this.semanticBDDAnd(this.createNot(clk));
    }

    public void registerClockEquality(RuntimeClock leftClock, RuntimeClock rightClock) {
        this.semanticBDDAnd(this.createEqual(leftClock, rightClock));
    }

    public void registerClockImplication(RuntimeClock leftClock, RuntimeClock rightClock) {
        this.semanticBDDAnd(this.createImplies(leftClock, rightClock));
    }

    public abstract void semanticBDDAnd(BuDDyFactory.BuDDyBDD var1);

    public void assertionSemantic(AbstractRuntimeRelation relation, BuDDyFactory.BuDDyBDD term) {
        BuDDyFactory.BuDDyBDD assertionVar = this.getAssertionVariable(relation);
        BuDDyFactory.BuDDyBDD res = this.getBddHelper().createEqual(term, assertionVar);
        this.semanticBDDAnd(res);
        this.registerAssertion(relation);
    }

    public abstract void registerAssertion(AbstractRuntimeRelation var1);

    public BuDDyFactory.BuDDyBDD getAssertionVariable(AbstractRuntimeRelation relation) {
        return this.getBuddyFactory().ithVar(relation.getAssertionVariable());
    }

    public abstract Set<RuntimeClock> getUsedClocks();

    public abstract void registerClockUse(RuntimeClock var1);

    public void registerClockUse(RuntimeClock[] clocks) {
        RuntimeClock[] runtimeClockArray = clocks;
        int n = clocks.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeClock clock = runtimeClockArray[n2];
            this.registerClockUse(clock);
            ++n2;
        }
    }

    public abstract boolean isSemanticDone(ICCSLConstraint var1);

    public abstract void registerSemanticDone(ICCSLConstraint var1);

    public abstract void registerClockToStart(RuntimeClock var1);

    public abstract void unregisterClockToStart(RuntimeClock var1);

    public abstract void unregisterDeadClock(RuntimeClock var1);

    public abstract void registerDeathEquality(RuntimeClock var1, RuntimeClock var2);

    public abstract void registerDeathImplication(RuntimeClock var1, RuntimeClock var2);

    public abstract void registerDeathConjunctionImplies(RuntimeClock var1, RuntimeClock var2, RuntimeClock var3);

    public abstract void registerDeadClock(RuntimeClock var1);

    public abstract void forceDeath(RuntimeClock var1);

    public abstract AbstractUpdateHelper getUpdateHelper();
}

