/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.test.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Date;

public class GEMOCTestVideoHelper {
    public static String LOGFILEPATH = "gemoc-studio/dev_support/tycho_full_compilation/target/system_test_timeline.log";

    public static void addTestSuiteVideoLog(String msg) {
        File file = GEMOCTestVideoHelper.getVideoTimeStampFile();
        if (!file.exists()) {
            System.out.println("ignoring addTestSuiteVideoLog");
            System.out.println(String.valueOf(file.getPath()) + " not found");
            return;
        }
        try {
            Date videoStartDate = GEMOCTestVideoHelper.readTimeStamp();
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter printwriter = new PrintWriter(new FileWriter(file, true));){
                Date currentDate = new Date();
                Duration duration = Duration.between(currentDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), videoStartDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                printwriter.println(String.format("%1$-14s", duration) + " | " + currentDate + " | " + msg);
                System.out.println(String.format("%1$-14s", duration) + " | " + currentDate + " | " + msg);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date readTimeStamp() throws IOException, ParseException {
        Throwable throwable = null;
        Object var1_2 = null;
        try {
            BufferedReader br;
            FileReader fr;
            block12: {
                Date date;
                fr = new FileReader(GEMOCTestVideoHelper.getVideoTimeStampFile());
                try {
                    block13: {
                        br = new BufferedReader(fr);
                        try {
                            String line = br.readLine();
                            if (line == null) break block12;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssXXX");
                            date = sdf.parse(line);
                            if (br == null) break block13;
                        }
                        catch (Throwable throwable2) {
                            if (br == null) throw throwable2;
                            br.close();
                            throw throwable2;
                        }
                        br.close();
                    }
                    if (fr == null) return date;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return date;
            }
            if (br != null) {
                br.close();
            }
            if (fr == null) return null;
            fr.close();
            return null;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    public static File getVideoTimeStampFile() {
        String jenkinsWorkspaceDir = System.getProperty("WORKSPACE");
        File file = new File(String.valueOf(jenkinsWorkspaceDir) + "/" + LOGFILEPATH);
        return file;
    }
}

