/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.tracemetamodel.StepStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class TraceMMGeneratorSteps {
  private final OperationalSemanticsView mmext;
  
  private final TraceMMExplorer traceMMExplorer;
  
  private final boolean gemoc;
  
  private final EPackage tracemmresult;
  
  private final TraceMMGenerationTraceability traceability;
  
  private final Map<Rule, EClass> stepRuleToClass = new HashMap<Rule, EClass>();
  
  private final String randomStringToFindGetCallerAnnotations = Integer.valueOf(new Random(10000).nextInt()).toString();
  
  private static final String GET_CALLER_OPERATION_NAME = "getCaller";
  
  public TraceMMGeneratorSteps(final OperationalSemanticsView mmext, final EPackage tracemmresult, final TraceMMGenerationTraceability traceability, final TraceMMExplorer traceMMExplorer, final boolean gemoc) {
    this.traceability = traceability;
    this.tracemmresult = tracemmresult;
    this.traceMMExplorer = traceMMExplorer;
    this.mmext = mmext;
    this.gemoc = gemoc;
  }
  
  private void debug(final Object stuff) {
  }
  
  private Set<Rule> gatherRulesThatOverride(final Rule rule) {
    final Set<Rule> result = new HashSet<Rule>();
    result.add(rule);
    result.addAll(rule.getOverridenBy());
    EList<Rule> _overridenBy = rule.getOverridenBy();
    for (final Rule ov : _overridenBy) {
      result.addAll(this.gatherRulesThatOverride(ov));
    }
    return result;
  }
  
  private Set<Rule> gatherStepCalls(final Rule rule, final Set<Rule> inProgress) {
    final Set<Rule> result = new HashSet<Rule>();
    boolean _contains = inProgress.contains(rule);
    boolean _not = (!_contains);
    if (_not) {
      inProgress.add(rule);
      boolean _isStepRule = rule.isStepRule();
      if (_isStepRule) {
        result.add(rule);
      } else {
        EList<Rule> _calledRules = rule.getCalledRules();
        for (final Rule called : _calledRules) {
          {
            final Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
            result.addAll(gathered);
          }
        }
      }
    }
    return result;
  }
  
  private EClass getStepClass(final Rule stepRule) {
    boolean _containsKey = this.stepRuleToClass.containsKey(stepRule);
    if (_containsKey) {
      return this.stepRuleToClass.get(stepRule);
    } else {
      final EClass stepClass = EcoreFactory.eINSTANCE.createEClass();
      this.traceMMExplorer.stepsPackage.getEClassifiers().add(stepClass);
      this.stepRuleToClass.put(stepRule, stepClass);
      this.traceability.addStepRuleToStepClass(stepRule, stepClass);
      return stepClass;
    }
  }
  
  private void setClassNameWithoutConflict(final EClass clazz, final String name) {
    final Function1<EClass, Boolean> _function = (EClass c) -> {
      return Boolean.valueOf(((!Objects.equal(c.getName(), null)) && c.getName().startsWith(name)));
    };
    final int nbExistingClassesWithName = IterableExtensions.size(IterableExtensions.<EClass>filter(Iterables.<EClass>filter(IteratorExtensions.<EObject>toSet(this.tracemmresult.eAllContents()), EClass.class), _function));
    if ((nbExistingClassesWithName > 0)) {
      clazz.setName(((name + "_") + Integer.valueOf(nbExistingClassesWithName)));
    } else {
      clazz.setName(name);
    }
  }
  
  public void process() {
    EList<Rule> _rules = this.mmext.getRules();
    for (final Rule rule : _rules) {
      List<Rule> _immutableCopy = ImmutableList.<Rule>copyOf(rule.getCalledRules());
      for (final Rule calledRule : _immutableCopy) {
        {
          final Set<Rule> overrides = this.gatherRulesThatOverride(calledRule);
          rule.getCalledRules().addAll(overrides);
        }
      }
    }
    final Predicate<Rule> _function = (Rule it) -> {
      return it.isAbstract();
    };
    this.mmext.getRules().removeIf(_function);
    EList<Rule> _rules_1 = this.mmext.getRules();
    for (final Rule rule_1 : _rules_1) {
      final Predicate<Rule> _function_1 = (Rule it) -> {
        return it.isAbstract();
      };
      rule_1.getCalledRules().removeIf(_function_1);
    }
    final Function1<Rule, Boolean> _function_2 = (Rule r) -> {
      return Boolean.valueOf(r.isStepRule());
    };
    final Set<Rule> stepRules = IterableExtensions.<Rule>toSet(IterableExtensions.<Rule>filter(this.mmext.getRules(), _function_2));
    Set<Rule> _immutableCopy_1 = ImmutableSet.<Rule>copyOf(stepRules);
    for (final Rule rule_2 : _immutableCopy_1) {
      {
        final Set<Rule> overrides = this.gatherRulesThatOverride(rule_2);
        for (final Rule o : overrides) {
          {
            o.setStepRule(true);
            stepRules.add(o);
          }
        }
      }
    }
    for (final Rule rule_3 : stepRules) {
      {
        final Function1<Rule, Boolean> _function_3 = (Rule r) -> {
          boolean _isStepRule = r.isStepRule();
          return Boolean.valueOf((!_isStepRule));
        };
        final Set<Rule> calledNonStepRules = IterableExtensions.<Rule>toSet(IterableExtensions.<Rule>filter(rule_3.getCalledRules(), _function_3));
        for (final Rule called : calledNonStepRules) {
          {
            final Set<Rule> inProgress = new HashSet<Rule>();
            final Set<Rule> gathered = this.gatherStepCalls(called, inProgress);
            rule_3.getCalledRules().addAll(gathered);
          }
        }
        rule_3.getCalledRules().removeAll(calledNonStepRules);
      }
    }
    this.mmext.getRules().clear();
    this.mmext.getRules().addAll(stepRules);
    final Function1<Rule, String> _function_3 = (Rule r) -> {
      String _name = r.getContainingClass().getName();
      String _plus = (_name + ".");
      String _name_1 = r.getOperation().getName();
      String _plus_1 = (_plus + _name_1);
      String _plus_2 = (_plus_1 + ": ");
      boolean _isEmpty = r.getCalledRules().isEmpty();
      boolean _not = (!_isEmpty);
      return (_plus_2 + Boolean.valueOf(_not));
    };
    final Iterable<String> prettyStepRules = IterableExtensions.<Rule, String>map(stepRules, _function_3);
    this.debug(prettyStepRules);
    final Resource mseMetamodelResource = IterableExtensions.<EGenericType>head(this.traceMMExplorer.getSpecificTraceClass().getEGenericSuperTypes()).getEClassifier().eResource();
    final Function1<EClass, Boolean> _function_4 = (EClass it) -> {
      return Boolean.valueOf(it.getName().equals("SequentialStep"));
    };
    final EClass mseSequentialStepClass = IterableExtensions.<EClass>findFirst(Iterables.<EClass>filter(IteratorExtensions.<EObject>toSet(mseMetamodelResource.getAllContents()), EClass.class), _function_4);
    final Function1<EClass, Boolean> _function_5 = (EClass it) -> {
      return Boolean.valueOf(it.getName().equals("SmallStep"));
    };
    final EClass mseSmallStepClass = IterableExtensions.<EClass>findFirst(Iterables.<EClass>filter(IteratorExtensions.<EObject>toSet(mseMetamodelResource.getAllContents()), EClass.class), _function_5);
    for (final Rule stepRule : stepRules) {
      {
        final EClass stepClass = this.getStepClass(stepRule);
        stepClass.setName(stepRule.getOperation().getName());
        if ((this.gemoc && (!Objects.equal(stepRule.getContainingClass(), null)))) {
          final EOperation getCallerEOperation = EcoreFactory.eINSTANCE.createEOperation();
          final EClass tracedClass = this.traceability.getTracedClass(stepRule.getContainingClass());
          EClass _xifexpression = null;
          boolean _equals = Objects.equal(tracedClass, null);
          if (_equals) {
            _xifexpression = stepRule.getContainingClass();
          } else {
            _xifexpression = tracedClass;
          }
          getCallerEOperation.setEType(_xifexpression);
          getCallerEOperation.setLowerBound(1);
          getCallerEOperation.setUpperBound(1);
          getCallerEOperation.setName(TraceMMGeneratorSteps.GET_CALLER_OPERATION_NAME);
          final EAnnotation bodyAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
          getCallerEOperation.getEAnnotations().add(bodyAnnotation);
          bodyAnnotation.setSource(GenModelPackage.eNS_URI);
          bodyAnnotation.getDetails().put("body", this.randomStringToFindGetCallerAnnotations);
          stepClass.getEOperations().add(getCallerEOperation);
        } else {
          EcoreCraftingUtil.addReferenceToClass(stepClass, "this", stepRule.getContainingClass());
        }
        this.setClassNameWithoutConflict(stepClass, 
          StepStrings.stepClassName(stepRule.getContainingClass(), stepRule.getOperation()));
        final EReference ref = EcoreCraftingUtil.addReferenceToClass(this.traceMMExplorer.specificTraceClass, 
          TraceMMStrings.ref_createTraceClassToStepClass(stepClass), stepClass);
        ref.setLowerBound(0);
        ref.setUpperBound((-1));
        ref.setContainment(false);
        this.traceability.addStepSequence(stepClass, ref);
        this.traceability.addStepClass(stepClass);
        stepClass.getESuperTypes().add(this.traceMMExplorer.getSpecificStepClass());
        boolean _isEmpty = stepRule.getCalledRules().isEmpty();
        if (_isEmpty) {
          final EGenericType smallStepGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
          smallStepGenericSuperType.setEClassifier(mseSmallStepClass);
          final EGenericType smallStepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          smallStepGenericSuperType.getETypeArguments().add(smallStepTypeBinding);
          smallStepTypeBinding.setEClassifier(this.traceMMExplorer.specificStateClass);
          stepClass.getEGenericSuperTypes().add(smallStepGenericSuperType);
        } else {
          this.traceability.addBigStepClass(stepClass);
          final EGenericType genericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
          genericSuperType.setEClassifier(mseSequentialStepClass);
          final EGenericType stepTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          final EGenericType stateTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          CollectionExtensions.<EGenericType>addAll(genericSuperType.getETypeArguments(), stepTypeBinding, stateTypeBinding);
          stepClass.getEGenericSuperTypes().add(genericSuperType);
          final EClass subStepSuperClass = EcoreFactory.eINSTANCE.createEClass();
          this.traceMMExplorer.stepsPackage.getEClassifiers().add(subStepSuperClass);
          this.setClassNameWithoutConflict(subStepSuperClass, 
            StepStrings.abstractSubStepClassName(stepRule.getContainingClass(), stepRule.getOperation()));
          subStepSuperClass.setAbstract(true);
          subStepSuperClass.setInterface(true);
          subStepSuperClass.getESuperTypes().add(this.traceMMExplorer.specificStepClass);
          stepTypeBinding.setEClassifier(subStepSuperClass);
          stateTypeBinding.setEClassifier(this.traceMMExplorer.specificStateClass);
          final EClass implicitStepClass = EcoreFactory.eINSTANCE.createEClass();
          this.traceMMExplorer.stepsPackage.getEClassifiers().add(implicitStepClass);
          this.setClassNameWithoutConflict(implicitStepClass, 
            StepStrings.implicitStepClassName(stepRule.getContainingClass(), stepRule.getOperation()));
          implicitStepClass.getESuperTypes().add(subStepSuperClass);
          final EGenericType smallStepGenericSuperType_1 = EcoreFactory.eINSTANCE.createEGenericType();
          smallStepGenericSuperType_1.setEClassifier(mseSmallStepClass);
          final EGenericType smallStepTypeBinding_1 = EcoreFactory.eINSTANCE.createEGenericType();
          smallStepGenericSuperType_1.getETypeArguments().add(smallStepTypeBinding_1);
          smallStepTypeBinding_1.setEClassifier(this.traceMMExplorer.specificStateClass);
          implicitStepClass.getEGenericSuperTypes().add(smallStepGenericSuperType_1);
          this.traceability.putImplicitStepClass(implicitStepClass, stepRule.getContainingClass());
          EList<Rule> _calledRules = stepRule.getCalledRules();
          for (final Rule calledStepRule : _calledRules) {
            {
              final EClass subStepClass = this.getStepClass(calledStepRule);
              subStepClass.getESuperTypes().add(subStepSuperClass);
            }
          }
        }
      }
    }
  }
  
  /**
   * To generate the code of 'getCaller' operations inside the trace metamodel, thanks to the exact FQNs
   * of the generated java classes computed using the genmodel.
   */
  public void addGetCallerEOperations(final Set<EPackage> traceMetamodel, final Set<GenPackage> packages) {
    for (final EPackage p : traceMetamodel) {
      Set<EOperation> _set = IteratorExtensions.<EOperation>toSet(Iterators.<EOperation>filter(p.eAllContents(), EOperation.class));
      for (final EOperation operation : _set) {
        {
          final Function1<EAnnotation, Boolean> _function = (EAnnotation a) -> {
            return Boolean.valueOf(a.getDetails().containsKey("body"));
          };
          final Iterable<EAnnotation> annotationsWithBody = IterableExtensions.<EAnnotation>filter(operation.getEAnnotations(), _function);
          final Function1<EAnnotation, Boolean> _function_1 = (EAnnotation a) -> {
            return Boolean.valueOf(a.getDetails().get("body").equals(this.randomStringToFindGetCallerAnnotations));
          };
          final EAnnotation annotationWithUniqueString = IterableExtensions.<EAnnotation>findFirst(annotationsWithBody, _function_1);
          boolean _notEquals = (!Objects.equal(annotationWithUniqueString, null));
          if (_notEquals) {
            EMap<String, String> _details = annotationWithUniqueString.getDetails();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("return (");
            String _javaFQN = EcoreCraftingUtil.getJavaFQN(operation.getEType(), packages);
            _builder.append(_javaFQN);
            _builder.append(") this.getMseoccurrence().getMse().getCaller();");
            _details.put(
              "body", _builder.toString());
          }
        }
      }
    }
  }
}
