/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation.impl;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.validation.ITypeChecker;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;

public final class TypeChecker
implements ITypeChecker {
    private final Scopes scopes;
    private final IQueryEnvironment context;

    public TypeChecker(Scopes scopes, IQueryEnvironment context) {
        this.scopes = scopes;
        this.context = Objects.requireNonNull(context, "context");
    }

    @Override
    public Set<IType> acceptedTypesForInsertion(Set<IType> variableTypes) {
        HashSet<IType> acceptedTypes = new HashSet<IType>();
        for (IType variableType : variableTypes) {
            ICollectionType collection;
            if (this.isInteger(variableType)) {
                acceptedTypes.add(variableType);
                continue;
            }
            if (this.isString(variableType)) {
                acceptedTypes.add(variableType);
                continue;
            }
            if (!(variableType instanceof ICollectionType) || (collection = (ICollectionType)variableType).getCollectionType() == null) continue;
            acceptedTypes.add(collection.getCollectionType());
            acceptedTypes.add((IType)collection);
        }
        return acceptedTypes;
    }

    @Override
    public Set<IType> acceptedTypesForRemoval(Set<IType> variableTypes) {
        HashSet<IType> acceptedTypes = new HashSet<IType>();
        for (IType variableType : variableTypes) {
            ICollectionType collection;
            if (this.isInteger(variableType)) {
                acceptedTypes.add(variableType);
                continue;
            }
            if (!(variableType instanceof ICollectionType) || (collection = (ICollectionType)variableType).getCollectionType() == null) continue;
            acceptedTypes.add(collection.getCollectionType());
            acceptedTypes.add((IType)collection);
        }
        return acceptedTypes;
    }

    @Override
    public boolean acceptsInsertion(Set<IType> variableTypes, Set<IType> valueTypes) {
        for (IType variableType : variableTypes) {
            for (IType valueType : valueTypes) {
                if (this.isNumber(variableType) && this.isNumber(valueType)) {
                    return true;
                }
                if (this.isString(variableType) && this.isString(valueType)) {
                    return true;
                }
                if (this.isCollection(variableType) && this.isCollection(valueType)) {
                    ICollectionType absorbingCollection = (ICollectionType)variableType;
                    ICollectionType absorbedCollection = (ICollectionType)valueType;
                    return this.elementCanBelongToCollection((IType)absorbingCollection, absorbedCollection.getCollectionType());
                }
                if (!this.isCollection(variableType) || !this.elementCanBelongToCollection(variableType, valueType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsRemoval(Set<IType> variableTypes, Set<IType> valueTypes) {
        for (IType variableType : variableTypes) {
            for (IType valueType : valueTypes) {
                if (this.isInteger(variableType) && this.isNumber(valueType)) {
                    return true;
                }
                if (this.isCollection(variableType) && this.isCollection(valueType)) {
                    ICollectionType absorbingCollection = (ICollectionType)variableType;
                    ICollectionType absorbedCollection = (ICollectionType)valueType;
                    return this.elementCanBelongToCollection((IType)absorbingCollection, absorbedCollection.getCollectionType());
                }
                if (!this.isCollection(variableType) || !this.elementCanBelongToCollection(variableType, valueType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean elementCanBelongToCollection(IType collectionType, IType elementType) {
        if (!(collectionType instanceof ICollectionType)) {
            return false;
        }
        ICollectionType pcollectionType = (ICollectionType)collectionType;
        return this.isAssignable(pcollectionType.getCollectionType(), Sets.newHashSet((Object[])new IType[]{elementType}));
    }

    @Override
    public Optional<IType> findCompatibleType(IType variableType, Set<IType> valueTypes) {
        return valueTypes.stream().filter(inferredType -> this.isAssignable(variableType, (IType)inferredType)).findAny();
    }

    @Override
    public boolean isAssignable(IType variableType, IType valueType) {
        if (this.isNull(valueType)) {
            return true;
        }
        if (this.isSet(variableType) && this.isSet(valueType)) {
            return this.collectionsHaveCompatibleGenericTypes(variableType, valueType);
        }
        if (this.isSequence(variableType) && this.isSequence(valueType)) {
            return this.collectionsHaveCompatibleGenericTypes(variableType, valueType);
        }
        if (this.isBoolean(variableType) && this.isBoolean(valueType)) {
            return true;
        }
        if (this.isNumber(variableType) && this.isNumber(valueType)) {
            return true;
        }
        if (this.isString(variableType) && this.isString(valueType)) {
            return true;
        }
        if (this.isEClass(variableType) && this.isEClass(valueType)) {
            boolean mayBeAssignable = variableType.isAssignableFrom(valueType);
            if (!mayBeAssignable) {
                mayBeAssignable = ((EClassifierType)variableType).getType() == EcorePackage.eINSTANCE.getEObject();
            }
            return mayBeAssignable;
        }
        return variableType.isAssignableFrom(valueType);
    }

    private boolean isEClass(IType type) {
        return type instanceof EClassifierType && type.getType() instanceof EClass;
    }

    private boolean collectionsHaveCompatibleGenericTypes(IType variable, IType value) {
        IType variableCollectionType = ((ICollectionType)variable).getCollectionType();
        IType valueCollectionType = ((ICollectionType)value).getCollectionType();
        if (this.isUnknown(variableCollectionType)) {
            return true;
        }
        if (this.isUnknown(valueCollectionType)) {
            return true;
        }
        return this.isAssignable(variableCollectionType, valueCollectionType);
    }

    @Override
    public boolean isAssignable(IType variableType, Set<IType> valueTypes) {
        return this.findCompatibleType(variableType, valueTypes).isPresent();
    }

    @Override
    public boolean isBoolean(Expression exp) {
        Set<IType> expressionTypes = this.scopes.getCurrent().getPossibleTypesOf(exp);
        return expressionTypes.stream().anyMatch(type -> this.isBoolean((IType)type));
    }

    @Override
    public boolean isBoolean(IType type) {
        ClassType booleanObjectType = new ClassType((IReadOnlyQueryEnvironment)this.context, Boolean.class);
        ClassType booleanType = new ClassType((IReadOnlyQueryEnvironment)this.context, Boolean.TYPE);
        return booleanObjectType.isAssignableFrom(type) || booleanType.isAssignableFrom(type);
    }

    @Override
    public boolean isCollection(IType type) {
        return type instanceof ICollectionType;
    }

    @Override
    public boolean isDouble(IType type) {
        if (Double.class.equals(type.getType())) {
            return true;
        }
        if (type.getType() instanceof EDataType) {
            EDataType dataType = (EDataType)type.getType();
            return type == EcorePackage.eINSTANCE.getEDouble() || Double.TYPE.equals(dataType.getInstanceClass()) || Double.class.equals((Object)dataType.getInstanceClass());
        }
        return false;
    }

    @Override
    public boolean isInteger(IType type) {
        if (Integer.class.equals(type.getType())) {
            return true;
        }
        if (type.getType() instanceof EDataType) {
            EDataType dataType = (EDataType)type.getType();
            return type == EcorePackage.eINSTANCE.getEInt() || Integer.TYPE.equals(dataType.getInstanceClass()) || Integer.class.equals((Object)dataType.getInstanceClass());
        }
        return false;
    }

    @Override
    public boolean isNull(IType type) {
        if (type.getType() == null) {
            return true;
        }
        return type instanceof NothingType;
    }

    @Override
    public boolean isNumber(IType type) {
        return this.isInteger(type) || this.isDouble(type);
    }

    @Override
    public boolean isSet(IType type) {
        return type instanceof SetType;
    }

    @Override
    public boolean isSequence(IType type) {
        return type instanceof SequenceType;
    }

    @Override
    public boolean isString(IType type) {
        if (String.class.equals(type.getType())) {
            return true;
        }
        if (type.getType() == EcorePackage.eINSTANCE.getEString()) {
            return true;
        }
        if (type.getType() instanceof EDataType) {
            EDataType dataType = (EDataType)type.getType();
            return String.class.equals((Object)dataType.getInstanceClass());
        }
        return false;
    }

    @Override
    public boolean isUnknown(IType type) {
        return type == null || type instanceof NothingType;
    }

    @Override
    public boolean isUnresolved(ETypedElement type) {
        return type.getEType() == ImplementationPackage.eINSTANCE.getUnresolvedEClassifier();
    }

    @Override
    public boolean supportsInsertion(IType type) {
        if (this.isCollection(type)) {
            return true;
        }
        if (this.isNumber(type)) {
            return true;
        }
        return this.isString(type);
    }

    @Override
    public boolean supportsRemoval(IType type) {
        if (this.isCollection(type)) {
            return true;
        }
        return this.isNumber(type);
    }
}

