/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.validation.type.AbstractCollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.Scopes;
import org.eclipse.emf.ecoretools.ale.core.validation.IAstLookup;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;

public final class AstLookup
implements IAstLookup {
    private final Scopes scopes;
    private final IConvertType convert;
    private final IAleEnvironment env;

    public AstLookup(IAleEnvironment env, Scopes scopes, IConvertType convert) {
        this.env = Objects.requireNonNull(env, "env");
        this.scopes = Objects.requireNonNull(scopes, "scopes");
        this.convert = Objects.requireNonNull(convert, "convert");
    }

    @Override
    public Set<IType> inferredTypesOf(Expression expression) {
        return this.scopes.getCurrent().getPossibleTypesOf(expression);
    }

    @Override
    public Set<IType> typesDeclaredFor(String variableName, EObject astBranch) {
        HashSet<IType> declaredTypes = new HashSet<IType>();
        EObject currentObject = astBranch;
        EObject currentScope = astBranch.eContainer();
        while (currentScope != null) {
            Optional<EParameter> parameter;
            Method method;
            EClassifier type;
            if (currentScope instanceof Block) {
                Block block = (Block)currentScope;
                int index = block.getStatements().indexOf((Object)currentObject);
                if (index != -1) {
                    Optional<VariableDeclaration> candidate = block.getStatements().stream().limit(index).filter(VariableDeclaration.class::isInstance).map(VariableDeclaration.class::cast).filter(varDecl -> varDecl.getName().equals(variableName)).findFirst();
                    if (candidate.isPresent()) {
                        ETypedElement type2 = candidate.get().getType();
                        declaredTypes.add(this.convert.toAQL(type2));
                        return declaredTypes;
                    }
                }
            } else if (currentScope instanceof ForEach) {
                ForEach loop = (ForEach)currentScope;
                if (loop.getVariable().equals(variableName)) {
                    return this.scopes.getCurrent().getPossibleTypesOf(loop.getCollectionExpression()).stream().map(AbstractCollectionType.class::cast).map(AbstractCollectionType::getCollectionType).collect(Collectors.toSet());
                }
            } else if (currentScope instanceof BehavioredClass) {
                BehavioredClass cls = (BehavioredClass)currentScope;
                Optional<Attribute> candidate = cls.getAttributes().stream().filter(attr -> attr.getFeatureRef().getName().equals(variableName)).findFirst();
                if (candidate.isPresent()) {
                    type = candidate.get().getFeatureRef().getEType();
                    declaredTypes.add(this.convert.toAQL(type));
                    return declaredTypes;
                }
            } else if (currentScope instanceof ExtendedClass) {
                ExtendedClass extension = (ExtendedClass)currentScope;
                Optional<EStructuralFeature> feature = extension.getBaseClass().getEAllStructuralFeatures().stream().filter(feat -> feat.getName().equals(variableName)).findFirst();
                if (feature.isPresent()) {
                    type = feature.get().getEType();
                    declaredTypes.add(this.convert.toAQL(type));
                    return declaredTypes;
                }
            } else if (currentScope instanceof Method && (method = (Method)currentScope).getOperationRef() != null && (parameter = method.getOperationRef().getEParameters().stream().filter(param -> param.getName().equals(variableName)).findFirst()).isPresent()) {
                declaredTypes.add(this.convert.toAQL((ETypedElement)parameter.get()));
            }
            currentObject = currentScope;
            currentScope = currentScope.eContainer();
        }
        return declaredTypes;
    }

    @Override
    public Set<IType> findFeatureTypes(String featureName, Expression featureAccessExpression) {
        HashSet<IType> variableTypes = new HashSet<IType>();
        Set<IType> inferredVariableTypes = this.scopes.getCurrent().getPossibleTypesOf(featureAccessExpression);
        for (IType type : inferredVariableTypes) {
            boolean featureIsCreatedAtRuntime;
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featureName);
            boolean bl = featureIsCreatedAtRuntime = feature == null;
            if (featureIsCreatedAtRuntime) {
                List<ExtendedClass> extensions = this.findExtensions(realType);
                feature = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featureName)).map(Attribute::getFeatureRef).findAny().orElse(null);
            }
            if (feature == null) continue;
            IType featureType = this.convert.toAQL((ETypedElement)feature);
            variableTypes.add(featureType);
        }
        return variableTypes;
    }

    public List<ExtendedClass> findExtensions(EClass realType) {
        return this.env.getBehaviors().getParsedFiles().stream().flatMap(m -> ((ModelUnit)m.getRoot()).getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass() != null).filter(xtdCls -> xtdCls.getBaseClass().isSuperTypeOf(realType)).collect(Collectors.toList());
    }

    @Override
    public Method enclosingMethod(Statement statement) {
        EObject parent = statement.eContainer();
        while (parent != null && !(parent instanceof Method)) {
            parent = parent.eContainer();
        }
        return (Method)parent;
    }
}

