/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class IOUtils {
    private IOUtils() {
    }

    static List<String> toAbsolutePaths(Collection<String> behaviors) {
        ArrayList<String> absolutePaths = new ArrayList<String>();
        for (String behavior : behaviors) {
            try {
                URI behaviorURI = URI.createFileURI((String)IOUtils.convertToFile(behavior));
                absolutePaths.add(behaviorURI.toFileString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return absolutePaths;
    }

    public static String convertToFile(String platformUriString) {
        URI uri = URI.createURI((String)platformUriString);
        String res = null;
        if (uri.isPlatformResource()) {
            res = IOUtils.resourceToFile(uri);
            if (res == null) {
                res = IOUtils.pluginToFile(IOUtils.resourceToPlugin(uri));
            }
        } else if (uri.isPlatformPlugin()) {
            res = IOUtils.pluginToFile(uri);
        }
        if (res == null) {
            res = platformUriString;
        }
        return res;
    }

    private static String resourceToFile(URI uri) {
        IResource file;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws != null && (file = ws.getRoot().findMember(uri.toPlatformString(true))) != null) {
            return file.getLocationURI().getRawPath();
        }
        return null;
    }

    private static String pluginToFile(URI uri) {
        String pluginName = uri.segment(1);
        String path = uri.toPlatformString(true).substring(pluginName.length() + 1);
        Bundle plugin = Platform.getBundle((String)pluginName);
        URL pluginURL = plugin.getEntry("/");
        try {
            String pluginFilePath = FileLocator.toFileURL((URL)pluginURL).getFile();
            return String.valueOf(pluginFilePath) + path.substring(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URI resourceToPlugin(URI uri) {
        return URI.createPlatformPluginURI((String)uri.toPlatformString(true), (boolean)true);
    }
}

