/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IExpressionClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.INamedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.QualifiedName;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRuntimeExpression
extends AbstractConstraint
implements ICCSLConstraint,
IRuntimeContainer,
INamedElement {
    protected RuntimeClock expressionClock;
    private String name;
    private QualifiedName qualifiedName;
    private IRuntimeContainer parent;
    private List<IRuntimeContainer> contents = new ArrayList<IRuntimeContainer>();
    private List<RuntimeClock> discreteClocks = new ArrayList<RuntimeClock>();
    private List<RuntimeClock> denseClocks = new ArrayList<RuntimeClock>();
    private List<AbstractRuntimeRelation> relations = new ArrayList<AbstractRuntimeRelation>();
    private List<AbstractRuntimeExpression> expressions = new ArrayList<AbstractRuntimeExpression>();

    public AbstractRuntimeExpression() {
        this.state = AbstractConstraint.State.INIT;
    }

    public AbstractRuntimeExpression(RuntimeClock iClock) {
        this.expressionClock = iClock;
        if (iClock instanceof IExpressionClock) {
            ((IExpressionClock)((Object)iClock)).setExpression(this);
        }
        this.state = AbstractConstraint.State.INIT;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (this.canCallStart()) {
            super.startTransition();
        }
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (this.canCallSemantic()) {
            if (this.isDead()) {
                helper.inhibitClock(this.getExpressionClock());
                helper.registerClockUse(this.getExpressionClock());
            }
            super.semanticTransition();
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.canCallUpdate()) {
            super.updateTransition();
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        if (this.state == AbstractConstraint.State.DEAD) {
            helper.forceDeath(this.getExpressionClock());
        }
        super.deathSemantic();
    }

    @Override
    public void terminate(AbstractUpdateHelper helper) throws SimulationException {
        if (this.canCallTerminate()) {
            this.terminateTransition();
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isDead();
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = new SerializedConstraintState();
        currentState.dump(this.wasBorn());
        currentState.dump(this.state.ordinal());
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState stateData) {
        this.born = (Boolean)stateData.restore(0);
        this.state = AbstractConstraint.State.values()[(Integer)stateData.restore(1)];
    }

    public RuntimeClock getExpressionClock() {
        return this.expressionClock;
    }

    public void setExpressionClock(RuntimeClock expressionClock) {
        this.expressionClock = expressionClock;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = new QualifiedName(qualifiedName);
    }

    @Override
    public void setQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public QualifiedName getQualifiedName() {
        if (this.qualifiedName != null) {
            return this.qualifiedName;
        }
        if (this.parent != null && this.parent instanceof INamedElement) {
            QualifiedName res = new QualifiedName(((INamedElement)((Object)this.parent)).getQualifiedName());
            res.append(this.getName());
            this.qualifiedName = res;
            return res;
        }
        return new QualifiedName(this.getName());
    }

    @Override
    public IRuntimeContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IRuntimeContainer parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addContent(this);
        }
    }

    @Override
    public List<IRuntimeContainer> getContents() {
        return this.contents;
    }

    @Override
    public void addContent(IRuntimeContainer element) {
        this.contents.add(element);
        if (element instanceof RuntimeClock) {
            if (((RuntimeClock)element).isDense()) {
                this.denseClocks.add((RuntimeClock)element);
            } else {
                this.discreteClocks.add((RuntimeClock)element);
            }
        } else if (element instanceof AbstractRuntimeRelation) {
            this.relations.add((AbstractRuntimeRelation)element);
        } else if (element instanceof AbstractRuntimeExpression) {
            this.expressions.add((AbstractRuntimeExpression)element);
        }
    }

    public List<RuntimeClock> getDiscreteClocks() {
        ArrayList<RuntimeClock> res = new ArrayList<RuntimeClock>(this.discreteClocks);
        for (AbstractRuntimeRelation relation : this.relations) {
            res.addAll(relation.getDiscreteClocks());
        }
        for (AbstractRuntimeExpression expression : this.expressions) {
            res.addAll(expression.getDiscreteClocks());
        }
        return res;
    }
}

