/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.elements;

import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeElement;
import java.util.Arrays;

public class RuntimeSequence<T>
extends RuntimeElement {
    public T[] finitePart;
    public T[] infinitePart;
    public int finiteIndex;
    public int infiniteIndex;

    public RuntimeSequence() {
        this.finiteIndex = 0;
        this.infiniteIndex = 0;
    }

    public RuntimeSequence(T[] finitePart, T[] infinitePart) {
        this.finitePart = finitePart;
        this.infinitePart = infinitePart;
        this.finiteIndex = 0;
        this.infiniteIndex = 0;
    }

    public RuntimeSequence(RuntimeSequence<T> original) {
        this.finitePart = original.finitePart != null ? Arrays.copyOf(original.finitePart, original.finitePart.length) : null;
        this.finiteIndex = original.finiteIndex;
        this.infinitePart = original.infinitePart != null ? Arrays.copyOf(original.infinitePart, original.infinitePart.length) : null;
        this.infiniteIndex = original.infiniteIndex;
    }

    public void setFinitePart(T[] arg) {
        this.finitePart = arg;
        this.finiteIndex = 0;
    }

    public void setInfinitePart(T[] arg) {
        this.infinitePart = arg;
        this.infiniteIndex = 0;
    }

    public T popHead() {
        return this.popNext();
    }

    public RuntimeSequence<T> getTail() {
        RuntimeSequence<T> res = new RuntimeSequence<T>(this);
        res.popHead();
        return res;
    }

    public T getHead() {
        if (this.finitePart != null && this.finiteIndex < this.finitePart.length) {
            return this.finitePart[this.finiteIndex];
        }
        if (this.infinitePart != null && this.infiniteIndex < this.infinitePart.length) {
            return this.infinitePart[this.infiniteIndex];
        }
        return null;
    }

    public T popNext() {
        if (this.finitePart != null && this.finiteIndex < this.finitePart.length) {
            T result = this.finitePart[this.finiteIndex];
            ++this.finiteIndex;
            return result;
        }
        if (this.infinitePart != null && this.infiniteIndex < this.infinitePart.length) {
            T result = this.infinitePart[this.infiniteIndex];
            ++this.infiniteIndex;
            if (this.infiniteIndex == this.infinitePart.length) {
                this.infiniteIndex = 0;
            }
            return result;
        }
        return null;
    }

    public boolean hasNext() {
        return this.finitePart != null && this.finiteIndex < this.finitePart.length || this.isInfinite();
    }

    public boolean isFinite() {
        return this.infinitePart == null || this.infinitePart.length == 0;
    }

    public boolean isInfinite() {
        return this.infinitePart != null && this.infinitePart.length > 0;
    }

    public boolean isEmpty() {
        return (this.finitePart == null || this.finitePart.length == 0) && this.infinitePart == null && this.infinitePart.length == 0;
    }

    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = new SerializedConstraintState();
        currentState.dump(this.finiteIndex);
        currentState.dump(this.finitePart);
        currentState.dump(this.infiniteIndex);
        currentState.dump(this.infinitePart);
        return currentState;
    }

    public void restoreState(SerializedConstraintState newState) {
        this.finiteIndex = (Integer)newState.restore(0);
        this.finitePart = (Object[])newState.restore(1);
        this.infiniteIndex = (Integer)newState.restore(2);
        this.infinitePart = (Object[])newState.restore(3);
    }

    public boolean equals(RuntimeSequence<T> obj) {
        if (this.finiteIndex != obj.finiteIndex) {
            return false;
        }
        if (this.finitePart.length != obj.finitePart.length) {
            return false;
        }
        if (!Arrays.equals(this.finitePart, obj.finitePart)) {
            return false;
        }
        if (this.infiniteIndex != obj.infiniteIndex) {
            return false;
        }
        if (this.infinitePart.length != obj.infinitePart.length) {
            return false;
        }
        return Arrays.equals(this.infinitePart, obj.infinitePart);
    }
}

