/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.componentization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContentLayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramComponentizationHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.ToolGroup;
import org.eclipse.sirius.diagram.description.tool.ToolGroupExtension;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;

public class DiagramComponentizationManager {
    private static boolean isInSelectedViewpoints(Collection<Viewpoint> selectedViewpoints, DiagramDescription diagramDescription) {
        for (Viewpoint viewpoint : selectedViewpoints) {
            for (RepresentationDescription representationDescription : new ViewpointQuery(viewpoint).getAllRepresentationDescriptions()) {
                if (!EqualityHelper.areEquals((EObject)diagramDescription, (EObject)representationDescription)) continue;
                return true;
            }
        }
        return false;
    }

    public EList<Layer> getAllLayers(Collection<Viewpoint> enabledViewpoints, DiagramDescription diagramDescription) {
        ArrayList<Layer> layers = new ArrayList<Layer>((Collection<Layer>)LayerHelper.getAllLayers(diagramDescription));
        if (enabledViewpoints != null) {
            if (!DiagramComponentizationManager.isInSelectedViewpoints(enabledViewpoints, diagramDescription)) {
                return new BasicEList();
            }
            layers.addAll(DiagramComponentizationHelper.getContributedLayers(diagramDescription, enabledViewpoints));
        }
        return new BasicEList(layers);
    }

    public EList<EdgeMapping> getAllEdgeMappings(Collection<Viewpoint> enabledViewpoints, DiagramDescription diagramDescription) {
        ArrayList<EdgeMapping> edgeMappings = new ArrayList<EdgeMapping>((Collection<EdgeMapping>)diagramDescription.getAllEdgeMappings());
        if (enabledViewpoints != null) {
            for (Layer layer : DiagramComponentizationHelper.getContributedLayers(diagramDescription, enabledViewpoints)) {
                edgeMappings.addAll((Collection<EdgeMapping>)ContentLayerHelper.getAllEdgeMappings(layer));
            }
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)diagramDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramDescription_AllEdgeMappings(), edgeMappings.size(), edgeMappings.toArray());
    }

    public EList<NodeMapping> getAllNodeMappings(Collection<Viewpoint> enabledViewpoints, DiagramDescription diagramDescription) {
        ArrayList<NodeMapping> nodeMappings = new ArrayList<NodeMapping>((Collection<NodeMapping>)ContentHelper.getAllNodeMappings(diagramDescription, false));
        if (enabledViewpoints != null) {
            for (Layer layer : DiagramComponentizationHelper.getContributedLayers(diagramDescription, enabledViewpoints)) {
                nodeMappings.addAll((Collection<NodeMapping>)layer.getNodeMappings());
            }
        }
        return new BasicEList(nodeMappings);
    }

    public EList<ContainerMapping> getAllContainerMappings(Collection<Viewpoint> enabledViewpoints, DiagramDescription diagramDescription) {
        ArrayList<ContainerMapping> containerMappings = new ArrayList<ContainerMapping>((Collection<ContainerMapping>)ContentHelper.getAllContainerMappings(diagramDescription, false));
        if (enabledViewpoints != null) {
            for (Layer layer : DiagramComponentizationHelper.getContributedLayers(diagramDescription, enabledViewpoints)) {
                containerMappings.addAll((Collection<ContainerMapping>)layer.getContainerMappings());
            }
        }
        return new BasicEList(containerMappings);
    }

    public EList<ToolSection> getRootPaletteSections(Collection<Viewpoint> enabledViewpoints, DiagramDescription diagramDescription) {
        LinkedHashMap<String, ToolSection> nameToSection = new LinkedHashMap<String, ToolSection>();
        for (Layer layer : this.getAllLayers(enabledViewpoints, diagramDescription)) {
            for (ToolSection currentSection : layer.getToolSections()) {
                if (nameToSection.containsKey(currentSection.getName())) continue;
                nameToSection.put(currentSection.getName(), currentSection);
            }
        }
        return new BasicEList(nameToSection.values());
    }

    public EList<AbstractToolDescription> getAllTools(Collection<Viewpoint> enabledViewpoints, DiagramDescription diagramDescription) {
        ArrayList<AbstractToolDescription> tools = new ArrayList<AbstractToolDescription>((Collection<AbstractToolDescription>)diagramDescription.getAllTools());
        if (enabledViewpoints != null) {
            for (Layer layer : DiagramComponentizationHelper.getContributedLayers(diagramDescription, enabledViewpoints)) {
                tools.addAll((Collection<AbstractToolDescription>)layer.getAllTools());
            }
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)diagramDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramDescription_AllTools(), tools.size(), tools.toArray());
    }

    public EList<ToolEntry> getToolEntries(Collection<Viewpoint> enabledViewpoints, ToolSection section) {
        return this.getAllToolEntries(enabledViewpoints, section, false);
    }

    public EList<ToolEntry> getAllToolEntries(Collection<Viewpoint> enabledViewpoints, ToolSection section) {
        return this.getAllToolEntries(enabledViewpoints, section, true);
    }

    private EList<ToolEntry> getAllToolEntries(Collection<Viewpoint> enabledViewpoints, ToolSection section, boolean recursive) {
        BasicEList toolEntries = new BasicEList();
        EObject container = section.eContainer();
        if (container instanceof Layer) {
            if (section.getName() != null && enabledViewpoints != null) {
                Layer parentLayer = (Layer)container;
                DiagramDescription diagramDescription = this.getDiagramDescription(enabledViewpoints, parentLayer);
                for (Layer layer : this.getAllLayers(enabledViewpoints, diagramDescription)) {
                    for (ToolSection toolSection : layer.getToolSections()) {
                        if (!section.getName().equals(toolSection.getName())) continue;
                        toolEntries.addAll(this.getTools(toolSection, recursive));
                    }
                }
            }
        } else {
            toolEntries.addAll(this.getTools(section, recursive));
        }
        return toolEntries;
    }

    private EList<ToolEntry> getTools(ToolSection toolSection, boolean recursive) {
        BasicEList entries = new BasicEList();
        entries.addAll(toolSection.getOwnedTools());
        entries.addAll(toolSection.getReusedTools());
        if (recursive) {
            for (ToolSection subSection : toolSection.getSubSections()) {
                entries.addAll(this.getTools(subSection, recursive));
            }
        }
        return entries;
    }

    private DiagramDescription getDiagramDescription(Collection<Viewpoint> enabledViewpoints, Layer layer) {
        DiagramDescription diagramDescription = null;
        EObject layerContainer = layer.eContainer();
        if (layerContainer instanceof DiagramDescription) {
            diagramDescription = (DiagramDescription)layerContainer;
        } else if (layerContainer instanceof DiagramExtensionDescription) {
            diagramDescription = DiagramComponentizationHelper.getDiagramDescription((DiagramExtensionDescription)layerContainer, enabledViewpoints);
        }
        return diagramDescription;
    }

    public EList<AbstractToolDescription> getTools(Collection<Viewpoint> enabledViewpoints, ToolGroup toolGroup) {
        DiagramDescription diagramDescription = this.getDiagramDescription(toolGroup);
        BasicEList tools = new BasicEList();
        tools.addAll(toolGroup.getTools());
        if (diagramDescription != null) {
            for (Layer layer : this.getAllLayers(enabledViewpoints, diagramDescription)) {
                tools.addAll(this.getToolsFromToolSection((Collection<ToolSection>)layer.getToolSections(), toolGroup));
            }
        }
        return tools;
    }

    private EList<AbstractToolDescription> getToolsFromToolSection(Collection<ToolSection> sections, ToolGroup toolGroup) {
        BasicEList tools = new BasicEList();
        for (ToolSection section : sections) {
            for (ToolGroupExtension extension : section.getGroupExtensions()) {
                if (!EqualityHelper.areEquals((EObject)toolGroup, (EObject)extension.getGroup())) continue;
                tools.addAll(extension.getTools());
            }
            tools.addAll(this.getToolsFromToolSection((Collection<ToolSection>)section.getSubSections(), toolGroup));
        }
        return tools;
    }

    private DiagramDescription getDiagramDescription(ToolGroup toolGroup) {
        EObject eObject = toolGroup.eContainer();
        while (!(eObject instanceof DiagramDescription) && !(eObject instanceof DiagramExtensionDescription)) {
            if ((eObject = eObject.eContainer()) != null) continue;
            return null;
        }
        DiagramDescription diagramDescription = eObject instanceof DiagramExtensionDescription ? DiagramComponentizationHelper.getDiagramDescription((DiagramExtensionDescription)eObject, ViewpointRegistry.getInstance().getViewpoints()) : (DiagramDescription)eObject;
        return diagramDescription;
    }
}

