/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SynchronizeISequenceEventsSemanticOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SynchronizeInstanceRoleSemanticOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.tool.ToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public final class SequenceEditPartsOperations {
    private SequenceEditPartsOperations() {
    }

    public static void appendFullRefresh(IGraphicalEditPart self, CompoundCommand cc) {
        SequenceDiagram sequenceDiagram = EditPartsHelper.getSequenceDiagram(self);
        SequenceDDiagram sequenceDDiagram = sequenceDiagram.getSequenceDDiagram();
        TransactionalEditingDomain domain = self.getEditingDomain();
        cc.add((org.eclipse.gef.commands.Command)new ICommandProxy(CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new RefreshGraphicalOrderingOperation(sequenceDiagram))));
        cc.add((org.eclipse.gef.commands.Command)new ICommandProxy(CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new RefreshSemanticOrderingsOperation(sequenceDDiagram))));
    }

    public static void appendFullRefresh(IGraphicalEditPart self, CompositeTransactionalCommand ctc) {
        SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, self);
        SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(ctc, self);
    }

    public static void addRefreshGraphicalOrderingCommand(CompositeTransactionalCommand cc, IGraphicalEditPart self) {
        SequenceDiagram sequenceDiagram = EditPartsHelper.getSequenceDiagram(self);
        TransactionalEditingDomain domain = cc.getEditingDomain();
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new RefreshGraphicalOrderingOperation(sequenceDiagram)));
    }

    public static void addRefreshSemanticOrderingCommand(CompositeTransactionalCommand cc, IGraphicalEditPart self) {
        SequenceDiagram sequenceDiagram = EditPartsHelper.getSequenceDiagram(self);
        SequenceDDiagram sequenceDDiagram = sequenceDiagram.getSequenceDDiagram();
        TransactionalEditingDomain domain = cc.getEditingDomain();
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new RefreshSemanticOrderingsOperation(sequenceDDiagram)));
    }

    public static void addSynchronizeSemanticOrderingCommand(CompositeTransactionalCommand cc, ISequenceEvent event) {
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)cc.getEditingDomain(), (AbstractModelChangeOperation)new SynchronizeISequenceEventsSemanticOrderingOperation(event)));
    }

    public static void addSynchronizeSemanticOrderingCommand(CompositeTransactionalCommand cc, ISequenceEvent event, Collection<ISequenceEvent> selection) {
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)cc.getEditingDomain(), (AbstractModelChangeOperation)new SynchronizeISequenceEventsSemanticOrderingOperation(event, selection)));
    }

    public static void addSynchronizeSemanticOrderingCommand(CompositeTransactionalCommand cc, InstanceRole instanceRole) {
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)cc.getEditingDomain(), (AbstractModelChangeOperation)new SynchronizeInstanceRoleSemanticOrderingOperation(instanceRole)));
    }

    public static void addSynchronizeSemanticOrderingCommand(CompositeTransactionalCommand cc, InstanceRole instanceRole, Collection<InstanceRole> selection) {
        cc.compose((IUndoableOperation)CommandFactory.createICommand((TransactionalEditingDomain)cc.getEditingDomain(), (AbstractModelChangeOperation)new SynchronizeInstanceRoleSemanticOrderingOperation(instanceRole, selection)));
    }

    public static void registerDiagramElement(IGraphicalEditPart self, EObject element) {
        self.getViewer().getEditPartRegistry().put(element, self);
    }

    public static void unregisterDiagramElement(IGraphicalEditPart self, EObject element) {
        Map registry = self.getViewer().getEditPartRegistry();
        if (registry.get(element) == self) {
            registry.remove(element);
        }
    }

    public static void setBorderItemLocation(AbstractBorderItemEditPart self, int side, Dimension offset) {
        IBorderItemLocator borderItemLocator = self.getBorderItemLocator();
        if (borderItemLocator instanceof DBorderItemLocator) {
            DBorderItemLocator dbil = (DBorderItemLocator)borderItemLocator;
            dbil.setCurrentSideOfParent(side);
            dbil.setBorderItemOffset(offset);
        }
    }

    public static void buildCreateEdgeCommand(IGraphicalEditPart self, CompoundCommand result, CreateConnectionRequest request, EdgeTarget source, EdgeTarget target, EdgeCreationDescription edgeCreationDescription, IDiagramCommandFactoryProvider cmdFactoryProvider) {
        Command emfCommand;
        TransactionalEditingDomain domain = self.getEditingDomain();
        if (edgeCreationDescription instanceof MessageCreationTool && ((DDiagramElement)source).getParentDiagram() instanceof SequenceDDiagram) {
            Point sourceLocation = request.getLocation().getCopy();
            Point targetLocation = request.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)sourceLocation, (GraphicalEditPart)self);
            GraphicalHelper.screen2logical((Point)targetLocation, (GraphicalEditPart)self);
            Point srcLocationHint = SequenceEditPartsOperations.getConnectionSourceLocation(request, self);
            Point tgtLocationHint = SequenceEditPartsOperations.getConnectionTargetLocation(request, self);
            if (srcLocationHint != null) {
                sourceLocation = srcLocationHint;
            }
            if (tgtLocationHint != null) {
                targetLocation = tgtLocationHint;
            }
            if (source != target) {
                targetLocation = sourceLocation;
            }
            SequenceDiagram sequenceDiagram = EditPartsHelper.getSequenceDiagram(self);
            SequenceDDiagram diagram = sequenceDiagram.getSequenceDDiagram();
            EventEnd startingEndBefore = SequenceGraphicalHelper.getEndBefore(diagram, sourceLocation.y);
            EventEnd finishingEndBefore = SequenceGraphicalHelper.getEndBefore(diagram, targetLocation.y);
            emfCommand = ToolCommandBuilder.buildCreateMessageCommand((EdgeTarget)source, (EdgeTarget)target, (MessageCreationTool)((MessageCreationTool)edgeCreationDescription), (EventEnd)startingEndBefore, (EventEnd)finishingEndBefore);
            org.eclipse.emf.common.command.CompoundCommand cc = new org.eclipse.emf.common.command.CompoundCommand();
            cc.append(emfCommand);
            cc.append((Command)CommandFactory.createRecordingCommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new RefreshSemanticOrderingsOperation(diagram)));
            emfCommand = cc;
        } else {
            emfCommand = cmdFactoryProvider.getCommandFactory(domain).buildCreateEdgeCommandFromTool(source, target, edgeCreationDescription);
        }
        result.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(domain, emfCommand)));
    }

    public static Range getVerticalRange(ISequenceEventEditPart self) {
        ISequenceEvent iSequenceEvent = self != null ? self.getISequenceEvent() : null;
        return iSequenceEvent != null ? iSequenceEvent.getVerticalRange() : Range.emptyRange();
    }

    public static void setVerticalRange(ISequenceEventEditPart self, Range newRange) {
        ISequenceEvent iSequenceEvent;
        ISequenceEvent iSequenceEvent2 = iSequenceEvent = self != null ? self.getISequenceEvent() : null;
        if (iSequenceEvent != null) {
            iSequenceEvent.setVerticalRange(newRange);
        }
    }

    public static Point getConnectionSourceLocation(CreateConnectionRequest request, IGraphicalEditPart self) {
        return SequenceEditPartsOperations.getConnectionLocation(self, "sourceConnectionAnchorLocation");
    }

    public static Point getConnectionTargetLocation(CreateConnectionRequest request, IGraphicalEditPart self) {
        return SequenceEditPartsOperations.getConnectionLocation(self, "targetConnectionAnchorLocation");
    }

    private static Point getConnectionLocation(IGraphicalEditPart self, String key) {
        Object hint = ViewLocationHint.getInstance().getData((Object)key);
        if (hint instanceof Point) {
            Point location = ((Point)hint).getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)self);
            return location;
        }
        return null;
    }
}

