/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.core.resources.NewProjectWorkspaceListener;
import org.eclipse.gemoc.commons.eclipse.ui.WizardFinder;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateAnimatorProjectWizardContextAction {
    public CreateAnimatorProjectAction actionToExecute = CreateAnimatorProjectAction.CREATE_NEW_SIRIUS_PROJECT;
    protected IProject gemocLanguageIProject = null;
    protected String languageName = null;

    public CreateAnimatorProjectWizardContextAction(IProject updatedGemocLanguageProject) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
    }

    public CreateAnimatorProjectWizardContextAction(IProject updatedGemocLanguageProject, String language) {
        this.gemocLanguageIProject = updatedGemocLanguageProject;
        this.languageName = language;
    }

    public void execute() {
        switch (this.actionToExecute) {
            case CREATE_NEW_SIRIUS_PROJECT: {
                this.createNewODProject();
                break;
            }
            case SELECT_EXISTING_OD_PROJECT: {
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createNewODProject() {
        String wizardId = "org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard";
        IWizardDescriptor descriptor = WizardFinder.findNewWizardDescriptor((String)"org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard");
        if (descriptor != null) {
            NewProjectWorkspaceListener workspaceListener = new NewProjectWorkspaceListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)workspaceListener);
            try {
                try {
                    IWorkbenchWizard wizard = descriptor.createWizard();
                    ((NewGemocDebugRepresentationWizard)wizard).setInitialProjectName(this.gemocLanguageIProject.getName());
                    if (this.languageName != null) {
                        ((NewGemocDebugRepresentationWizard)wizard).setInitialLanguageName(this.languageName);
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    wizard.init(workbench, null);
                    WizardDialog wd = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    wd.create();
                    wd.setTitle(wizard.getWindowTitle());
                    int res = wd.open();
                    if (res != 0) return;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                    IProject createdProject = workspaceListener.getLastCreatedProject();
                    if (createdProject != null) return;
                    Activator.error("not able to detect which project was created by wizard", null);
                    return;
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
                }
                return;
            }
            finally {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)workspaceListener);
            }
        } else {
            Activator.error("wizard with id=org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.NewGemocDebugRepresentationWizard not found", null);
        }
    }

    public static enum CreateAnimatorProjectAction {
        CREATE_NEW_SIRIUS_PROJECT,
        SELECT_EXISTING_OD_PROJECT;

    }
}

