/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.opsemanticsview.gen.OperationalSemanticsViewGenerator;
import org.eclipse.gemoc.trace.gemoc.generator.GenericEngineTraceAddonGenerator;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TraceAddonGeneratorIntegration {
    public static void generateAddon(IFile melangeFile, String selectedLanguage, boolean replace, IProgressMonitor monitor) {
        String _baseProjectName = XDSMLProjectHelper.baseProjectName((IProject)melangeFile.getProject());
        String _plus = String.valueOf(_baseProjectName) + ".";
        String _lowerCase = selectedLanguage.toLowerCase();
        String _plus_1 = String.valueOf(_plus) + _lowerCase;
        String pluginName = String.valueOf(_plus_1) + ".trace";
        TraceAddonGeneratorIntegration.generateAddon(melangeFile, selectedLanguage, pluginName, replace, monitor);
    }

    public static void generateAddon(IFile dslFile, String selectedLanguage, String pluginName, boolean replace, IProgressMonitor monitor) {
        try {
            Dsl selection = TraceAddonGeneratorIntegration.loadDsl(dslFile);
            IConfigurationElement[] configNew = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gemoc.opsemanticsview.gen");
            Functions.Function1 _function = e -> {
                try {
                    return e.createExecutableExtension("class");
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            Functions.Function1 _function_1 = conf -> conf.canHandle(selection, dslFile.getProject());
            OperationalSemanticsViewGenerator validViewGenerator = (OperationalSemanticsViewGenerator)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)configNew)), (Functions.Function1)_function), OperationalSemanticsViewGenerator.class), (Functions.Function1)_function_1);
            if (validViewGenerator == null) {
                Status _status = new Status(4, "org.eclipse.gemoc.trace.gemoc.generator", "Impossible to create a trace addon: couldn't find an opsemanticsview generator that can manage the chosen melange language.");
                throw new CoreException((IStatus)_status);
            }
            OperationalSemanticsView mmextension = validViewGenerator.generate(selection, dslFile.getProject());
            TraceAddonGeneratorIntegration.generateAddon(selectedLanguage, pluginName, replace, monitor, mmextension);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void generateAddon(String mmName, String pluginName, boolean replace, IProgressMonitor monitor, OperationalSemanticsView executionExtension) throws CoreException {
        final IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginName);
        boolean _exists = existingProject.exists();
        if (_exists) {
            if (replace) {
                String _name = existingProject.getName();
                String _plus = "deleting project " + _name;
                String _plus_1 = String.valueOf(_plus) + " content";
                WorkspaceJob job = new WorkspaceJob(_plus_1){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        IResource[] _members;
                        IResource[] iResourceArray = _members = existingProject.members();
                        int n = _members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            boolean _not;
                            IResource iRes = iResourceArray[n2];
                            boolean bl = _not = !iRes.getName().equals(".project") && !iRes.getName().equals(".classpath");
                            if (_not) {
                                iRes.delete(true, monitor);
                            }
                            ++n2;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setRule((ISchedulingRule)existingProject);
                job.schedule();
            } else {
                Status _status = new Status(4, "org.eclipse.gemoc.trace.gemoc.generator", "Impossible to create a trace addon: a project already exists with this name.");
                throw new CoreException((IStatus)_status);
            }
        }
        try {
            GenericEngineTraceAddonGenerator traceaddgen = new GenericEngineTraceAddonGenerator(executionExtension, pluginName);
            traceaddgen.generateCompleteAddon(monitor);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected static Dsl loadDsl(IFile dslFile) {
        Resource res = new ResourceSetImpl().getResource(URI.createURI((String)dslFile.getFullPath().toOSString()), true);
        EObject _get = (EObject)res.getContents().get(0);
        Dsl dsl = (Dsl)_get;
        return dsl;
    }
}

