/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml.constraint.ccslkernel.solver.extension.statemachine;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BasicTypeFactory;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.DiscreteClockType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.And;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntEqual;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntInf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntMinus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntPlus;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntSup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.Or;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.AbstractConcreteMapping;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverPrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.AbstractWrappedRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.javabdd.BuDDyFactory;
import org.eclipse.gemoc.moccml.constraint.ccslmoc.model.moccml.moccml.FinishClock;
import org.eclipse.gemoc.moccml.constraint.ccslmoc.model.moccml.moccml.StateMachineRelationDefinition;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.AbstractAction;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.Guard;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.IntegerAssignement;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.State;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.Transition;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.Trigger;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.editionextension.IntInfEqual;
import org.eclipse.gemoc.moccml.constraint.fsmkernel.model.FSMModel.editionextension.IntSupEqual;

public class StateMachineRelationDefinitionSemantics
extends AbstractWrappedRelation {
    private State _currentState = null;
    private AbstractConcreteMapping<ISolverElement> _abstract2concreteMap = null;
    private StateMachineRelationDefinition _modelSTS = null;
    private ArrayList<Transition> _sensitiveTransitition;
    private List<AbstractEntity> _parameters = null;
    private List<AbstractEntity> _clockParameters = null;
    private List<ISolverElement> _allClocks = null;
    private Map<ConcreteEntity, IntegerElement> _localInteger = null;
    private List<IntegerElement> _orderedLocalInteger = null;

    public List<IntegerElement> get_orderedLocalInteger() {
        return this._orderedLocalInteger;
    }

    public StateMachineRelationDefinitionSemantics(StateMachineRelationDefinition modelSTS, AbstractConcreteMapping<ISolverElement> context) {
        this._modelSTS = modelSTS;
        this._abstract2concreteMap = context;
        this._currentState = (State)this._modelSTS.getInitialStates().get(0);
        this._sensitiveTransitition = new ArrayList();
        this._parameters = this._modelSTS.getDeclaration().getParameters();
        this._clockParameters = this.keepOnlyClocks(this._parameters);
        this._allClocks = this.getConcreteElements(this._clockParameters);
        this._orderedLocalInteger = new ArrayList<IntegerElement>();
        this._localInteger = new HashMap<ConcreteEntity, IntegerElement>();
        if (this._modelSTS.getDeclarationBlock() != null) {
            for (ConcreteEntity ce : this._modelSTS.getDeclarationBlock().getConcreteEntities()) {
                if (!(ce instanceof IntegerElement)) continue;
                IntegerElement ie = BasicTypeFactory.eINSTANCE.createIntegerElement();
                ie.setName(((IntegerElement)ce).getName());
                ie.setValue(((IntegerElement)ce).getValue());
                this._orderedLocalInteger.add(ie);
                this._localInteger.put(ce, ie);
            }
        }
        for (Transition t : this._currentState.getOutputTransitions()) {
            if (t.getTrigger() != null || t.getGuard() == null || !this.evaluate(((Guard)t.getGuard()).getValue())) continue;
            for (AbstractAction a : t.getActions()) {
                if (!(a instanceof IntegerAssignement)) continue;
                IntegerAssignement ia = (IntegerAssignement)a;
                this.doAssignInt(ia);
            }
            this._currentState = t.getTarget();
        }
    }

    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this._currentState = (State)this._modelSTS.getInitialStates().get(0);
        this._sensitiveTransitition = new ArrayList();
        for (Transition t : this._currentState.getOutputTransitions()) {
            if (t.getTrigger() != null && !this.evaluate(((Guard)t.getGuard()).getValue())) continue;
            System.out.println("default transition taken");
            for (AbstractAction a : t.getActions()) {
                if (!(a instanceof IntegerAssignement)) continue;
                IntegerAssignement ia = (IntegerAssignement)a;
                this.doAssignInt(ia);
            }
            this._currentState = t.getTarget();
        }
    }

    private List<ISolverElement> getConcreteElements(List<? extends AbstractEntity> abstractTriggers) {
        ArrayList<ISolverElement> triggers = new ArrayList<ISolverElement>();
        for (AbstractEntity abstractEntity : abstractTriggers) {
            triggers.add((ISolverElement)this._abstract2concreteMap.getLocalValue(abstractEntity));
        }
        return triggers;
    }

    private List<AbstractEntity> keepOnlyClocks(List<AbstractEntity> l) {
        ArrayList<AbstractEntity> res = new ArrayList<AbstractEntity>();
        for (AbstractEntity ae : l) {
            if (!(ae.getType() instanceof DiscreteClockType)) continue;
            res.add(ae);
        }
        return res;
    }

    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(semanticHelper);
        this._sensitiveTransitition.clear();
        BuDDyFactory.BuDDyBDD stateBDD = semanticHelper.createOne();
        for (ISolverElement se : this._allClocks) {
            stateBDD.andWith(semanticHelper.getFalseBDDVariable((RuntimeClock)se));
        }
        for (Transition t : this._currentState.getOutputTransitions()) {
            if (t.getGuard() != null && !this.evaluate(((Guard)t.getGuard()).getValue())) continue;
            this._sensitiveTransitition.add(t);
            List<ISolverElement> trueTrigger = null;
            List<ISolverElement> falseTrigger = null;
            ArrayList<ISolverElement> clocksNotInTrigger = new ArrayList<ISolverElement>(this._allClocks);
            if (t.getTrigger() != null) {
                trueTrigger = this.getConcreteElements((List<? extends AbstractEntity>)((Trigger)t.getTrigger()).getTrueTriggers());
                falseTrigger = this.getConcreteElements((List<? extends AbstractEntity>)((Trigger)t.getTrigger()).getFalseTriggers());
                clocksNotInTrigger.removeAll(trueTrigger);
                BuDDyFactory.BuDDyBDD triggersBDD = semanticHelper.createOne();
                for (ISolverElement se : trueTrigger) {
                    triggersBDD.andWith(semanticHelper.getBDDVariable((RuntimeClock)((SolverClock)se)));
                }
                for (ISolverElement se : falseTrigger) {
                    triggersBDD.andWith(semanticHelper.getFalseBDDVariable((RuntimeClock)((SolverClock)se)));
                }
                for (ISolverElement se : clocksNotInTrigger) {
                    triggersBDD.andWith(semanticHelper.getFalseBDDVariable((RuntimeClock)((SolverClock)se)));
                }
                stateBDD.orWith(triggersBDD);
            }
            semanticHelper.registerClockUse((RuntimeClock[])this._allClocks.toArray(new SolverClock[0]));
        }
        semanticHelper.semanticBDDAnd(stateBDD);
        RuntimeClock[] usedClocks = new RuntimeClock[this._allClocks.size()];
        int i = 0;
        for (ISolverElement rc : this._allClocks) {
            usedClocks[i++] = (RuntimeClock)rc;
        }
        semanticHelper.registerClockUse(usedClocks);
    }

    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
    }

    public void update(AbstractUpdateHelper updateHelper) throws SimulationException {
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(updateHelper);
        block0: for (Transition t : this._sensitiveTransitition) {
            List<ISolverElement> trueTrigger = null;
            List<ISolverElement> falseTrigger = null;
            ArrayList<ISolverElement> clocksNotInTrigger = new ArrayList<ISolverElement>(this._allClocks);
            if (t.getTrigger() == null) break;
            trueTrigger = this.getConcreteElements((List<? extends AbstractEntity>)((Trigger)t.getTrigger()).getTrueTriggers());
            falseTrigger = this.getConcreteElements((List<? extends AbstractEntity>)((Trigger)t.getTrigger()).getFalseTriggers());
            clocksNotInTrigger.removeAll(trueTrigger);
            for (ISolverElement se : trueTrigger) {
                if (!updateHelper.clockHasFired((RuntimeClock)((SolverClock)se))) continue block0;
            }
            for (ISolverElement se : falseTrigger) {
                if (updateHelper.clockHasFired((RuntimeClock)((SolverClock)se))) continue block0;
            }
            for (ISolverElement se : clocksNotInTrigger) {
                if (updateHelper.clockHasFired((RuntimeClock)((SolverClock)se))) continue block0;
            }
            for (AbstractAction a : t.getActions()) {
                if (a instanceof FinishClock) {
                    SolverClock toKill = (SolverClock)this._abstract2concreteMap.getLocalValue((AbstractEntity)((FinishClock)a).getClock());
                    updateHelper.registerNewDeadClock((RuntimeClock)toKill);
                    toKill.setDead(true);
                }
                if (!(a instanceof IntegerAssignement)) continue;
                IntegerAssignement ia = (IntegerAssignement)a;
                this.doAssignInt(ia);
            }
            this._currentState = t.getTarget();
            break;
        }
    }

    private void doAssignInt(IntegerAssignement ia) {
        IntegerElement localLeftElement;
        int iToAssign;
        IntegerVariableRef varRef;
        IntegerElement localLeftElement2;
        IntegerElement leftElement;
        int iToIncrement;
        IntegerExpression leftExpr = ia.getLeftValue();
        IntegerExpression rightExpr = ia.getRightValue();
        if (!(rightExpr instanceof IntPlus | rightExpr instanceof IntMinus | rightExpr instanceof IntegerVariableRef | rightExpr instanceof IntegerRef)) {
            throw new IllegalArgumentException("only integer plus/minus, integer ref and integer variable ref expressions are supported as right value of assignment");
        }
        if (rightExpr instanceof IntPlus) {
            IntPlus plus = (IntPlus)rightExpr;
            iToIncrement = this.getInteger(plus.getLeftValue());
            int incrementValue = this.getInteger(plus.getRightValue());
            if (!(leftExpr instanceof IntegerRef)) {
                throw new IllegalArgumentException("left value of assignment should be integerRef (to a local integer !)");
            }
            leftElement = ((IntegerRef)leftExpr).getIntegerElem();
            localLeftElement2 = this._localInteger.get(leftElement);
            localLeftElement2.setValue(Integer.valueOf(iToIncrement + incrementValue));
        }
        if (rightExpr instanceof IntMinus) {
            IntMinus minus = (IntMinus)rightExpr;
            iToIncrement = this.getInteger(minus.getLeftValue());
            int decrementValue = this.getInteger(minus.getRightValue());
            if (!(leftExpr instanceof IntegerRef)) {
                throw new IllegalArgumentException("left value of assignment should be integerRef (to a local integer !)");
            }
            leftElement = ((IntegerRef)leftExpr).getIntegerElem();
            localLeftElement2 = this._localInteger.get(leftElement);
            localLeftElement2.setValue(Integer.valueOf(iToIncrement - decrementValue));
        }
        if (rightExpr instanceof IntegerVariableRef) {
            varRef = (IntegerVariableRef)rightExpr;
            iToAssign = ((IntegerElement)((ISolverElement)this._abstract2concreteMap.get((Object)varRef.getReferencedVar())).getModelElement()).getValue();
            if (!(leftExpr instanceof IntegerRef)) {
                throw new IllegalArgumentException("left value of assignment should be integerRef (to a local integer !)");
            }
            IntegerElement leftElement2 = ((IntegerRef)leftExpr).getIntegerElem();
            localLeftElement = this._localInteger.get(leftElement2);
            localLeftElement.setValue(Integer.valueOf(iToAssign));
        }
        if (rightExpr instanceof IntegerRef) {
            varRef = (IntegerRef)rightExpr;
            iToAssign = this._localInteger.get(varRef.getIntegerElem()) != null ? this._localInteger.get(varRef.getIntegerElem()).getValue().intValue() : varRef.getIntegerElem().getValue().intValue();
            if (!(leftExpr instanceof IntegerRef)) {
                throw new IllegalArgumentException("left value of assignment should be integerRef (to a local integer !)");
            }
            IntegerElement leftElement3 = ((IntegerRef)leftExpr).getIntegerElem();
            localLeftElement = this._localInteger.get(leftElement3);
            localLeftElement.setValue(Integer.valueOf(iToAssign));
        }
    }

    private boolean evaluate(BooleanExpression guard) {
        if (guard instanceof IntEqual) {
            return this.evaluate((IntEqual)guard);
        }
        if (guard instanceof IntInf) {
            return this.evaluate((IntInf)guard);
        }
        if (guard instanceof IntSup) {
            return this.evaluate((IntSup)guard);
        }
        if (guard instanceof IntInfEqual) {
            return this.evaluate((IntInfEqual)guard);
        }
        if (guard instanceof IntSupEqual) {
            return this.evaluate((IntSupEqual)guard);
        }
        if (guard instanceof And) {
            return this.evaluate((And)guard);
        }
        if (guard instanceof Or) {
            return this.evaluate((Or)guard);
        }
        return false;
    }

    private boolean evaluate(IntEqual guard) {
        int right;
        IntegerExpression leftExpr = guard.getLeftValue();
        IntegerExpression rightExpr = guard.getRightValue();
        int left = this.getInteger(leftExpr);
        return left == (right = this.getInteger(rightExpr));
    }

    private boolean evaluate(And guard) {
        boolean left = this.evaluate(guard.getLeftValue());
        boolean right = this.evaluate(guard.getRightValue());
        return left & right;
    }

    private boolean evaluate(Or guard) {
        boolean left = this.evaluate(guard.getLeftValue());
        boolean right = this.evaluate(guard.getRightValue());
        return left | right;
    }

    private boolean evaluate(IntInf guard) {
        int right;
        IntegerExpression leftExpr = guard.getLeftValue();
        IntegerExpression rightExpr = guard.getRightValue();
        int left = this.getInteger(leftExpr);
        return left < (right = this.getInteger(rightExpr));
    }

    private boolean evaluate(IntInfEqual guard) {
        int right;
        IntegerExpression leftExpr = guard.getLeftValue();
        IntegerExpression rightExpr = guard.getRightValue();
        int left = this.getInteger(leftExpr);
        return left <= (right = this.getInteger(rightExpr));
    }

    private boolean evaluate(IntSup guard) {
        int right;
        IntegerExpression leftExpr = guard.getLeftValue();
        IntegerExpression rightExpr = guard.getRightValue();
        int left = this.getInteger(leftExpr);
        return left > (right = this.getInteger(rightExpr));
    }

    private boolean evaluate(IntSupEqual guard) {
        int right;
        IntegerExpression leftExpr = guard.getLeftValue();
        IntegerExpression rightExpr = guard.getRightValue();
        int left = this.getInteger(leftExpr);
        return left >= (right = this.getInteger(rightExpr));
    }

    private int getInteger(IntegerExpression expr) {
        if (expr instanceof IntegerRef) {
            IntegerElement localLeftElement = this._localInteger.get(((IntegerRef)expr).getIntegerElem());
            if (localLeftElement == null) {
                localLeftElement = ((IntegerRef)expr).getIntegerElem();
            }
            return localLeftElement.getValue();
        }
        if (expr instanceof IntegerVariableRef) {
            SolverElement ce = (SolverElement)this._abstract2concreteMap.getLocalValue(((IntegerVariableRef)expr).getReferencedVar());
            if (ce instanceof SolverPrimitiveElement) {
                try {
                    return ((IntegerElement)((SolverPrimitiveElement)ce).getPrimitiveElement()).getValue();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("warning, you should only refer to IntegerVariable: " + e.toString());
                }
            }
        } else {
            if (expr instanceof IntegerRef) {
                return ((IntegerRef)expr).getIntegerElem().getValue();
            }
            if (expr instanceof IntPlus) {
                IntPlus plus = (IntPlus)expr;
                int iToIncrement = this.getInteger(plus.getLeftValue());
                int incrementValue = this.getInteger(plus.getRightValue());
                return iToIncrement + incrementValue;
            }
            if (expr instanceof IntMinus) {
                IntMinus minus = (IntMinus)expr;
                int iToDecrement = this.getInteger(minus.getLeftValue());
                int decrementValue = this.getInteger(minus.getRightValue());
                return iToDecrement - decrementValue;
            }
            throw new IllegalArgumentException("left value of assignment should be integerRef (to a local integer !)");
        }
        return -1;
    }

    public SerializedConstraintState dumpState() {
        SerializedConstraintState scs = super.dumpState();
        int currentStateIndex = this._modelSTS.getStates().indexOf((Object)this._currentState);
        scs.dump((Object)currentStateIndex);
        for (IntegerElement ie : this._orderedLocalInteger) {
            scs.dump((Object)ie.getValue());
        }
        return scs;
    }

    public void restoreState(SerializedConstraintState scs) {
        this._currentState = (State)this._modelSTS.getStates().get(((Integer)scs.restore(0)).intValue());
        int i = 1;
        for (IntegerElement ie : this._orderedLocalInteger) {
            ie.setValue((Integer)scs.restore(i++));
        }
    }

    protected ICCSLConstraint[] getConstraints() {
        return new ICCSLConstraint[0];
    }

    public void assertionSemantic(AbstractSemanticHelper helper) {
    }
}

