/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionPlatform;
import org.eclipse.gemoc.xdsmlframework.api.core.IModelLoader;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.EngineAddonSortingRule;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;

public class DefaultExecutionPlatform
implements IExecutionPlatform {
    protected IModelLoader _modelLoader;
    protected Collection<IEngineAddon> _addons;
    private Object _addonLock = new Object();

    public DefaultExecutionPlatform(LanguageDefinitionExtension _languageDefinition, IRunConfiguration runConfiguration) throws CoreException {
        this._modelLoader = _languageDefinition.instanciateModelLoader();
        this._addons = new ArrayList<IEngineAddon>();
        for (EngineAddonSpecificationExtension extension : runConfiguration.getEngineAddonExtensions()) {
            Activator.getDefault().debug("Enabled addon: " + extension.getName());
            this.addEngineAddon(extension.instanciateComponent());
        }
    }

    public IModelLoader getModelLoader() {
        return this._modelLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<IEngineAddon> getEngineAddons() {
        Object object = this._addonLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<IEngineAddon>(this._addons));
        }
    }

    public void dispose() {
        this._addons.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngineAddon(IEngineAddon addon) {
        Object object = this._addonLock;
        synchronized (object) {
            this._addons.add(addon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEngineAddon(IEngineAddon addon) {
        Object object = this._addonLock;
        synchronized (object) {
            this._addons.remove(addon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IEngineAddon> getSortedEngineAddons(EngineAddonSortingRule.EngineEvent engineEvent) {
        Object object = this._addonLock;
        synchronized (object) {
            ArrayList<IEngineAddon> resList = new ArrayList<IEngineAddon>();
            ArrayList<AddonRuleConnector> consideredAddonRuleConnectors = new ArrayList<AddonRuleConnector>();
            for (IEngineAddon iEngineAddon : this._addons) {
                block8: for (EngineAddonSortingRule rule : iEngineAddon.getAddonSortingRules()) {
                    if (rule.getEvent() != engineEvent) continue;
                    Predicate<IEngineAddon> inList = addon -> rule.getAddonsWithTags().stream().anyMatch(tag -> addon.getTags().contains(tag));
                    List targetAddons = this._addons.stream().filter(inList).collect(Collectors.toList());
                    switch (rule.getPriority()) {
                        case BEFORE: {
                            for (IEngineAddon targetAddon : targetAddons) {
                                consideredAddonRuleConnectors.add(new AddonRuleConnector(iEngineAddon, targetAddon, iEngineAddon, rule));
                            }
                            continue block8;
                        }
                        case AFTER: {
                            for (IEngineAddon targetAddon : targetAddons) {
                                consideredAddonRuleConnectors.add(new AddonRuleConnector(targetAddon, iEngineAddon, iEngineAddon, rule));
                            }
                            continue block8;
                        }
                    }
                }
            }
            List nodeWithIncomingEdge = consideredAddonRuleConnectors.stream().map(connector -> connector.getAfter()).collect(Collectors.toList());
            List nodeWithNoIncomingEdgeSet = this._addons.stream().filter(addon -> !nodeWithIncomingEdge.contains(addon)).collect(Collectors.toList());
            while (!nodeWithNoIncomingEdgeSet.isEmpty()) {
                IEngineAddon n = (IEngineAddon)nodeWithNoIncomingEdgeSet.get(0);
                nodeWithNoIncomingEdgeSet.remove(0);
                resList.add(n);
                List connectorEmittedByN = consideredAddonRuleConnectors.stream().filter(c -> c.getBefore().equals(n)).collect(Collectors.toList());
                for (AddonRuleConnector e : connectorEmittedByN) {
                    consideredAddonRuleConnectors.remove(e);
                    IEngineAddon m = e.getAfter();
                    if (consideredAddonRuleConnectors.stream().anyMatch(c -> c.getAfter().equals(m))) continue;
                    nodeWithNoIncomingEdgeSet.add(m);
                }
            }
            if (!consideredAddonRuleConnectors.isEmpty()) {
                Activator.getDefault().warn("Found at least one cycle in addon rules for engine event: " + engineEvent.toString());
                Activator.getDefault().warn("Rules involved in cycle(s) are:\n  " + consideredAddonRuleConnectors.stream().map(c -> c.getOriginRule().toReadableString()).collect(Collectors.joining("\n  ")));
                for (AddonRuleConnector c2 : consideredAddonRuleConnectors) {
                    resList.add(c2.after);
                }
                Activator.getDefault().warn("Fall back to unsorted rules: " + resList.stream().map(addon -> addon.getAddonID()).collect(Collectors.joining(", ")));
                return Collections.unmodifiableList(resList);
            }
            Activator.getDefault().debug("sorted addons for engine event " + engineEvent.toString() + ": " + resList.stream().map(addon -> addon.getAddonID()).collect(Collectors.joining(", ")));
            return Collections.unmodifiableList(resList);
        }
    }

    class AddonRuleConnector {
        IEngineAddon before;
        IEngineAddon after;
        IEngineAddon ruleOwner;
        EngineAddonSortingRule originRule;

        public AddonRuleConnector(IEngineAddon before, IEngineAddon after, IEngineAddon ruleOwner, EngineAddonSortingRule originRule) {
            this.before = before;
            this.after = after;
            this.ruleOwner = ruleOwner;
            this.originRule = originRule;
        }

        public IEngineAddon getBefore() {
            return this.before;
        }

        public IEngineAddon getAfter() {
            return this.after;
        }

        public IEngineAddon getRuleOwner() {
            return this.ruleOwner;
        }

        public EngineAddonSortingRule getOriginRule() {
            return this.originRule;
        }
    }
}

