/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gemoc.executionframework.engine.ui.Activator;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.AbstractLaunchConfigurationDataProcessingTab;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.tabs.LaunchConfUtils;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonBooleanOptionSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonStringOptionSpecificationExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class EngineAddonLaunchConfigWidget {
    Button mainCheckButton;
    Group optionGroup = null;
    private HashMap<EngineAddonBooleanOptionSpecificationExtension, Button> booleanOptionButtons = new HashMap();
    private HashMap<EngineAddonStringOptionSpecificationExtension, Text> stringOptionTexts = new HashMap();
    AbstractLaunchConfigurationDataProcessingTab parentTab;
    EngineAddonSpecificationExtension extension;

    public EngineAddonLaunchConfigWidget(AbstractLaunchConfigurationDataProcessingTab parentTab, Composite parent, EngineAddonSpecificationExtension extension) {
        this.parentTab = parentTab;
        this.extension = extension;
        this.createComponentForExtension(parent, extension);
    }

    protected void createComponentForExtension(Composite parentGroup, EngineAddonSpecificationExtension extension) {
        if (extension.getAddonBooleanOptionsIds().isEmpty()) {
            extension.getAddonStringOptionsIds().isEmpty();
        }
        this.mainCheckButton = LaunchConfUtils.createCheckButton(parentGroup, String.valueOf(extension.getName()) + ":");
        this.mainCheckButton.setToolTipText(String.valueOf(extension.getId()) + " contributed by " + extension.getContributorName());
        this.mainCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EngineAddonLaunchConfigWidget.this.setOptionsEnabled(EngineAddonLaunchConfigWidget.this.mainCheckButton.getSelection());
                EngineAddonLaunchConfigWidget.this.parentTab.updateTab();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String desc = extension.getShortDescription() != null ? extension.getShortDescription() : "";
        LaunchConfUtils.createTextLabelLayout(parentGroup, desc, "contributed by " + extension.getContributorName());
        if (!extension.getAddonBooleanOptionsIds().isEmpty() || !extension.getAddonStringOptionsIds().isEmpty()) {
            GridData gd;
            Label l;
            this.optionGroup = LaunchConfUtils.createGroup(parentGroup, "addon options", 2);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = 2;
            gridData.horizontalIndent = 30;
            gridData.horizontalAlignment = 4;
            this.optionGroup.setLayoutData((Object)gridData);
            for (EngineAddonBooleanOptionSpecificationExtension booleanOption : extension.getAddonBooleanOptionSpecificationExtensions()) {
                l = LaunchConfUtils.createTextLabelLayout((Composite)this.optionGroup, String.valueOf(booleanOption.getName()) + ":");
                gd = new GridData(131072, 128, false, false);
                l.setLayoutData((Object)gd);
                Button b = LaunchConfUtils.createCheckButton((Composite)this.optionGroup, "");
                b.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        EngineAddonLaunchConfigWidget.this.parentTab.updateTab();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (extension.getShortDescription() != null) {
                    b.setToolTipText(booleanOption.getShortDescription());
                    l.setToolTipText(booleanOption.getShortDescription());
                }
                this.booleanOptionButtons.put(booleanOption, b);
            }
            for (EngineAddonStringOptionSpecificationExtension stringOption : extension.getAddonStringOptionSpecificationExtensions()) {
                l = LaunchConfUtils.createTextLabelLayout((Composite)this.optionGroup, String.valueOf(stringOption.getName()) + ":");
                gd = new GridData(131072, 128, false, false);
                l.setLayoutData((Object)gd);
                Text t = new Text((Composite)this.optionGroup, 2052);
                t.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                t.setFont(null);
                t.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent arg0) {
                        EngineAddonLaunchConfigWidget.this.parentTab.updateTab();
                    }
                });
                if (extension.getShortDescription() != null) {
                    t.setToolTipText(stringOption.getShortDescription());
                }
                this.stringOptionTexts.put(stringOption, t);
            }
        }
    }

    public void setOptionsEnabled(boolean enabled) {
        if (this.optionGroup != null) {
            this.optionGroup.setEnabled(enabled);
            Control[] controlArray = this.optionGroup.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setEnabled(enabled);
                ++n2;
            }
        }
    }

    public void optionInitializeFrom(ILaunchConfiguration configuration) {
        if (this.optionGroup != null) {
            String key;
            for (EngineAddonBooleanOptionSpecificationExtension booleanOption : this.booleanOptionButtons.keySet()) {
                try {
                    key = booleanOption.getId();
                    boolean value = configuration.getAttribute(key, false);
                    this.booleanOptionButtons.get(booleanOption).setSelection(value);
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                }
            }
            for (EngineAddonStringOptionSpecificationExtension option : this.stringOptionTexts.keySet()) {
                try {
                    key = option.getId();
                    String value = configuration.getAttribute(key, "");
                    this.stringOptionTexts.get(option).setText(value);
                }
                catch (CoreException e) {
                    Activator.error(e.getMessage(), e);
                }
            }
        }
    }

    public void optionsPerformApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.optionGroup != null) {
            String key;
            for (EngineAddonBooleanOptionSpecificationExtension booleanOption : this.booleanOptionButtons.keySet()) {
                key = booleanOption.getId();
                configuration.setAttribute(key, this.booleanOptionButtons.get(booleanOption).getSelection());
            }
            for (EngineAddonStringOptionSpecificationExtension option : this.stringOptionTexts.keySet()) {
                key = option.getId();
                configuration.setAttribute(key, this.stringOptionTexts.get(option).getText());
            }
        }
    }
}

