/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.behavioralinterface.behavioralInterface;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventType implements Enumerator
{
    BOTH(0, "BOTH", "both"),
    ACCEPTED(1, "ACCEPTED", "accepted"),
    EXPOSED(2, "EXPOSED", "exposed");

    public static final int BOTH_VALUE = 0;
    public static final int ACCEPTED_VALUE = 1;
    public static final int EXPOSED_VALUE = 2;
    private static final EventType[] VALUES_ARRAY;
    public static final List<EventType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventType[]{BOTH, ACCEPTED, EXPOSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventType get(int value) {
        switch (value) {
            case 0: {
                return BOTH;
            }
            case 1: {
                return ACCEPTED;
            }
            case 2: {
                return EXPOSED;
            }
        }
        return null;
    }

    private EventType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

