/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.validation.ITypeChecker;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidationMessageFactory;
import org.eclipse.emf.ecoretools.ale.core.validation.IVariableModificationStrategy;

class RemovalStrategy
implements IVariableModificationStrategy {
    private final ITypeChecker typeChecker;
    private final IValidationMessageFactory messages;

    public RemovalStrategy(ITypeChecker typeChecker, IValidationMessageFactory messages) {
        this.typeChecker = typeChecker;
        this.messages = messages;
    }

    @Override
    public boolean isInsertion() {
        return false;
    }

    @Override
    public Set<IType> acceptedTypes(Set<IType> variableTypes) {
        return this.typeChecker.acceptedTypesForRemoval(variableTypes);
    }

    @Override
    public boolean supportsModification(IType variableType) {
        return this.typeChecker.supportsRemoval(variableType);
    }

    @Override
    public boolean acceptsModification(Set<IType> variableTypes, Set<IType> valueTypes) {
        return this.typeChecker.acceptsRemoval(variableTypes, valueTypes);
    }

    @Override
    public Message createIllegalModificationMessage(Set<IType> variableTypes, Set<IType> valueTypes, Set<IType> acceptedValueTypes, Expression valueExpression) {
        return this.messages.illegalRemoval(variableTypes, valueTypes, acceptedValueTypes, valueExpression);
    }
}

