/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.PaletteDefinition;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IVisualiserPalette;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.palettes.DefaultVisualiserPalette;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class PaletteManager {
    public static final String PALETTE_EXTENSION = "org.eclipse.contribution.visualiser.palettes";
    private static final String DEFAULT_PALETTE_CLASS = "org.eclipse.contribution.visualiser.palettes.DefaultVisualiserPalette";
    private static List palettes;
    private static PaletteDefinition current;

    public static List getAllPaletteDefinitions() {
        if (palettes == null) {
            PaletteManager.initialisePaletteDefinitions();
        }
        return palettes;
    }

    public static PaletteDefinition getCurrentPalette() {
        if (current == null) {
            String pid = VisualiserPreferences.getPaletteIDForProvider(ProviderManager.getCurrent().getID());
            if (pid != null && pid.length() > 0) {
                current = PaletteManager.getPaletteByID(pid);
            }
            if (current == null && (pid = ProviderManager.getCurrent().getPaletteID()) != null && pid.length() > 0) {
                current = PaletteManager.getPaletteByID(pid);
            }
            if (current == null) {
                current = PaletteManager.getDefaultPalette();
            }
        }
        return current;
    }

    public static PaletteDefinition getPaletteByName(String name) {
        Iterator iter = PaletteManager.getAllPaletteDefinitions().iterator();
        while (iter.hasNext()) {
            PaletteDefinition r = (PaletteDefinition)iter.next();
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public static PaletteDefinition getPaletteByID(String id) {
        Iterator iter = PaletteManager.getAllPaletteDefinitions().iterator();
        while (iter.hasNext()) {
            PaletteDefinition r = (PaletteDefinition)iter.next();
            if (!r.getID().equals(id)) continue;
            return r;
        }
        return null;
    }

    public static void resetCurrent() {
        current = null;
    }

    public static void setCurrentPaletteByName(String name) {
        PaletteDefinition r = PaletteManager.getPaletteByName(name);
        if (r != null) {
            current = r;
        }
    }

    public static PaletteDefinition getDefaultPalette() {
        if (palettes == null) {
            PaletteManager.initialisePaletteDefinitions();
        }
        Iterator iter = palettes.iterator();
        while (iter.hasNext()) {
            PaletteDefinition r = (PaletteDefinition)iter.next();
            if (!(r.getPalette() instanceof DefaultVisualiserPalette) || !r.getPalette().getClass().getName().equals(DEFAULT_PALETTE_CLASS)) continue;
            return r;
        }
        return null;
    }

    public static PaletteDefinition getDefaultForProvider(ProviderDefinition def) {
        PaletteDefinition r = PaletteManager.getPaletteByID(def.getPaletteID());
        if (r == null) {
            r = PaletteManager.getDefaultPalette();
        }
        return r;
    }

    private static void initialisePaletteDefinitions() {
        palettes = new ArrayList();
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(PALETTE_EXTENSION);
        IExtension[] exs = exP.getExtensions();
        int i = 0;
        while (i < exs.length) {
            IConfigurationElement[] ces = exs[i].getConfigurationElements();
            int j = 0;
            while (j < ces.length) {
                try {
                    Object ext = ces[j].createExecutableExtension("class");
                    if (ext instanceof IVisualiserPalette) {
                        String name = ces[j].getAttribute("name");
                        String id = ces[j].getAttribute("id");
                        PaletteDefinition rd = new PaletteDefinition(id, name, (IVisualiserPalette)ext);
                        palettes.add(rd);
                    }
                }
                catch (CoreException e) {
                    VisualiserPlugin.logException(e);
                }
                ++j;
            }
            ++i;
        }
    }
}

