/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.mwe.SlotEntry;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class ResourceSetBasedSlotEntry
extends SlotEntry {
    @Override
    protected List<EObject> findEObjectsOfType(Set<EClass> eClasses, IResourceDescriptions resourceDescriptions, ResourceSet resourceSet) {
        ArrayList result = Lists.newArrayList();
        for (Resource resource : resourceSet.getResources()) {
            if (resource.isLoaded()) continue;
            try {
                resource.load(null);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
        }
        TreeIterator i = resourceSet.getAllContents();
        while (i.hasNext()) {
            Notifier next = (Notifier)i.next();
            if (!(next instanceof EObject) || !this.matches(eClasses, (EObject)next)) continue;
            result.add((EObject)next);
        }
        return result;
    }

    protected boolean matches(Set<EClass> eClasses, EObject eObject) {
        if (eClasses.isEmpty()) {
            return true;
        }
        EClass candidateEClass = eObject.eClass();
        for (EClass eClass : eClasses) {
            if (EcorePackage.Literals.EOBJECT != eClass && !eClass.isSuperTypeOf(candidateEClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("This implementation does not support name filtering.");
    }
}

