/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.ide.proposal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IQueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.QueryCompletion;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.common.acceleo.aql.business.api.ExpressionTrimmer;
import org.eclipse.sirius.common.acceleo.aql.business.api.TypesUtil;
import org.eclipse.sirius.common.acceleo.aql.business.internal.AQLSiriusInterpreter;
import org.eclipse.sirius.common.acceleo.aql.ide.Messages;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposalBuilder;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;

public class AQLProposalProvider
implements IProposalProvider {
    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("aql:", "aql:", Messages.AQL_newExpression, "aql:".length());
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        ExpressionTrimmer trimer;
        if (interpreter instanceof AQLSiriusInterpreter && (trimer = new ExpressionTrimmer(context.getContents())).positionIsWithinAQL(context.getPosition())) {
            AQLSiriusInterpreter aqlInterpreter = (AQLSiriusInterpreter)interpreter;
            this.setupInterpreter(context, aqlInterpreter);
            Map variableTypes = TypesUtil.createAQLVariableTypesFromInterpreterContext((IInterpreterContext)context.getInterpreterContext(), (IQueryEnvironment)aqlInterpreter.getQueryEnvironment());
            return ImmutableList.copyOf(this.getProposals(trimer, context.getPosition(), aqlInterpreter.getQueryEnvironment(), variableTypes, IProposalProvider.ProposalAcceptanceStyle.PROPOSAL_INSERT));
        }
        return Collections.emptyList();
    }

    private void setupInterpreter(ContentContext context, AQLSiriusInterpreter interpreter) {
        Resource vsmResource;
        ArrayList<EcoreMetamodelDescriptor> metamodels = new ArrayList<EcoreMetamodelDescriptor>();
        for (EPackage pak : context.getInterpreterContext().getAvailableEPackages()) {
            if (pak == null) continue;
            metamodels.add(new EcoreMetamodelDescriptor(pak));
        }
        interpreter.activateMetamodels(metamodels);
        if (context.getInterpreterContext().getElement() != null && (vsmResource = context.getInterpreterContext().getElement().eResource()) != null) {
            interpreter.setProperty((Object)"files", (Object)Lists.newArrayList((Object[])new String[]{vsmResource.getURI().toPlatformString(true)}));
        }
        for (String imp : context.getInterpreterContext().getDependencies()) {
            interpreter.addImport(imp);
        }
    }

    private Set<ContentProposal> getProposals(ExpressionTrimmer trimmer, int position, IQueryEnvironment queryEnvironment, Map<String, Set<IType>> variableTypes, IProposalProvider.ProposalAcceptanceStyle proposalAcceptanceStyle) {
        LinkedHashSet<ContentProposal> proposals = new LinkedHashSet<ContentProposal>();
        IQueryCompletionEngine engine = QueryCompletion.newEngine((IQueryEnvironment)queryEnvironment);
        ICompletionResult completionResult = engine.getCompletion(trimmer.getExpression(), trimmer.getPositionWithinAQL(position), variableTypes);
        LinkedHashSet aqlProposals = Sets.newLinkedHashSet((Iterable)completionResult.getProposals(QueryCompletion.createBasicFilter((ICompletionResult)completionResult)));
        for (ICompletionProposal propFromAQL : aqlProposals) {
            int offset = trimmer.getPositionInExpression(completionResult.getReplacementOffset());
            String proposal = "";
            ContentProposal contentProposal = null;
            if (proposalAcceptanceStyle.equals((Object)IProposalProvider.ProposalAcceptanceStyle.PROPOSAL_INSERT)) {
                proposal = propFromAQL.getProposal().substring(completionResult.getReplacementLength());
                contentProposal = ContentProposalBuilder.proposal((String)proposal, (String)propFromAQL.toString(), (String)propFromAQL.getDescription(), (int)propFromAQL.getCursorOffset()).build();
            } else if (proposalAcceptanceStyle.equals((Object)IProposalProvider.ProposalAcceptanceStyle.PROPOSAL_REPLACE)) {
                int length = completionResult.getReplacementLength() + completionResult.getRemaining().length();
                proposal = propFromAQL.getProposal();
                contentProposal = ContentProposalBuilder.proposal((String)proposal, (String)propFromAQL.toString(), (String)propFromAQL.getDescription(), (int)propFromAQL.getCursorOffset()).withReplacement(offset, length).build();
            }
            proposals.add(contentProposal);
        }
        return proposals;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        if (interpreter instanceof AQLSiriusInterpreter) {
            ExpressionTrimmer trimer;
            IQueryEnvironment queryEnvironment = ((AQLSiriusInterpreter)interpreter).getQueryEnvironment();
            LinkedHashMap<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();
            if (context.getCurrentSelected() != null) {
                queryEnvironment.registerEPackage(context.getCurrentSelected().eClass().getEPackage());
                LinkedHashSet<EClassifierType> potentialTypes = new LinkedHashSet<EClassifierType>(1);
                potentialTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)queryEnvironment, (EClassifier)context.getCurrentSelected().eClass()));
                variableTypes.put("self", potentialTypes);
            }
            if ((trimer = new ExpressionTrimmer(context.getTextSoFar())).positionIsWithinAQL(context.getCursorPosition())) {
                return ImmutableList.copyOf(this.getProposals(trimer, context.getCursorPosition(), queryEnvironment, variableTypes, IProposalProvider.ProposalAcceptanceStyle.PROPOSAL_REPLACE));
            }
        }
        return Collections.emptyList();
    }
}

