/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.filter.FilteredIndex;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscovery;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.console.MavenConsoleImpl;
import org.eclipse.m2e.core.ui.internal.project.MavenUpdateConfigurationChangeListener;
import org.eclipse.m2e.core.ui.internal.search.util.IndexSearchEngine;
import org.eclipse.m2e.core.ui.internal.search.util.SearchEngine;
import org.eclipse.m2e.core.ui.internal.wizards.IMavenDiscoveryUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class M2EUIPluginActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.m2e.core.ui";
    private static M2EUIPluginActivator instance;
    private ScopedPreferenceStore preferenceStore;
    private MavenConsoleImpl console;
    private MavenUpdateConfigurationChangeListener mavenUpdateConfigurationChangeListener;

    public M2EUIPluginActivator() {
        instance = this;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.m2e.core");
        }
        return this.preferenceStore;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.mavenUpdateConfigurationChangeListener = new MavenUpdateConfigurationChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.mavenUpdateConfigurationChangeListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.mavenUpdateConfigurationChangeListener);
        this.mavenUpdateConfigurationChangeListener = null;
    }

    public static M2EUIPluginActivator getDefault() {
        return instance;
    }

    public static Image getImage(String path) {
        ImageRegistry registry = M2EUIPluginActivator.getDefault().getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            registry.put(path, M2EUIPluginActivator.imageDescriptorFromPlugin((String)"org.eclipse.m2e.core", (String)path));
            image = registry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return M2EUIPluginActivator.imageDescriptorFromPlugin((String)"org.eclipse.m2e.core", (String)path);
    }

    public synchronized MavenConsoleImpl getMavenConsole() {
        if (this.console == null) {
            this.console = new MavenConsoleImpl(MavenImages.M2);
        }
        return this.console;
    }

    public boolean hasMavenConsoleImpl() {
        return this.console != null;
    }

    public SearchEngine getSearchEngine(IProject project) throws CoreException {
        return new IndexSearchEngine((IIndex)new FilteredIndex(project, MavenPlugin.getIndexManager().getIndex(project)));
    }

    public synchronized IMavenDiscovery getMavenDiscovery() {
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMavenDiscovery.class);
        if (serviceReference != null) {
            return (IMavenDiscovery)context.getService(serviceReference);
        }
        return null;
    }

    public void ungetMavenDiscovery(IMavenDiscovery discovery) {
    }

    public IMavenDiscoveryUI getImportWizardPageFactory() {
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMavenDiscoveryUI.class);
        if (serviceReference != null) {
            return (IMavenDiscoveryUI)context.getService(serviceReference);
        }
        return null;
    }
}

