/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ide.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.xdsmlframework.ide.ui.Activator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractGemocLanguageProjectHandler
extends AbstractHandler {
    public static final String DSL_EXTENSION = "dsl";

    protected IProject getUpdatedGemocLanguageProjectFromSelection(ExecutionEvent event) {
        IResource res;
        IProject updatedGemocLanguageProject = null;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null & selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object element : strucSelection) {
                IResource res2;
                if (element instanceof IResource) {
                    updatedGemocLanguageProject = ((IResource)element).getProject();
                }
                if (!(element instanceof IAdaptable) || (res2 = (IResource)((IAdaptable)element).getAdapter(IResource.class)) == null) continue;
                updatedGemocLanguageProject = res2.getProject();
            }
        } else if (selection != null & selection instanceof ITextSelection && (res = (IResource)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActiveEditor().getEditorInput().getAdapter(IResource.class)) != null) {
            updatedGemocLanguageProject = res.getProject();
        }
        return updatedGemocLanguageProject;
    }

    protected IFile getDslFileFromSelection(ExecutionEvent event) {
        IFile selectedDslIFile = null;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null & selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object element : strucSelection) {
                IFile res;
                if (element instanceof IFile && ((IFile)element).getFileExtension().equals(DSL_EXTENSION)) {
                    selectedDslIFile = (IFile)element;
                }
                if (!(element instanceof IAdaptable) || (res = (IFile)((IAdaptable)element).getAdapter(IFile.class)) == null || !res.getFileExtension().equals(DSL_EXTENSION)) continue;
                selectedDslIFile = res;
            }
        }
        if (selectedDslIFile == null) {
            IProject updatedGemocLanguageProject = this.getUpdatedGemocLanguageProjectFromSelection(event);
            return this.getDslFileFromProject(updatedGemocLanguageProject);
        }
        return selectedDslIFile;
    }

    protected IFile getDslFileFromProject(IProject updatedGemocLanguageProject) {
        FileFinderVisitor dslProjectVisitor = new FileFinderVisitor(DSL_EXTENSION);
        try {
            updatedGemocLanguageProject.accept((IResourceVisitor)dslProjectVisitor);
            for (IFile projectDslIFile : dslProjectVisitor.getFiles()) {
                if (projectDslIFile.getFullPath().toString().contains("/bin/") | projectDslIFile.getFullPath().toString().contains("/target/")) continue;
                return projectDslIFile;
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
        return null;
    }

    protected String getDslNameFromSelection(ExecutionEvent event) {
        IFile dslFile = this.getDslFileFromSelection(event);
        Resource res = new ResourceSetImpl().getResource(URI.createURI((String)dslFile.getFullPath().toOSString()), true);
        return ((Dsl)res.getContents().get(0)).getName();
    }
}

