/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.gemoc.generator;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.opsemanticsview.gen.OperationalSemanticsViewGenerator;
import org.eclipse.gemoc.trace.gemoc.generator.GenericEngineTraceAddonGenerator;
import org.eclipse.gemoc.xdsmlframework.ui.utils.XDSMLProjectHelper;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * Plenty of ways to call the generator in an eclipse context.
 * Relies on a OperationalSemanticsViewGenerator found using an extension point.
 */
@SuppressWarnings("all")
public class TraceAddonGeneratorIntegration {
  public static void generateAddon(final IFile melangeFile, final String selectedLanguage, final boolean replace, final IProgressMonitor monitor) {
    String _baseProjectName = XDSMLProjectHelper.baseProjectName(melangeFile.getProject());
    String _plus = (_baseProjectName + ".");
    String _lowerCase = selectedLanguage.toLowerCase();
    String _plus_1 = (_plus + _lowerCase);
    final String pluginName = (_plus_1 + ".trace");
    TraceAddonGeneratorIntegration.generateAddon(melangeFile, selectedLanguage, pluginName, replace, monitor);
  }
  
  public static void generateAddon(final IFile dslFile, final String selectedLanguage, final String pluginName, final boolean replace, final IProgressMonitor monitor) {
    try {
      final Dsl selection = TraceAddonGeneratorIntegration.loadDsl(dslFile);
      final IConfigurationElement[] configNew = Platform.getExtensionRegistry().getConfigurationElementsFor(
        "org.eclipse.gemoc.opsemanticsview.gen");
      final Function1<IConfigurationElement, Object> _function = new Function1<IConfigurationElement, Object>() {
        @Override
        public Object apply(final IConfigurationElement e) {
          try {
            return e.createExecutableExtension("class");
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      };
      final Function1<OperationalSemanticsViewGenerator, Boolean> _function_1 = new Function1<OperationalSemanticsViewGenerator, Boolean>() {
        @Override
        public Boolean apply(final OperationalSemanticsViewGenerator conf) {
          return Boolean.valueOf(conf.canHandle(selection, dslFile.getProject()));
        }
      };
      final OperationalSemanticsViewGenerator validViewGenerator = IterableExtensions.<OperationalSemanticsViewGenerator>findFirst(Iterables.<OperationalSemanticsViewGenerator>filter(ListExtensions.<IConfigurationElement, Object>map(((List<IConfigurationElement>)Conversions.doWrapArray(configNew)), _function), OperationalSemanticsViewGenerator.class), _function_1);
      if ((validViewGenerator != null)) {
        final OperationalSemanticsView mmextension = validViewGenerator.generate(selection, dslFile.getProject());
        TraceAddonGeneratorIntegration.generateAddon(selectedLanguage, pluginName, replace, monitor, mmextension);
      } else {
        Status _status = new Status(
          Status.ERROR, 
          "org.eclipse.gemoc.trace.gemoc.generator", 
          "Impossible to create a trace addon: couldn\'t find an opsemanticsview generator that can manage the chosen melange language.");
        throw new CoreException(_status);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Central operation of the class, that calls business operations
   */
  public static void generateAddon(final String mmName, final String pluginName, final boolean replace, final IProgressMonitor monitor, final OperationalSemanticsView executionExtension) throws CoreException {
    final IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginName);
    boolean _exists = existingProject.exists();
    if (_exists) {
      if (replace) {
        String _name = existingProject.getName();
        String _plus = ("deleting project " + _name);
        String _plus_1 = (_plus + " content");
        final WorkspaceJob job = new WorkspaceJob(_plus_1) {
          @Override
          public IStatus runInWorkspace(final IProgressMonitor monitor) throws CoreException {
            IResource[] _members = existingProject.members();
            for (final IResource iRes : _members) {
              boolean _not = (!(iRes.getName().equals(".project") || iRes.getName().equals(".classpath")));
              if (_not) {
                iRes.delete(true, monitor);
              }
            }
            return Status.OK_STATUS;
          }
        };
        job.setRule(existingProject);
        job.schedule();
      } else {
        Status _status = new Status(Status.ERROR, "org.eclipse.gemoc.trace.gemoc.generator", 
          "Impossible to create a trace addon: a project already exists with this name.");
        throw new CoreException(_status);
      }
    }
    try {
      final GenericEngineTraceAddonGenerator traceaddgen = new GenericEngineTraceAddonGenerator(executionExtension, pluginName);
      traceaddgen.generateCompleteAddon(monitor);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  protected static Dsl loadDsl(final IFile dslFile) {
    final Resource res = new ResourceSetImpl().getResource(URI.createURI(dslFile.getFullPath().toOSString()), true);
    EObject _get = res.getContents().get(0);
    final Dsl dsl = ((Dsl) _get);
    return dsl;
  }
}
