/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.extensions.sirius.modelloader;

import fr.inria.diverse.melange.adapters.EObjectAdapter;
import fr.inria.diverse.melange.resource.MelangeRegistry;
import fr.inria.diverse.melange.resource.MelangeResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.dsl.debug.ide.sirius.ui.services.AbstractDSLDebuggerServices;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.executionframework.extensions.sirius.Activator;
import org.eclipse.gemoc.executionframework.extensions.sirius.debug.DebugSessionFactory;
import org.eclipse.gemoc.executionframework.extensions.sirius.modelloader.DebugPermissionProvider;
import org.eclipse.gemoc.executionframework.extensions.sirius.modelloader.DebugURIHandler;
import org.eclipse.gemoc.executionframework.extensions.sirius.modelloader.PaletteUtils;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.AbstractGemocAnimatorServices;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IModelLoader;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.ui.business.internal.command.RefreshDiagramOnOpeningCommand;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.ToolFilter;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextPlatformResourceURIHandler;
import org.eclipse.xtext.util.StringInputStream;

public class DefaultModelLoader
implements IModelLoader {
    IProgressMonitor progressMonitor;

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public Resource loadModel(IExecutionContext<?, ?, ?> context) throws RuntimeException {
        return DefaultModelLoader.loadModel(context, false, this.progressMonitor);
    }

    public Resource loadModelForAnimation(IExecutionContext<?, ?, ?> context) throws RuntimeException {
        return DefaultModelLoader.loadModel(context, true, this.progressMonitor);
    }

    private static Resource loadModel(IExecutionContext<?, ?, ?> context, boolean withAnimation, IProgressMonitor progressMonitor) throws RuntimeException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)10);
        boolean useMelange = context.getRunConfiguration().getMelangeQuery() != null && !context.getRunConfiguration().getMelangeQuery().isEmpty();
        URI modelURI = null;
        if (useMelange) {
            subMonitor.setTaskName("Loading model with melange");
            modelURI = context.getRunConfiguration().getExecutedModelAsMelangeURI();
        } else {
            subMonitor.setTaskName("Loading model without melange");
            modelURI = context.getRunConfiguration().getExecutedModelURI();
        }
        HashMap<String, String> nsURIMapping = DefaultModelLoader.getnsURIMapping(context);
        ResourceSet resourceSet = DefaultModelLoader.createResourceSet(modelURI, nsURIMapping, subMonitor);
        if (withAnimation && context.getRunConfiguration().getAnimatorURI() != null) {
            try {
                DefaultModelLoader.killPreviousSiriusSession(context.getRunConfiguration().getAnimatorURI());
                DefaultModelLoader.openNewSiriusSession(context, context.getRunConfiguration().getAnimatorURI(), resourceSet, modelURI, subMonitor, nsURIMapping);
                for (Resource r : resourceSet.getResources()) {
                    if (!r.getURI().equals(modelURI)) continue;
                    return r;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException("The model could not be loaded.", e);
            }
            throw new RuntimeException("The model could not be loaded.");
        }
        return DefaultModelLoader.loadModelThenConfigureResourceSet(resourceSet, modelURI, nsURIMapping, subMonitor);
    }

    private static void killPreviousSiriusSession(URI sessionResourceURI) {
        final Session session = SessionManager.INSTANCE.getExistingSession(sessionResourceURI);
        if (session != null) {
            final IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            DebugPermissionProvider permProvider = new DebugPermissionProvider();
            if (!permProvider.provides(session.getTransactionalEditingDomain().getResourceSet()) && uiSession != null) {
                for (final DialectEditor editor : uiSession.getEditors()) {
                    final IEditorSite editorSite = editor.getEditorSite();
                    if (editor.getSite() != null) continue;
                    editorSite.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            editorSite.getPage().closeEditor((IEditorPart)editor, true);
                        }
                    });
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        uiSession.close();
                    }
                });
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    session.close((IProgressMonitor)new NullProgressMonitor());
                    SessionManager.INSTANCE.remove(session);
                }
            });
        }
    }

    private static Session openNewSiriusSession(final IExecutionContext<?, ?, ?> context, URI sessionResourceURI, ResourceSet rs, final URI modelURI, SubMonitor subMonitor, HashMap<String, String> nsURIMapping) throws CoreException {
        subMonitor.subTask("Loading model");
        subMonitor.newChild(3);
        Resource r = DefaultModelLoader.loadModelThenConfigureResourceSet(rs, modelURI, nsURIMapping, subMonitor);
        if (r instanceof MelangeResourceImpl) {
            MelangeResourceImpl mr = (MelangeResourceImpl)r;
            rs.getResources().add((Object)mr.getWrappedResource());
            if (!r.getContents().isEmpty() && r.getContents().get(0) instanceof EObjectAdapter) {
                Resource realResource = ((EObjectAdapter)r.getContents().get(0)).getAdaptee().eResource();
                rs.getResources().add((Object)realResource);
            }
        }
        URI airdURI = sessionResourceURI;
        subMonitor.subTask("Creating Sirius session");
        subMonitor.newChild(1);
        final Session session = DebugSessionFactory.INSTANCE.createSession(rs, airdURI);
        final TransactionalEditingDomain editingDomain = session.getTransactionalEditingDomain();
        if (r.getContents().size() > 0) {
            Resource res = ((EObject)r.getContents().get(0)).eResource();
            res.eAdapters().add((Object)new SessionTransientAttachment(session));
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    DAnalysisSessionImpl sessionImpl = (DAnalysisSessionImpl)session;
                    EList srList = ((DAnalysis)sessionImpl.getAnalyses().get(0)).getSemanticResources();
                    srList.clear();
                    srList.add((Object)new ResourceDescriptor(modelURI));
                }
            };
            try {
                CommandExecution.execute((TransactionalEditingDomain)editingDomain, (RecordingCommand)cmd);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not link the resource to the sirius session", e);
            }
        }
        subMonitor.subTask("Opening Sirius session");
        session.open((IProgressMonitor)subMonitor.newChild(2));
        subMonitor.subTask("Opening Sirius editors");
        final SubMonitor openEditorSubMonitor = subMonitor.newChild(2);
        for (DView view : session.getSelectedViews()) {
            for (DRepresentationDescriptor repDescriptor : view.getOwnedRepresentationDescriptors()) {
                DRepresentation representation = repDescriptor.getRepresentation();
                final DSemanticDiagram diagram = (DSemanticDiagram)representation;
                openEditorSubMonitor.subTask(diagram.getName());
                ArrayList<DSemanticDiagram> elements = new ArrayList<DSemanticDiagram>();
                elements.add(diagram);
                IEditorPart editorPart = DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)openEditorSubMonitor.newChild(1));
                if (editorPart instanceof DDiagramEditor) {
                    ((DDiagramEditor)editorPart).getPaletteManager().addToolFilter(new ToolFilter(){

                        public boolean filter(DDiagram diagram, AbstractToolDescription tool) {
                            return true;
                        }
                    });
                }
                try {
                    RefreshDiagramOnOpeningCommand refresh = new RefreshDiagramOnOpeningCommand(editingDomain, diagram);
                    CommandExecution.execute((TransactionalEditingDomain)editingDomain, (RecordingCommand)refresh);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.executionframework.extensions.sirius", "Problem refreshing diagrams : " + diagram, (Throwable)e));
                }
                if (editorPart instanceof DiagramEditorWithFlyOutPalette) {
                    PaletteUtils.colapsePalette((DiagramEditorWithFlyOutPalette)editorPart);
                }
                RecordingCommand command = new RecordingCommand(editingDomain, "Activating animator and debug layers"){

                    protected void doExecute() {
                        boolean hasADebugLayer = false;
                        HashSet layers = new HashSet();
                        layers.addAll(diagram.getDescription().getAdditionalLayers());
                        Collection selectedVp = session.getSelectedViewpoints(true);
                        for (Viewpoint vp : selectedVp) {
                            for (RepresentationExtensionDescription extension : vp.getOwnedRepresentationExtensions()) {
                                if (!(extension instanceof DiagramExtensionDescription)) continue;
                                layers.addAll(((DiagramExtensionDescription)extension).getLayers());
                            }
                        }
                        for (Layer l : layers) {
                            String descName = diagram.getDescription().getName();
                            String layerName = l.getName();
                            boolean mustBeActiveForDebug = AbstractDSLDebuggerServices.LISTENER.isRepresentationToRefresh(context.getRunConfiguration().getDebugModelID(), descName, layerName) || layerName.equalsIgnoreCase("Debug");
                            boolean mustBeActiveForAnimation = AbstractGemocAnimatorServices.ANIMATOR.isRepresentationToRefresh(descName, layerName) || layerName.equalsIgnoreCase("Animation");
                            boolean mustBeActive = mustBeActiveForAnimation || mustBeActiveForDebug;
                            boolean bl = hasADebugLayer = hasADebugLayer || mustBeActiveForDebug;
                            if (!mustBeActive || diagram.getActivatedLayers().contains((Object)l)) continue;
                            ChangeLayerActivationCommand c = new ChangeLayerActivationCommand(editingDomain, (DDiagram)diagram, l, (IProgressMonitor)openEditorSubMonitor.newChild(1));
                            c.execute();
                        }
                        if (!hasADebugLayer) {
                            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.gemoc.executionframework.extensions.sirius", "No debug service defined in the odesign for the debug model id : " + context.getRunConfiguration().getDebugModelID()));
                        }
                    }
                };
                CommandExecution.execute((TransactionalEditingDomain)editingDomain, (RecordingCommand)command);
            }
        }
        return session;
    }

    private static ResourceSet createResourceSet(URI modelURI, HashMap<String, String> nsURIMapping, SubMonitor subMonitor) {
        ResourceSet rs = ResourceSetFactory.createFactory().createResourceSet(modelURI);
        return rs;
    }

    private static Resource loadModelThenConfigureResourceSet(ResourceSet rs, URI modelURI, HashMap<String, String> nsURIMapping, SubMonitor subMonitor) {
        Resource resource = rs.getResource(modelURI, true);
        EcoreUtil.resolveAll((ResourceSet)rs);
        DefaultModelLoader.configureResourceSet(rs, modelURI, nsURIMapping, subMonitor);
        return resource;
    }

    private static void configureResourceSet(ResourceSet rs, URI modelURI, HashMap<String, String> nsURIMapping, SubMonitor subMonitor) {
        subMonitor.subTask("Configuring ResourceSet");
        subMonitor.newChild(1);
        String fileExtension = modelURI.fileExtension();
        XMLURIHandler handler = new XMLURIHandler(modelURI.query(), fileExtension);
        handler.setResourceSet(rs);
        rs.getLoadOptions().put("URI_HANDLER", handler);
        MelangeURIConverter converter = new MelangeURIConverter(nsURIMapping);
        rs.setURIConverter((URIConverter)converter);
        converter.getURIHandlers().add(0, (Object)new DebugURIHandler((EList<URIHandler>)converter.getURIHandlers()));
    }

    protected static HashMap<String, String> getnsURIMapping(IExecutionContext<?, ?, ?> context) {
        HashMap<String, String> nsURIMapping = new HashMap<String, String>();
        String langQuery = "lang=";
        String melangeQuery = context.getRunConfiguration().getExecutedModelAsMelangeURI().query();
        if (melangeQuery != null && !melangeQuery.isEmpty() && melangeQuery.contains("lang=")) {
            String targetLanguage = melangeQuery.substring(melangeQuery.indexOf("lang=") + "lang=".length());
            if (targetLanguage.contains("&")) {
                targetLanguage = targetLanguage.substring(0, targetLanguage.indexOf("&"));
            }
            String targetLanguageNsURI = MelangeRegistry.INSTANCE.getLanguageByIdentifier(targetLanguage).getUri();
            Object o = EMFResource.getFirstContent((URI)context.getRunConfiguration().getExecutedModelURI());
            if (o instanceof EObject) {
                EPackage rootPackage = ((EObject)o).eClass().getEPackage();
                while (rootPackage.getESuperPackage() != null) {
                    rootPackage = rootPackage.getESuperPackage();
                }
                nsURIMapping.put(rootPackage.getNsURI(), targetLanguageNsURI);
            }
        }
        return nsURIMapping;
    }

    private static class MelangeURIConverter
    extends ExtensibleURIConverterImpl {
        private HashMap<String, String> _nsURIMapping;

        MelangeURIConverter(HashMap<String, String> nsURIMapping) {
            this._nsURIMapping = nsURIMapping;
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            StringInputStream result = null;
            if (uri.fileExtension() == null || !uri.fileExtension().equals("aird")) {
                return super.createInputStream(uri, options);
            }
            try (InputStream originalInputStream = null;){
                String originalContent;
                originalInputStream = super.createInputStream(uri, options);
                String modifiedContent = originalContent = MelangeURIConverter.convertStreamToString(originalInputStream);
                for (Map.Entry<String, String> entry : this._nsURIMapping.entrySet()) {
                    modifiedContent = modifiedContent.replace(entry.getKey(), entry.getValue());
                }
                StringInputStream stringInputStream = result = new StringInputStream(modifiedContent);
                return stringInputStream;
            }
        }

        private static String convertStreamToString(InputStream is) {
            Scanner s1 = new Scanner(is);
            Scanner s2 = s1.useDelimiter("\\A");
            String result = s2.hasNext() ? s2.next() : "";
            s1.close();
            s2.close();
            return result;
        }
    }

    private static class XMLURIHandler
    extends XtextPlatformResourceURIHandler {
        private String _queryParameters;
        private String _fileExtension;

        XMLURIHandler(String queryParameters, String fileExtension) {
            this._queryParameters = queryParameters;
            this._queryParameters = this._queryParameters == null ? "" : "?" + this._queryParameters;
            this._fileExtension = fileExtension;
        }

        public URI resolve(URI uri) {
            URI resolvedURI = super.resolve(uri);
            if (!this._queryParameters.isEmpty() && resolvedURI.scheme() != null && !resolvedURI.scheme().equals("melange") && resolvedURI.fileExtension() != null && resolvedURI.fileExtension().equals(this._fileExtension)) {
                String fileExtensionWithPoint = "." + this._fileExtension;
                int lastIndexOfFileExtension = resolvedURI.toString().lastIndexOf(fileExtensionWithPoint);
                String part1 = resolvedURI.toString().substring(0, lastIndexOfFileExtension);
                part1 = part1.replaceFirst("platform:/", "melange:/");
                String part2 = String.valueOf(fileExtensionWithPoint) + this._queryParameters;
                String part3 = resolvedURI.toString().substring(lastIndexOfFileExtension + fileExtensionWithPoint.length());
                String newURIAsString = String.valueOf(part1) + part2 + part3;
                return URI.createURI((String)newURIAsString);
            }
            return resolvedURI;
        }
    }
}

