/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jdom2.Element;
import org.osgi.framework.BundleException;

public class GemocLanguageDesignerBuilder
extends IncrementalProjectBuilder {
    private Set<String> setAspectsWithRTDs = null;
    Multimap<String, String> mapAspectProperties = null;
    public static final String BUILDER_ID = "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.gemocLanguageDesignerBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    public void checkConsistency(IResource resource) {
    }

    private void updateProjectPluginConfiguration(IResource resource) {
        if (resource instanceof IFile && resource.getFileExtension().equals("dsl")) {
            IFile file = (IFile)resource;
            IProject project = file.getProject();
            if (file.exists()) {
                URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                ResourceSetImpl rs = new ResourceSetImpl();
                Resource res = rs.getResource(uri, true);
                Dsl root = (Dsl)res.getContents().get(0);
                String packageName = root.getName();
                ManifestChanger manifestChanger = new ManifestChanger(project);
                String languageName = "null";
                String eclFileName = "null";
                for (Entry anEntry : root.getEntries()) {
                    if (anEntry.getKey().compareTo("name") == 0) {
                        languageName = anEntry.getValue();
                        try {
                            this.setPluginLanguageNameAndFilePath(project, file, languageName);
                            this.updateCodeExecutorClass(project, languageName, manifestChanger);
                            this.updateModelLoaderClass(project, languageName, null);
                            this.updateSolverClass(project, languageName, null);
                        }
                        catch (IOException | CoreException | BundleException e) {
                            e.printStackTrace();
                        }
                    }
                    if (anEntry.getKey().compareTo("ecl") == 0) {
                        eclFileName = anEntry.getValue();
                        this.updateQVTO(project, languageName, eclFileName, null);
                    }
                    if (anEntry.getKey().compareTo("k3") != 0) continue;
                    try {
                        this.createLanguageSpecificDSAHelper(anEntry.getValue(), project, languageName, manifestChanger);
                        this.createLanguageSpecificModelStateHelper(anEntry.getValue(), project, languageName, manifestChanger);
                    }
                    catch (IOException | ClassNotFoundException | CoreException | BundleException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    manifestChanger.addPluginDependency("org.eclipse.gemoc.executionframework.extensions.sirius");
                    manifestChanger.addPluginDependency("org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate");
                    manifestChanger.commit();
                }
                catch (IOException | CoreException | BundleException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void createLanguageSpecificModelStateHelper(String value, IProject project, String fullLanguageName, ManifestChanger manifestChanger) {
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = GemocLanguageDesignerBuilder.getLanguageNameWithFirstUpper(languageName);
        String packageName = GemocLanguageDesignerBuilder.getPackageName(languageName);
        String folderName = GemocLanguageDesignerBuilder.getFolderName(languageName);
        String fileContent = "/* GENERATED FILE, do not modify manually                                                    *\n * If you need to modify it, copy it first */\npackage ${package.name};\nimport java.io.Serializable;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.InvocationTargetException;\nimport org.eclipse.emf.common.util.TreeIterator;\nimport org.eclipse.emf.ecore.EObject;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.ElementState;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelState;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelStateFactory;\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.helper.IK3ModelStateHelper;import org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;\n${extraImports}\n\npublic class ${language.name.toupperfirst}ModelStateHelper implements IK3ModelStateHelper{\n\tprivate static class AttributeNameToValue implements Serializable{\n\n\t\tprivate static final long serialVersionUID = 0;\t\tString name;\n\t\tObject value;\n\t\tpublic AttributeNameToValue(String n, Object v) {\n\t\t\tname = n;\n\t\t\tvalue = v;\n\t\t}\n\n\n\t\t@Override\n\t\tpublic boolean equals(Object obj) {\n\t\t\tif (! (obj instanceof AttributeNameToValue)) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tAttributeNameToValue a2n = (AttributeNameToValue)obj;\n\t\t\tif (this.name.compareTo(a2n.name) != 0) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tif (this.value == null) {\n\t\t\t\treturn a2n.value == null;\n\t\t\t}\n\t\t\tif (!this.value.equals(a2n.value)) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\treturn true;\n\t\t}\t}\n\t\tK3ModelStateFactory theFactory = K3ModelStateFactory.eINSTANCE; \n${saveAndRestoreMethod}\n\n\tpublic void restoreModelState(K3ModelState state) {\n\t\tfor(ElementState elemState : state.getOwnedElementstates()) {\n\t\t\tfor(Object o : elemState.getSavedRTDs()) {\n\t\t\t\tAttributeNameToValue n2v = (AttributeNameToValue)o;\n\t\t\t\ttry {\n\t\t\t\t\tif (n2v.value != null) {\n\t\t\t\t\t\tMethod m = ${language.name.toupperfirst}RTDAccessor.class.getMethod(\"set\"+n2v.name, EObject.class, n2v.value.getClass());\n\t\t\t\t\t\tm.invoke(null, elemState.getModelElement(), n2v.value);\n\t\t\t\t\t}\n\t\t\t\t} catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {\n\t\t\t\t\tMethod m = null;\n\t\t\t\t\tfor(Class<?> c : n2v.value.getClass().getInterfaces()) {\n\t\t\t\t\t\t\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\tm = ${language.name.toupperfirst}RTDAccessor.class.getMethod(\"set\"+n2v.name, EObject.class, n2v.value.getClass().getInterfaces()[0]);\n\t\t\t\t\t\t\tm.invoke(null, elemState.getModelElement(), n2v.value);\n\t\t\t\t\t\t} catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (m == null) {\n\t\t\t\t\t\t\tthrow new RuntimeException(\"not method found for \"+n2v.value.getClass().getName()+\"::set\"+n2v.name);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n};";
        fileContent = fileContent.replaceAll(Pattern.quote("${package.name}"), packageName);
        fileContent = fileContent.replaceAll(Pattern.quote("${language.name.toupperfirst}"), languageToUpperFirst);
        StringBuilder sbContent = new StringBuilder();
        StringBuilder sbExtraImport = new StringBuilder();
        sbContent.append("\tpublic K3ModelState getK3ModelState(EObject model) {\n\t\tK3ModelState res = theFactory.createK3ModelState();\n\n\t\tTreeIterator<EObject> allContentIt = model.eAllContents();\n\t\twhile (allContentIt.hasNext()) {\n\t\t\tEObject elem = allContentIt.next();\n\n");
        sbContent.append("\t\t\tClass<?> clazz =null;\n");
        for (String aspect : this.setAspectsWithRTDs) {
            sbContent.append("\t\t\tclazz = K3DslHelper.getTarget(" + aspect + ".class);\n" + "\t\t\tif (clazz.isInstance(elem)) {\n" + "\t\t\t\tElementState elemState = theFactory.createElementState();\n" + "\t\t\t\telemState.setModelElement(elem);\n" + "\t\t\t\tres.getOwnedElementstates().add(elemState);\n");
            int i = 0;
            for (String property : this.mapAspectProperties.get((Object)aspect)) {
                sbContent.append("\t\t\t\tAttributeNameToValue n2v" + i + " = new AttributeNameToValue(\"" + property + "\", " + languageToUpperFirst + "RTDAccessor.get" + property + "(elem));\n" + "\t\t\t\telemState.getSavedRTDs().add(n2v" + i + ");\n");
                ++i;
            }
            sbContent.append("\t\t\t}\n");
        }
        sbContent.append("\t\t}\n\t\treturn res;\n\t\t}");
        fileContent = fileContent.replaceAll(Pattern.quote("${saveAndRestoreMethod}"), sbContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${extraImports}"), sbExtraImport.toString());
        IFile file = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "ModelStateHelper" + ".java");
        GemocLanguageDesignerBuilder.writeFile(file, fileContent);
    }

    protected void createLanguageSpecificDSAHelper(String allAspects, IProject project, String fullLanguageName, ManifestChanger manifestChanger) throws CoreException, BundleException, IOException, ClassNotFoundException {
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = GemocLanguageDesignerBuilder.getLanguageNameWithFirstUpper(languageName);
        String packageName = GemocLanguageDesignerBuilder.getPackageName(languageName);
        String folderName = GemocLanguageDesignerBuilder.getFolderName(languageName);
        String fileContent = "/* GENERATED FILE, do not modify manually                                                    *\n * If you need to modify it, copy it first */\npackage ${package.name};\nimport org.eclipse.emf.ecore.EObject;\nimport java.lang.reflect.InvocationTargetException;\nimport java.util.List;\nimport java.lang.reflect.Method;\nimport org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;\n${extraImports}\n\npublic class ${language.name.toupperfirst}RTDAccessor {\n${allGettersAndSetters}\npublic static Object getAspectProperty(EObject eObject, String languageName, String aspectName, String propertyName) {\n\t\t\tList<Class<?>> aspects = K3DslHelper.getAspectsOn(languageName, eObject.getClass());\n\t\t\tClass<?> aspect = null;\n\t\t\tfor (Class<?> a : aspects) {\n\t\t\t\ttry {\n\t\t\t\t\tif (Class.forName(aspectName).isAssignableFrom(a)) {\n\t\t\t\t\t\taspect = a;\n\t\t\t\t\t}\n\t\t\t\t} catch (ClassNotFoundException e) {\n\t\t\t\t\te.printStackTrace();\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (aspect == null) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tObject res = null;\n\t\t\t try {\n\t\t\t\tres = aspect.getDeclaredMethod(propertyName, ((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).className()).invoke(eObject, eObject);\n\t\t\t\tif (res != null) {\n\t\t\t\treturn res;\n\t\t\t\t}else {\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException\n\t\t\t\t\t| NoSuchMethodException | SecurityException e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t\t\n\t\t\t return null;\n\t\t}\n\t\n\t\n\tpublic static boolean setAspectProperty(EObject eObject, String languageName, String aspectName, String propertyName, Object newValue) {\n\t\tList<Class<?>> aspects = K3DslHelper.getAspectsOn(languageName, eObject.getClass());\n\t\tClass<?> aspect = null;\n\t\tfor (Class<?> a : aspects) {\n\t\t\ttry {\n\t\t\t\tif (Class.forName(aspectName).isAssignableFrom(a)) {\n\t\t\t\t\taspect = a;\n\t\t\t\t}\n\t\t\t} catch (ClassNotFoundException e) {\n\t\t\t\te.printStackTrace();\n\t\t\t\treturn false;\n\t\t\t}\n\t\t}\n\t\tif (aspect == null) {\n\t\t\treturn false;\n\t\t}\n\t\t\t try {\n\t\t\t\t aspect.getMethod(propertyName, ((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).className(), newValue.getClass()).invoke(eObject, eObject, newValue);\n\t\t\t\treturn true;\n\t\t\t\t} catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {\n\t\t\t\t\tMethod m = null;\n\t\t\t\t\tfor(Class<?> c : ((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).getClass().getInterfaces()) {\n\t\t\t\t\t\t\n\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\taspect.getMethod(propertyName, c, newValue.getClass()).invoke(eObject, eObject, newValue);\n\t\t\t\t\t\t\treturn true;\n\t\t\t\t\t\t} catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (m == null) {\n\t\t\t\t\t\t\tthrow new RuntimeException(\"not method found for \"+((fr.inria.diverse.k3.al.annotationprocessor.Aspect)aspect.getAnnotations()[0]).className()+\"::set\"+propertyName);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\treturn false;\n\t}\n};";
        fileContent = fileContent.replaceAll(Pattern.quote("${package.name}"), packageName);
        fileContent = fileContent.replaceAll(Pattern.quote("${language.name.toupperfirst}"), languageToUpperFirst);
        StringBuilder sbContent = new StringBuilder();
        StringBuilder sbExtraImport = new StringBuilder();
        this.setAspectsWithRTDs = new HashSet<String>();
        this.mapAspectProperties = ArrayListMultimap.create();
        String[] stringArray = allAspects.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleName;
            char[][] qualifications;
            String a;
            String originalAspectClassName = a = stringArray[n2];
            int dot = a.lastIndexOf(46);
            a = String.valueOf(a) + a.substring(dot + 1) + "Properties";
            if (dot != -1) {
                qualifications = new char[][]{a.substring(0, dot).toCharArray()};
                simpleName = a.substring(dot + 1);
            } else {
                qualifications = null;
                simpleName = a;
            }
            char[][] typeNames = new char[][]{simpleName.toCharArray()};
            IType aspectIType = GemocLanguageDesignerBuilder.findAnyTypeInWorkspace(qualifications, typeNames);
            if (aspectIType == null) {
                System.err.println("type \"" + simpleName + "\" not found");
            } else {
                IJavaProject aspectProject = aspectIType.getJavaProject();
                String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)aspectProject);
                ArrayList<URL> urlList = new ArrayList<URL>();
                int i = 0;
                while (i < classPathEntries.length) {
                    String entry = classPathEntries[i];
                    Path path = new Path(entry);
                    URL url = path.toFile().toURI().toURL();
                    urlList.add(url);
                    ++i;
                }
                ClassLoader parentClassLoader = aspectProject.getClass().getClassLoader();
                URL[] urls = urlList.toArray(new URL[urlList.size()]);
                URLClassLoader classLoader = new URLClassLoader(urls, parentClassLoader);
                Class<?> aspectClass = classLoader.loadClass(aspectIType.getFullyQualifiedName());
                IJavaElement[] allChildren = aspectIType.getChildren();
                int i2 = 0;
                while (i2 < allChildren.length) {
                    IJavaElement javaElem = allChildren[i2];
                    if (javaElem instanceof SourceField) {
                        this.setAspectsWithRTDs.add(originalAspectClassName);
                        SourceField f = (SourceField)javaElem;
                        this.mapAspectProperties.put((Object)originalAspectClassName, (Object)f.getElementName());
                        try {
                            String fieldName = f.getElementName();
                            Class<?> fieldType = aspectClass.getField(fieldName).getType();
                            String fieldTypeName = fieldType.getTypeName();
                            sbContent.append("  public static " + fieldTypeName + " get" + f.getElementName() + "(EObject eObject) {\n" + "\t\treturn (" + fieldTypeName + ")  getAspectProperty(eObject, \"" + fullLanguageName + "\", \"" + originalAspectClassName + "\", \"" + f.getElementName() + "\");\n" + "\t}\n");
                            sbContent.append("\tpublic static boolean set" + f.getElementName() + "(EObject eObject, " + fieldTypeName + " newValue) {\n" + "\t\treturn setAspectProperty(eObject, \"" + fullLanguageName + "\", \"" + originalAspectClassName + "\", \"" + f.getElementName() + "\", newValue);\n" + "\t}\n");
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i2;
                }
                classLoader.close();
            }
            ++n2;
        }
        fileContent = fileContent.replaceAll(Pattern.quote("${allGettersAndSetters}"), sbContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${extraImports}"), sbExtraImport.toString());
        IFile file = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "RTDAccessor" + ".java");
        GemocLanguageDesignerBuilder.writeFile(file, fileContent);
        IFile AspectsFile = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "RTDAspects" + ".list");
        StringBuilder sbAspects = new StringBuilder();
        this.setAspectsWithRTDs.stream().forEachOrdered(s -> {
            StringBuilder stringBuilder2 = sbAspects.append(String.valueOf(s) + "\n");
        });
        GemocLanguageDesignerBuilder.writeFile(AspectsFile, sbAspects.toString());
        manifestChanger.addExportPackage(packageName);
    }

    private static IType findAnyTypeInWorkspace(char[][] qualifications, char[][] typeNames) throws JavaModelException {
        class ResultException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IType fType;

            public ResultException(IType type) {
                this.fType = type;
            }
        }
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                throw new ResultException(match.getType());
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(qualifications, typeNames, SearchEngine.createWorkspaceScope(), requestor, 3, null);
        }
        catch (ResultException e) {
            return e.fType;
        }
        return null;
    }

    protected void updateCodeExecutorClass(IProject project, String fullLanguageName, ManifestChanger manifestChanger) throws BundleException, IOException, CoreException {
        int lastDot = fullLanguageName.lastIndexOf(".");
        if (lastDot == -1) {
            lastDot = 0;
        }
        String languageName = fullLanguageName.substring(lastDot + 1);
        String languageToUpperFirst = GemocLanguageDesignerBuilder.getLanguageNameWithFirstUpper(languageName);
        String packageName = GemocLanguageDesignerBuilder.getPackageName(languageName);
        String folderName = GemocLanguageDesignerBuilder.getFolderName(languageName);
        String fileContent = "/* GENERATED FILE, do not modify manually                                                    *\n * If you need to modify it, disable the generation in the BuildOptions of the project.xdsml */\npackage ${package.name};\nimport org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.CodeExecutorDispatcher;\npublic class ${language.name.toupperfirst}CodeExecutor extends CodeExecutorDispatcher ${implements.content} {\n\tpublic ${language.name.toupperfirst}CodeExecutor(){\n\t    ${constructor.content}\n\t}\n\tpublic String getDSAProjectName(){\n\t\t//TODO please implement\n\t\treturn \"\";\n\t}\n   ${additional.operations}\n}";
        fileContent = fileContent.replaceAll(Pattern.quote("${package.name}"), packageName);
        fileContent = fileContent.replaceAll(Pattern.quote("${language.name.toupperfirst}"), languageToUpperFirst);
        StringBuilder sbContent = new StringBuilder();
        StringBuilder sbImplementContent = new StringBuilder();
        StringBuilder sbAdditionalOperations = new StringBuilder();
        sbContent.append("// add Melange or K3 DSA specific executors\n");
        sbContent.append("\t\taddExecutor(new org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.impl.K3DSLCodeExecutor(this,\n");
        sbContent.append("\t\t\t\"" + fullLanguageName + "\"));\n");
        sbImplementContent.append("\n\t\timplements org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.api.IK3DSAExecutorClassLoader ");
        sbAdditionalOperations.append("@Override\n\tpublic Class<?> getClassForName(String className) throws ClassNotFoundException {\n\t\treturn Class.forName(className);\n\t}\n\t@Override\n\tpublic java.io.InputStream getResourceAsStream(String resourceName) {\n\t\t//this.getClass().getResourceAsStream(resourceName);\n\t\treturn Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);\n\t}");
        sbContent.append("\t\t// fall back executor : search classic java method\n");
        sbContent.append("\t\taddExecutor(new org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.JavaCodeExecutor());");
        fileContent = fileContent.replaceAll(Pattern.quote("${constructor.content}"), sbContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${implements.content}"), sbImplementContent.toString());
        fileContent = fileContent.replaceAll(Pattern.quote("${additional.operations}"), sbAdditionalOperations.toString());
        IFile file = project.getFile("xdsml-java-gen/" + folderName + "/" + languageToUpperFirst + "CodeExecutor" + ".java");
        GemocLanguageDesignerBuilder.writeFile(file, fileContent);
        this.setPluginCodeExecutorValue(project, String.valueOf(packageName) + "." + languageToUpperFirst + "CodeExecutor");
        manifestChanger.addExportPackage(packageName);
    }

    protected void setPluginCodeExecutorValue(IProject project, String value) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.concurrent.xdsml");
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "codeExecutor_class", value);
        helper.saveDocument(pluginfile);
    }

    protected void setPluginLanguageNameAndFilePath(IProject project, IFile melangeFile, String languageName) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.concurrent.xdsml");
        helper.updateXDSMLDefinitionInExtensionPoint(gemocExtensionPoint, languageName);
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "xdsmlFilePath", String.valueOf(project.getFullPath().toString()) + "/" + melangeFile.getProjectRelativePath());
        helper.saveDocument(pluginfile);
    }

    protected void updateDependenciesWithProject(ManifestChanger connection, String projectName) throws BundleException, IOException, CoreException {
        connection.addPluginDependency(projectName);
    }

    protected void updateModelLoaderClass(IProject project, String languageName, String modelLoaderClass) {
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.concurrent.xdsml");
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "modelLoader_class", modelLoaderClass != null ? modelLoaderClass : "org.eclipse.gemoc.executionframework.extensions.sirius.modelloader.DefaultModelLoader");
        helper.saveDocument(pluginfile);
    }

    public static String getLanguageNameWithFirstUpper(String languageDefinitionName) {
        return String.valueOf(languageDefinitionName.substring(0, 1).toUpperCase()) + languageDefinitionName.substring(1);
    }

    public static String getPackageName(String languageDefinitionName) {
        return String.valueOf(languageDefinitionName.toLowerCase()) + ".xdsml.api.impl";
    }

    public static String getFolderName(String languageDefinitionName) {
        return GemocLanguageDesignerBuilder.getPackageName(languageDefinitionName).replaceAll("\\.", "/");
    }

    public static void writeFile(IFile file, String fileContent) {
        try {
            IFileUtils.writeInFile((IFile)file, (String)fileContent, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException | CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    protected void updateSolverClass(IProject project, String languageName, String solverClassName) {
        String computedSolverClassName = "";
        computedSolverClassName = solverClassName == null || solverClassName.isEmpty() ? "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare.moc.impl.CcslSolver" : solverClassName;
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.concurrent.xdsml");
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "solver_class", computedSolverClassName);
        helper.saveDocument(pluginfile);
    }

    protected void updateQVTO(IProject project, String languageName, String eclFileLocationUri, String qvtoFileLocationUri) {
        String computedQVTOLocationURI = "";
        if (qvtoFileLocationUri == null || qvtoFileLocationUri.isEmpty()) {
            int endProjectIndex;
            if (eclFileLocationUri.startsWith("/")) {
                eclFileLocationUri = eclFileLocationUri.substring(1);
            }
            if ((endProjectIndex = eclFileLocationUri.indexOf("/")) != -1) {
                String eclProject = eclFileLocationUri.substring(0, endProjectIndex);
                IProject dseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(eclProject);
                IFolder qvtoFolder = dseProject.getFolder("qvto-gen/modeling");
                if (qvtoFolder != null) {
                    FileFinderVisitor fileFinder = new FileFinderVisitor("qvto");
                    try {
                        qvtoFolder.accept((IResourceVisitor)fileFinder);
                        IFile qvtoFile = fileFinder.getFile();
                        if (qvtoFile != null) {
                            computedQVTOLocationURI = qvtoFile.getFullPath().toString();
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        } else {
            computedQVTOLocationURI = qvtoFileLocationUri;
        }
        IFile pluginfile = project.getFile("plugin.xml");
        PluginXMLHelper.createEmptyTemplateFile((IFile)pluginfile, (boolean)false);
        PluginXMLHelper helper = new PluginXMLHelper();
        helper.loadDocument(pluginfile);
        Element gemocExtensionPoint = helper.getOrCreateExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.concurrent.xdsml");
        helper.updateXDSMLDefinitionAttributeInExtensionPoint(gemocExtensionPoint, "toCCSLQVTOFilePath", computedQVTOLocationURI);
        helper.saveDocument(pluginfile);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new LanguageProjectResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new LanguageProjectDeltaVisitor());
    }

    class LanguageProjectDeltaVisitor
    implements IResourceDeltaVisitor {
        LanguageProjectDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    GemocLanguageDesignerBuilder.this.updateProjectPluginConfiguration(resource);
                    GemocLanguageDesignerBuilder.this.checkConsistency(resource);
                    break;
                }
                case 2: {
                    GemocLanguageDesignerBuilder.this.updateProjectPluginConfiguration(resource);
                    GemocLanguageDesignerBuilder.this.checkConsistency(resource);
                    break;
                }
                case 4: {
                    GemocLanguageDesignerBuilder.this.updateProjectPluginConfiguration(resource);
                    GemocLanguageDesignerBuilder.this.checkConsistency(resource);
                }
            }
            return true;
        }
    }

    class LanguageProjectResourceVisitor
    implements IResourceVisitor {
        LanguageProjectResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            GemocLanguageDesignerBuilder.this.updateProjectPluginConfiguration(resource);
            GemocLanguageDesignerBuilder.this.checkConsistency(resource);
            return true;
        }
    }
}

