package org.eclipse.gemoc.ui.highlighting;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.ui.highlighting.DslHighlightingConfiguration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.DefaultSemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

@SuppressWarnings("all")
public class DslHighlightingCalculator extends DefaultSemanticHighlightingCalculator {
  @Override
  public void provideHighlightingFor(final XtextResource resource, final IHighlightedPositionAcceptor acceptor, final CancelIndicator cancelIndicator) {
    final INode root = resource.getParseResult().getRootNode();
    BidiTreeIterable<INode> _asTreeIterable = root.getAsTreeIterable();
    for (final INode node : _asTreeIterable) {
      {
        final EObject grammarElement = node.getGrammarElement();
        if ((grammarElement instanceof RuleCall)) {
          RuleCall rc = ((RuleCall) grammarElement);
          AbstractRule r = rc.getRule();
          final EObject c = ((RuleCall)grammarElement).eContainer();
          final EObject ccc = c.eContainer().eContainer();
          boolean _equals = r.getName().equals("WORD");
          if (_equals) {
            if ((c instanceof Assignment)) {
              String _feature = ((Assignment)c).getFeature();
              boolean _equals_1 = Objects.equal(_feature, "key");
              if (_equals_1) {
                acceptor.addPosition(node.getOffset(), node.getLength(), 
                  DslHighlightingConfiguration.KEY_ID);
              }
            }
          } else {
            String _name = r.getName();
            boolean _equals_2 = Objects.equal(_name, "VALUE_WORD");
            if (_equals_2) {
              acceptor.addPosition(node.getOffset(), node.getLength(), DslHighlightingConfiguration.VALUE_ID);
            } else {
              String _name_1 = r.getName();
              boolean _equals_3 = Objects.equal(_name_1, "SEPARATOR");
              if (_equals_3) {
                if ((ccc instanceof ParserRule)) {
                  String _name_2 = ((ParserRule)ccc).getName();
                  boolean _notEquals = (!Objects.equal(_name_2, "VALUE_WORD"));
                  if (_notEquals) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), 
                      DslHighlightingConfiguration.SEPARATOR_ID);
                  }
                }
              }
            }
          }
        } else {
          if ((grammarElement instanceof Keyword)) {
            String _value = ((Keyword)grammarElement).getValue();
            boolean _equals_4 = Objects.equal(_value, "\\");
            if (_equals_4) {
              acceptor.addPosition(node.getOffset(), node.getLength(), 
                DslHighlightingConfiguration.LINESEPARATOR_ID);
            }
          }
        }
      }
    }
  }
}
