/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.manager;

import fr.inria.aoste.timesquare.backend.codeexecution.Activator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;

public class ProjectClassLoader {
    private HashMap<IJavaProject, URLClassLoader> projectClassLoaderCache = new HashMap();
    private HashMap<IJavaProject, ArrayList<URL>> projectClasspathCache = new HashMap();

    public URLClassLoader getProjectClassLoader(IJavaElement javaElement) {
        IJavaProject javaProject = javaElement != null ? javaElement.getJavaProject() : null;
        return this.getProjectClassLoader(javaProject);
    }

    public URLClassLoader getProjectClassLoader(IJavaProject project) {
        try {
            if (project != null) {
                URLClassLoader uRLClassLoader = this.projectClassLoaderCache.get(project);
                if (uRLClassLoader != null) {
                    return uRLClassLoader;
                }
                ArrayList<URL> pathElements = this.getProjectClassPathURLs(project);
                List<Bundle> pluginreq = this.getProjectRequiredPlugins(project);
                URL[] urlPaths = pathElements.toArray(new URL[pathElements.size()]);
                Bundle[] b = pluginreq.toArray(new Bundle[0]);
                uRLClassLoader = AccessController.doPrivileged(new PrivilegedExceptionActionClassLoader(urlPaths, b));
                this.projectClassLoaderCache.put(project, uRLClassLoader);
                return uRLClassLoader;
            }
            URL[] urlPaths = new URL[]{};
            Bundle[] b = new Bundle[]{Activator.getDefault().getBundle()};
            URLClassLoader uRLClassLoader = AccessController.doPrivileged(new PrivilegedExceptionActionClassLoader(urlPaths, b, this.getClass().getClassLoader()));
            return uRLClassLoader;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static URL getRawLocationURL(IPath simplePath) throws MalformedURLException {
        File file = ProjectClassLoader.getRawLocationFile(simplePath);
        return file.toURI().toURL();
    }

    private static File getRawLocationFile(IPath simplePath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath);
        File file = null;
        file = resource != null ? ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath).getRawLocation().toFile() : simplePath.toFile();
        return file;
    }

    private List<Bundle> getProjectRequiredPlugins(IJavaProject project) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try {
            BundleSpecification[] requiredBundles;
            IPluginModelBase model = PluginRegistry.findModel((IProject)project.getProject());
            if (model == null) {
                return bundles;
            }
            BundleDescription desc = model.getBundleDescription();
            if (desc == null) {
                return bundles;
            }
            BundleSpecification[] bundleSpecificationArray = requiredBundles = desc.getRequiredBundles();
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification required = bundleSpecificationArray[n2];
                try {
                    String s = required.getName();
                    Bundle b = Platform.getBundle((String)s);
                    if (b != null) {
                        bundles.add(b);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bundles;
    }

    private ArrayList<URL> getProjectClassPathURLs(IJavaProject project) {
        ArrayList<URL> pathElements = null;
        pathElements = this.projectClasspathCache.get(project);
        if (pathElements != null) {
            return pathElements;
        }
        pathElements = new ArrayList();
        this.projectClasspathCache.put(project, pathElements);
        try {
            IClasspathEntry[] paths = project.getResolvedClasspath(true);
            HashSet<IPath> outputPaths = new HashSet<IPath>();
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    IClasspathEntry path = paths[i];
                    if (path.getEntryKind() == 1) {
                        URL url = ProjectClassLoader.getRawLocationURL(path.getPath());
                        pathElements.add(url);
                    } else if (path.getEntryKind() == 3) {
                        IPath output = path.getOutputLocation();
                        if (path.getOutputLocation() != null) {
                            outputPaths.add(output);
                        }
                    }
                    ++i;
                }
            }
            IPath location = this.getProjectLocation(project.getProject());
            IPath outputPath = location.append(project.getOutputLocation().removeFirstSegments(1));
            pathElements.add(0, outputPath.toFile().toURI().toURL());
            for (IPath path : outputPaths) {
                outputPath = location.append(path.removeFirstSegments(1));
                pathElements.add(0, outputPath.toFile().toURI().toURL());
            }
            String[] names = project.getRequiredProjectNames();
            int i = 0;
            while (i < names.length) {
                String projectName = names[i];
                IProject reqProject = project.getProject().getWorkspace().getRoot().getProject(projectName);
                if (reqProject != null) {
                    IJavaProject reqJavaProject = JavaCore.create((IProject)reqProject);
                    pathElements.addAll(this.getProjectClassPathURLs(reqJavaProject));
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return pathElements;
    }

    private IPath getProjectLocation(IProject project) {
        if (project.getRawLocation() == null) {
            return project.getLocation();
        }
        return project.getRawLocation();
    }

    public void clearCaches() {
        this.projectClassLoaderCache.clear();
        this.projectClasspathCache.clear();
    }

    private static final class MyUrlClassLoader
    extends URLClassLoader {
        private Bundle[] tb;

        public MyUrlClassLoader(Bundle[] b, URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.tb = b;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Bundle[] bundleArray = this.tb;
            int n = this.tb.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                try {
                    Class c = b.loadClass(name);
                    if (c != null) {
                        return c;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n2;
            }
            return super.loadClass(name, resolve);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    private static final class PrivilegedExceptionActionClassLoader
    implements PrivilegedExceptionAction<URLClassLoader> {
        private URL[] urlPaths;
        private Bundle[] b;
        private ClassLoader parent = null;

        public PrivilegedExceptionActionClassLoader(URL[] _urlPaths, Bundle[] _b) {
            this.urlPaths = _urlPaths;
            this.b = _b;
            this.parent = null;
        }

        public PrivilegedExceptionActionClassLoader(URL[] _urlPaths, Bundle[] _b, ClassLoader parent) {
            this.urlPaths = _urlPaths;
            this.b = _b;
            this.parent = parent;
        }

        @Override
        public URLClassLoader run() throws Exception {
            return new MyUrlClassLoader(this.b, this.urlPaths, this.parent != null ? this.parent : Thread.currentThread().getContextClassLoader());
        }
    }
}

