/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class ProjectPresentationHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.ui.navigator.resources.nested.changeProjectPresentation";
    private static final String NEST_PARAMETER = String.valueOf(WorkbenchNavigatorPlugin.PLUGIN_ID) + ".nested.enabled";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof CommonNavigator) {
            CommonNavigator navigator = (CommonNavigator)part;
            boolean previousNest = navigator.getNavigatorContentService().getActivationService().isNavigatorExtensionActive("org.eclipse.ui.navigator.resources.nested.nestedProjectContentProvider");
            String newNestParam = event.getParameter(NEST_PARAMETER);
            boolean newNest = false;
            if (newNestParam != null) {
                newNest = Boolean.parseBoolean(newNestParam);
            }
            if (newNest != previousNest) {
                ISelection initialSelection = navigator.getCommonViewer().getSelection();
                INavigatorFilterService filterService = navigator.getNavigatorContentService().getFilterService();
                HashSet<String> filters = new HashSet<String>();
                ICommonFilterDescriptor[] iCommonFilterDescriptorArray = filterService.getVisibleFilterDescriptors();
                int n = iCommonFilterDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommonFilterDescriptor desc = iCommonFilterDescriptorArray[n2];
                    if (filterService.isActive(desc.getId())) {
                        filters.add(desc.getId());
                    }
                    ++n2;
                }
                if (newNest) {
                    navigator.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resources.nested.nestedProjectContentProvider"}, false);
                    filters.add("org.eclipse.ui.navigator.resources.nested.HideTopLevelProjectIfNested");
                    filters.add("org.eclipse.ui.navigator.resources.nested.HideFolderWhenProjectIsShownAsNested");
                } else {
                    navigator.getNavigatorContentService().getActivationService().deactivateExtensions(new String[]{"org.eclipse.ui.navigator.resources.nested.nestedProjectContentProvider"}, false);
                    filters.remove("org.eclipse.ui.navigator.resources.nested.HideTopLevelProjectIfNested");
                    filters.remove("org.eclipse.ui.navigator.resources.nested.HideFolderWhenProjectIsShownAsNested");
                }
                filterService.activateFilterIdsAndUpdateViewer(filters.toArray(new String[filters.size()]));
                navigator.getNavigatorContentService().getActivationService().persistExtensionActivations();
                navigator.getCommonViewer().refresh();
                navigator.getCommonViewer().setSelection(initialSelection);
            }
            HandlerUtil.updateRadioState((Command)event.getCommand(), (String)Boolean.toString(newNest));
            return newNest;
        }
        return false;
    }

    public boolean isEnabled() {
        return true;
    }
}

