/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.ExecutionMetamodelTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class TraceMMGeneratorStates {
  private final OperationalSemanticsView mmext;
  
  private final TraceMMExplorer traceMMExplorer;
  
  private final String languageName;
  
  private final boolean gemoc;
  
  private final EPackage tracemmresult;
  
  private final TraceMMGenerationTraceability traceability;
  
  private final Map<EClass, EClass> runtimeToTraced = new HashMap<EClass, EClass>();
  
  private final Set<EClass> allRuntimeClasses = new HashSet<EClass>();
  
  private final Set<EClass> allStaticClasses = new HashSet<EClass>();
  
  private final Set<EClass> allNewEClasses;
  
  private final Set<EClass> multipleOrig = new HashSet<EClass>();
  
  public TraceMMGeneratorStates(final OperationalSemanticsView mmext, final TraceMMGenerationTraceability traceability, final TraceMMExplorer traceMMExplorer, final String languageName, final EPackage tracemmresult, final boolean gemoc) {
    this.mmext = mmext;
    TreeIterator<EObject> _eAllContents = mmext.eAllContents();
    Set<EObject> _set = IteratorExtensions.<EObject>toSet(_eAllContents);
    Iterable<EClass> _filter = Iterables.<EClass>filter(_set, EClass.class);
    Set<EClass> _set_1 = IterableExtensions.<EClass>toSet(_filter);
    this.allNewEClasses = _set_1;
    this.traceability = traceability;
    this.traceMMExplorer = traceMMExplorer;
    this.languageName = languageName;
    this.tracemmresult = tracemmresult;
    this.gemoc = gemoc;
  }
  
  private void cleanup() {
    TreeIterator<EObject> _eAllContents = this.tracemmresult.eAllContents();
    Iterator<EClass> _filter = Iterators.<EClass>filter(_eAllContents, EClass.class);
    final Set<EClass> allCreatedEClasses = IteratorExtensions.<EClass>toSet(_filter);
    for (final EClass c : allCreatedEClasses) {
      this.cleanupAnnotations(c);
    }
    Collection<EClass> _values = this.runtimeToTraced.values();
    Iterable<EReference> _filter_1 = Iterables.<EReference>filter(_values, EReference.class);
    for (final EReference r : _filter_1) {
      r.setEOpposite(null);
    }
  }
  
  public void process() {
    this.handleTraceClasses();
    this.cleanup();
  }
  
  private void cleanupAnnotations(final EClass eClass) {
    final EAnnotation traceabilityAnnotation = ExecutionMetamodelTraceability.getTraceabilityAnnotation(eClass);
    EList<EAnnotation> _eAnnotations = eClass.getEAnnotations();
    _eAnnotations.clear();
    boolean _notEquals = (!Objects.equal(traceabilityAnnotation, null));
    if (_notEquals) {
      EList<EAnnotation> _eAnnotations_1 = eClass.getEAnnotations();
      _eAnnotations_1.add(traceabilityAnnotation);
    }
  }
  
  private EPackage obtainTracedPackage(final EPackage runtimePackage) {
    EPackage result = this.traceMMExplorer.statesPackage;
    boolean _notEquals = (!Objects.equal(runtimePackage, null));
    if (_notEquals) {
      EPackage _eSuperPackage = runtimePackage.getESuperPackage();
      final EPackage tracedSuperPackage = this.obtainTracedPackage(_eSuperPackage);
      final String tracedPackageName = TraceMMStrings.package_createTracedPackage(runtimePackage);
      EList<EPackage> _eSubpackages = tracedSuperPackage.getESubpackages();
      final Function1<EPackage, Boolean> _function = new Function1<EPackage, Boolean>() {
        @Override
        public Boolean apply(final EPackage p) {
          String _name = p.getName();
          return Boolean.valueOf(_name.equals(tracedPackageName));
        }
      };
      EPackage _findFirst = IterableExtensions.<EPackage>findFirst(_eSubpackages, _function);
      result = _findFirst;
      boolean _equals = Objects.equal(result, null);
      if (_equals) {
        EPackage _createEPackage = EcoreFactory.eINSTANCE.createEPackage();
        result = _createEPackage;
        result.setName(tracedPackageName);
        String _name = result.getName();
        String _plus = ((this.languageName + "_") + _name);
        result.setNsURI(_plus);
        result.setNsPrefix("");
        EList<EPackage> _eSubpackages_1 = tracedSuperPackage.getESubpackages();
        _eSubpackages_1.add(result);
      }
    }
    return result;
  }
  
  private String computeTraceabilityAnnotationValue(final EClass extendedClass) {
    String traceabilityAnnotationValue = null;
    EList<EStructuralFeature> _eStructuralFeatures = extendedClass.getEStructuralFeatures();
    final Function1<EStructuralFeature, Boolean> _function = new Function1<EStructuralFeature, Boolean>() {
      @Override
      public Boolean apply(final EStructuralFeature f) {
        EList<EStructuralFeature> _dynamicProperties = TraceMMGeneratorStates.this.mmext.getDynamicProperties();
        return Boolean.valueOf(_dynamicProperties.contains(f));
      }
    };
    Iterable<EStructuralFeature> _filter = IterableExtensions.<EStructuralFeature>filter(_eStructuralFeatures, _function);
    final Set<EStructuralFeature> dynamicProperties = IterableExtensions.<EStructuralFeature>toSet(_filter);
    boolean _isEmpty = dynamicProperties.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final EStructuralFeature mutableProperty = ((EStructuralFeature[])Conversions.unwrapArray(dynamicProperties, EStructuralFeature.class))[0];
      final String mutablePropertyTraceabilityValue = ExecutionMetamodelTraceability.getTraceabilityAnnotationValue(mutableProperty);
      boolean _notEquals = (!Objects.equal(mutablePropertyTraceabilityValue, null));
      if (_notEquals) {
        final int classSubstringStartIndex = mutablePropertyTraceabilityValue.lastIndexOf("/");
        String _substring = mutablePropertyTraceabilityValue.substring(0, classSubstringStartIndex);
        traceabilityAnnotationValue = _substring;
      }
    }
    return traceabilityAnnotationValue;
  }
  
  private boolean isInPackage(final EPackage c, final EPackage p) {
    if ((((!Objects.equal(c, null)) && (!Objects.equal(p, null))) && Objects.equal(c, p))) {
      return true;
    } else {
      EPackage _eSuperPackage = c.getESuperPackage();
      boolean _notEquals = (!Objects.equal(_eSuperPackage, null));
      if (_notEquals) {
        EPackage _eSuperPackage_1 = c.getESuperPackage();
        return this.isInPackage(_eSuperPackage_1, p);
      } else {
        return false;
      }
    }
  }
  
  private Set<EClass> getSubTypesOf(final EClass c) {
    final HashSet<EClass> result = new HashSet<EClass>();
    EPackage _executionMetamodel = this.mmext.getExecutionMetamodel();
    TreeIterator<EObject> _eAllContents = _executionMetamodel.eAllContents();
    Set<EObject> _set = IteratorExtensions.<EObject>toSet(_eAllContents);
    Iterable<EClass> _filter = Iterables.<EClass>filter(_set, EClass.class);
    for (final EClass someEClass : _filter) {
      EList<EClass> _eSuperTypes = someEClass.getESuperTypes();
      boolean _contains = _eSuperTypes.contains(c);
      if (_contains) {
        result.add(someEClass);
      }
    }
    return result;
  }
  
  private void getAllInheritance(final Set<EClass> result, final EClass c) {
    boolean _contains = result.contains(c);
    boolean _not = (!_contains);
    if (_not) {
      result.add(c);
      EList<EClass> _eSuperTypes = c.getESuperTypes();
      for (final EClass sup : _eSuperTypes) {
        this.getAllInheritance(result, sup);
      }
      Set<EClass> _subTypesOf = this.getSubTypesOf(c);
      for (final EClass sub : _subTypesOf) {
        this.getAllInheritance(result, sub);
      }
    }
  }
  
  private Set<EClass> getAllInheritance(final EClass c) {
    final HashSet<EClass> result = new HashSet<EClass>();
    this.getAllInheritance(result, c);
    return result;
  }
  
  private void handleTraceClasses() {
    EList<EStructuralFeature> _dynamicProperties = this.mmext.getDynamicProperties();
    for (final EStructuralFeature dp : _dynamicProperties) {
      {
        final EClass extendedExistingClass = dp.getEContainingClass();
        this.allRuntimeClasses.add(extendedExistingClass);
        final Set<EClass> allInheritance = this.getAllInheritance(extendedExistingClass);
        this.allRuntimeClasses.addAll(allInheritance);
      }
    }
    final HashMap<EClass, EClass> baseClassToNewEClass = new HashMap<EClass, EClass>();
    for (final EClass c : this.allNewEClasses) {
      EPackage _executionMetamodel = this.mmext.getExecutionMetamodel();
      TreeIterator<EObject> _eAllContents = _executionMetamodel.eAllContents();
      Set<EObject> _set = IteratorExtensions.<EObject>toSet(_eAllContents);
      Iterable<EClass> _filter = Iterables.<EClass>filter(_set, EClass.class);
      final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
        @Override
        public Boolean apply(final EClass cls) {
          String _name = cls.getName();
          String _name_1 = c.getName();
          return Boolean.valueOf(Objects.equal(_name, _name_1));
        }
      };
      EClass _findFirst = IterableExtensions.<EClass>findFirst(_filter, _function);
      baseClassToNewEClass.put(_findFirst, c);
    }
    for (final EClass c_1 : this.allNewEClasses) {
      {
        EPackage _executionMetamodel_1 = this.mmext.getExecutionMetamodel();
        TreeIterator<EObject> _eAllContents_1 = _executionMetamodel_1.eAllContents();
        Set<EObject> _set_1 = IteratorExtensions.<EObject>toSet(_eAllContents_1);
        Iterable<EClass> _filter_1 = Iterables.<EClass>filter(_set_1, EClass.class);
        final Function1<EClass, Boolean> _function_1 = new Function1<EClass, Boolean>() {
          @Override
          public Boolean apply(final EClass cls) {
            String _name = cls.getName();
            String _name_1 = c_1.getName();
            return Boolean.valueOf(Objects.equal(_name, _name_1));
          }
        };
        EClass _findFirst_1 = IterableExtensions.<EClass>findFirst(_filter_1, _function_1);
        final Set<EClass> allInheritance = this.getAllInheritance(_findFirst_1);
        final Function1<EClass, EClass> _function_2 = new Function1<EClass, EClass>() {
          @Override
          public EClass apply(final EClass cls) {
            EClass _xblockexpression = null;
            {
              final EClass newEClass = baseClassToNewEClass.get(cls);
              EClass _xifexpression = null;
              boolean _equals = Objects.equal(newEClass, null);
              if (_equals) {
                _xifexpression = cls;
              } else {
                _xifexpression = newEClass;
              }
              _xblockexpression = _xifexpression;
            }
            return _xblockexpression;
          }
        };
        Iterable<EClass> _map = IterableExtensions.<EClass, EClass>map(allInheritance, _function_2);
        Iterables.<EClass>addAll(this.allRuntimeClasses, _map);
      }
    }
    EPackage _executionMetamodel_1 = this.mmext.getExecutionMetamodel();
    TreeIterator<EObject> _eAllContents_1 = _executionMetamodel_1.eAllContents();
    Set<EObject> _set_1 = IteratorExtensions.<EObject>toSet(_eAllContents_1);
    Iterable<EClass> _filter_1 = Iterables.<EClass>filter(_set_1, EClass.class);
    final Function1<EClass, Boolean> _function_1 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        boolean _contains = TraceMMGeneratorStates.this.allRuntimeClasses.contains(c);
        return Boolean.valueOf((!_contains));
      }
    };
    Iterable<EClass> _filter_2 = IterableExtensions.<EClass>filter(_filter_1, _function_1);
    Iterables.<EClass>addAll(this.allStaticClasses, _filter_2);
    for (final EClass rc : this.allRuntimeClasses) {
      {
        EList<EClass> _eAllSuperTypes = rc.getEAllSuperTypes();
        final Function1<EClass, Boolean> _function_2 = new Function1<EClass, Boolean>() {
          @Override
          public Boolean apply(final EClass c) {
            return Boolean.valueOf(((!c.isAbstract()) && TraceMMGeneratorStates.this.allRuntimeClasses.contains(c)));
          }
        };
        Iterable<EClass> _filter_3 = IterableExtensions.<EClass>filter(_eAllSuperTypes, _function_2);
        final Set<EClass> concreteSuperTypes = IterableExtensions.<EClass>toSet(_filter_3);
        this.multipleOrig.addAll(concreteSuperTypes);
      }
    }
    final ArrayList<EClass> tracedClasses = new ArrayList<EClass>();
    final List<EClass> runtimeClasses = IterableExtensions.<EClass>toList(this.allRuntimeClasses);
    final Function1<EClass, String> _function_2 = new Function1<EClass, String>() {
      @Override
      public String apply(final EClass it) {
        return it.getName();
      }
    };
    final List<EClass> runtimeClassesSorted = IterableExtensions.<EClass, String>sortBy(runtimeClasses, _function_2);
    for (final EClass runtimeClass : runtimeClassesSorted) {
      {
        final EClass tracedClass = this.handleTraceClass(runtimeClass);
        tracedClasses.add(tracedClass);
      }
    }
  }
  
  private EClass handleTraceClass(final EClass runtimeClass) {
    boolean _contains = this.allRuntimeClasses.contains(runtimeClass);
    boolean _not = (!_contains);
    if (_not) {
      return runtimeClass;
    }
    boolean _containsKey = this.runtimeToTraced.containsKey(runtimeClass);
    boolean _not_1 = (!_containsKey);
    if (_not_1) {
      final EClass tracedClass = EcoreFactory.eINSTANCE.createEClass();
      String _class_createTraceClassName = TraceMMStrings.class_createTraceClassName(runtimeClass);
      tracedClass.setName(_class_createTraceClassName);
      tracedClass.setAbstract((runtimeClass.isAbstract() || runtimeClass.isInterface()));
      this.runtimeToTraced.put(runtimeClass, tracedClass);
      this.traceability.putTracedClasses(runtimeClass, tracedClass);
      EList<EClass> _eSuperTypes = runtimeClass.getESuperTypes();
      final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
        @Override
        public Boolean apply(final EClass t) {
          return Boolean.valueOf(TraceMMGeneratorStates.this.allRuntimeClasses.contains(t));
        }
      };
      Iterable<EClass> _filter = IterableExtensions.<EClass>filter(_eSuperTypes, _function);
      for (final EClass superType : _filter) {
        {
          final EClass tracedSuperType = this.handleTraceClass(superType);
          EList<EClass> _eSuperTypes_1 = tracedClass.getESuperTypes();
          _eSuperTypes_1.add(tracedSuperType);
        }
      }
      boolean _contains_1 = this.allNewEClasses.contains(runtimeClass);
      final boolean notNewClass = (!_contains_1);
      boolean _isAbstract = tracedClass.isAbstract();
      final boolean notAbstract = (!_isAbstract);
      EList<EClass> _eSuperTypes_1 = tracedClass.getESuperTypes();
      boolean _isEmpty = _eSuperTypes_1.isEmpty();
      if (_isEmpty) {
        final EGenericType tracedObjectGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
        tracedObjectGenericSuperType.setEClassifier(this.traceMMExplorer.specificTracedObjectClass);
        final EGenericType dimensionClassTracedObjectTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
        EList<EGenericType> _eTypeArguments = tracedObjectGenericSuperType.getETypeArguments();
        _eTypeArguments.add(dimensionClassTracedObjectTypeBinding);
        dimensionClassTracedObjectTypeBinding.setEClassifier(this.traceMMExplorer.specificDimensionClass);
        EList<EGenericType> _eTypeArguments_1 = dimensionClassTracedObjectTypeBinding.getETypeArguments();
        EGenericType _createEGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        _eTypeArguments_1.add(_createEGenericType);
        EList<EGenericType> _eGenericSuperTypes = tracedClass.getEGenericSuperTypes();
        _eGenericSuperTypes.add(tracedObjectGenericSuperType);
      }
      EPackage _ePackage = runtimeClass.getEPackage();
      final EPackage tracedPackage = this.obtainTracedPackage(_ePackage);
      EList<EClassifier> _eClassifiers = tracedPackage.getEClassifiers();
      _eClassifiers.add(tracedClass);
      EList<EStructuralFeature> _eStructuralFeatures = runtimeClass.getEStructuralFeatures();
      final Function1<EStructuralFeature, Boolean> _function_1 = new Function1<EStructuralFeature, Boolean>() {
        @Override
        public Boolean apply(final EStructuralFeature f) {
          EList<EStructuralFeature> _dynamicProperties = TraceMMGeneratorStates.this.mmext.getDynamicProperties();
          return Boolean.valueOf(_dynamicProperties.contains(f));
        }
      };
      final Iterable<EStructuralFeature> dynamicProperties = IterableExtensions.<EStructuralFeature>filter(_eStructuralFeatures, _function_1);
      if ((notNewClass && (!IterableExtensions.isEmpty(dynamicProperties)))) {
        final String traceabilityAnnotationValue = this.computeTraceabilityAnnotationValue(runtimeClass);
        boolean _notEquals = (!Objects.equal(traceabilityAnnotationValue, null));
        if (_notEquals) {
          ExecutionMetamodelTraceability.createTraceabilityAnnotation(tracedClass, traceabilityAnnotationValue);
        }
      }
      EList<EClass> _eAllSuperTypes = runtimeClass.getEAllSuperTypes();
      final Function1<EClass, Boolean> _function_2 = new Function1<EClass, Boolean>() {
        @Override
        public Boolean apply(final EClass c) {
          return Boolean.valueOf(((!TraceMMGeneratorStates.this.allRuntimeClasses.contains(c)) || c.isAbstract()));
        }
      };
      final boolean onlyAbstractSuperTypes = IterableExtensions.<EClass>forall(_eAllSuperTypes, _function_2);
      if (((notNewClass && notAbstract) && onlyAbstractSuperTypes)) {
        String _xifexpression = null;
        boolean _contains_2 = this.multipleOrig.contains(runtimeClass);
        if (_contains_2) {
          _xifexpression = TraceMMStrings.ref_OriginalObject_MultipleInheritance(runtimeClass);
        } else {
          _xifexpression = TraceMMStrings.ref_OriginalObject;
        }
        final String refName = _xifexpression;
        final EReference ref = EcoreCraftingUtil.addReferenceToClass(tracedClass, refName, runtimeClass);
        this.traceability.addRefs_originalObject(tracedClass, ref);
      }
      Set<EStructuralFeature> runtimeProperties = new HashSet<EStructuralFeature>();
      boolean _contains_3 = this.allNewEClasses.contains(runtimeClass);
      if (_contains_3) {
        EList<EStructuralFeature> _eStructuralFeatures_1 = runtimeClass.getEStructuralFeatures();
        runtimeProperties.addAll(_eStructuralFeatures_1);
      } else {
        boolean _isEmpty_1 = IterableExtensions.isEmpty(dynamicProperties);
        boolean _not_2 = (!_isEmpty_1);
        if (_not_2) {
          Iterables.<EStructuralFeature>addAll(runtimeProperties, dynamicProperties);
        }
      }
      boolean _isEmpty_2 = runtimeProperties.isEmpty();
      boolean _not_3 = (!_isEmpty_2);
      if (_not_3) {
        this.traceability.addRuntimeClass(runtimeClass);
      }
      final ArrayList<String> dimensionsGetters = new ArrayList<String>();
      for (final EStructuralFeature runtimeProperty : runtimeProperties) {
        {
          this.traceability.addMutableProperty(runtimeClass, runtimeProperty);
          final EClass valueClass = EcoreFactory.eINSTANCE.createEClass();
          String _class_createStateClassName = TraceMMStrings.class_createStateClassName(runtimeClass, runtimeProperty);
          valueClass.setName(_class_createStateClassName);
          EStructuralFeature _copy = EcoreUtil.<EStructuralFeature>copy(runtimeProperty);
          final EStructuralFeature copiedProperty = ((EStructuralFeature) _copy);
          if ((copiedProperty instanceof EReference)) {
            ((EReference)copiedProperty).setContainment(false);
            ((EReference)copiedProperty).setEOpposite(null);
            EClassifier _eType = runtimeProperty.getEType();
            EClass _handleTraceClass = this.handleTraceClass(((EClass) _eType));
            ((EReference)copiedProperty).setEType(_handleTraceClass);
            ((EReference)copiedProperty).setDerived(false);
            ((EReference)copiedProperty).setChangeable(true);
            ((EReference)copiedProperty).setVolatile(false);
            final EGenericType valueGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
            valueGenericSuperType.setEClassifier(this.traceMMExplorer.specificReferenceValueClass);
            final EGenericType valueTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
            EList<EGenericType> _eTypeArguments_2 = valueGenericSuperType.getETypeArguments();
            _eTypeArguments_2.add(valueTypeBinding);
            EClassifier _eType_1 = ((EReference)copiedProperty).getEType();
            valueTypeBinding.setEClassifier(_eType_1);
            EList<EGenericType> _eGenericSuperTypes_1 = valueClass.getEGenericSuperTypes();
            _eGenericSuperTypes_1.add(valueGenericSuperType);
          } else {
            EList<EClass> _eSuperTypes_2 = valueClass.getESuperTypes();
            _eSuperTypes_2.add(this.traceMMExplorer.specificAttributeValueClass);
          }
          EList<EStructuralFeature> _eStructuralFeatures_2 = valueClass.getEStructuralFeatures();
          _eStructuralFeatures_2.add(copiedProperty);
          EList<EClassifier> _eClassifiers_1 = this.traceMMExplorer.statesPackage.getEClassifiers();
          _eClassifiers_1.add(valueClass);
          this.traceability.putMutablePropertyToValueProperty(runtimeProperty, copiedProperty);
          String _traceabilityAnnotationValue = ExecutionMetamodelTraceability.getTraceabilityAnnotationValue(runtimeProperty);
          ExecutionMetamodelTraceability.createTraceabilityAnnotation(valueClass, _traceabilityAnnotationValue);
          final EClass dimensionClass = EcoreFactory.eINSTANCE.createEClass();
          String _class_createDimensionClassName = TraceMMStrings.class_createDimensionClassName(runtimeClass, runtimeProperty);
          dimensionClass.setName(_class_createDimensionClassName);
          final EGenericType dimensionGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
          dimensionGenericSuperType.setEClassifier(this.traceMMExplorer.specificDimensionClass);
          final EGenericType dimensionTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
          EList<EGenericType> _eTypeArguments_3 = dimensionGenericSuperType.getETypeArguments();
          _eTypeArguments_3.add(dimensionTypeBinding);
          dimensionTypeBinding.setEClassifier(valueClass);
          EList<EGenericType> _eGenericSuperTypes_2 = dimensionClass.getEGenericSuperTypes();
          _eGenericSuperTypes_2.add(dimensionGenericSuperType);
          EList<EClassifier> _eClassifiers_2 = this.traceMMExplorer.statesPackage.getEClassifiers();
          _eClassifiers_2.add(dimensionClass);
          String _name = dimensionClass.getName();
          String _firstLower = StringExtensions.toFirstLower(_name);
          final EReference dimensionRef = EcoreCraftingUtil.addReferenceToClass(tracedClass, _firstLower, dimensionClass);
          dimensionRef.setContainment(true);
          dimensionRef.setLowerBound(0);
          dimensionRef.setUpperBound(1);
          String _stringGetter = EcoreCraftingUtil.stringGetter(dimensionRef);
          dimensionsGetters.add(_stringGetter);
          this.traceability.putDimensionClass(runtimeProperty, dimensionClass);
          this.traceability.putDimensionRef(runtimeProperty, dimensionRef);
          this.traceability.putValueClass(runtimeProperty, valueClass);
        }
      }
      final EOperation getDimensionsInternal = EcoreFactory.eINSTANCE.createEOperation();
      final EAnnotation getDimensionsAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
      EList<EAnnotation> _eAnnotations = getDimensionsInternal.getEAnnotations();
      _eAnnotations.add(getDimensionsAnnotation);
      getDimensionsInternal.setName("getDimensionsInternal");
      getDimensionsInternal.setLowerBound(0);
      getDimensionsInternal.setUpperBound((-1));
      final EGenericType dimensionGenericSuperType = EcoreFactory.eINSTANCE.createEGenericType();
      dimensionGenericSuperType.setEClassifier(this.traceMMExplorer.specificDimensionClass);
      final EGenericType dimensionTypeBinding = EcoreFactory.eINSTANCE.createEGenericType();
      EList<EGenericType> _eTypeArguments_2 = dimensionGenericSuperType.getETypeArguments();
      _eTypeArguments_2.add(dimensionTypeBinding);
      getDimensionsInternal.setEGenericType(dimensionGenericSuperType);
      getDimensionsAnnotation.setSource(GenModelPackage.eNS_URI);
      EMap<String, String> _details = getDimensionsAnnotation.getDetails();
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("final EList<SpecificDimension<?>> result = new org.eclipse.emf.ecore.util.BasicInternalEList<SpecificDimension<?>>(Object.class);");
      _builder.newLine();
      _builder.append("result.addAll(super.getDimensionsInternal());");
      _builder.newLine();
      {
        for(final String getter : dimensionsGetters) {
          _builder.append("result.add(");
          _builder.append(getter, "");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("return result;");
      _builder.newLine();
      _details.put("body", _builder.toString());
      EList<EOperation> _eOperations = tracedClass.getEOperations();
      _eOperations.add(getDimensionsInternal);
      return tracedClass;
    } else {
      return this.runtimeToTraced.get(runtimeClass);
    }
  }
}
