/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.trace.gemoc.generator.util.PluginProjectHelper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class StandaloneEMFProjectGenerator {
    protected final EPackage ecoreModel;
    protected final String projectName;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected IProject project;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final Set<GenPackage> referencedGenPackages = new HashSet<GenPackage>();
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final Set<EPackage> rootPackages = new HashSet<EPackage>();
    protected GenModel genModel;
    public static final String MODEL_GEN_FOLDER = "model";
    protected IProgressMonitor progressMonitor;
    protected ResourceSet resourceSet;
    protected URI modelGenFolderURI;
    protected String srcFolderPathString;
    protected Resource ecoreModelResource;
    private Set<GenModel> fixedGenModels = new HashSet<GenModel>();

    public void generateModelCode() {
        try {
            IWorkbench _workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow _activeWorkbenchWindow = _workbench.getActiveWorkbenchWindow();
            IRunnableWithProgress _function = new IRunnableWithProgress(){

                public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                    try {
                        StandaloneEMFProjectGenerator.this.generateModelCode(m);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            _activeWorkbenchWindow.run(false, true, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public StandaloneEMFProjectGenerator(String projectName, EPackage p) {
        this.ecoreModel = p;
        this.projectName = projectName;
    }

    public void generateBaseEMFProject(IProgressMonitor m) {
        try {
            GenModel _generateGenModel;
            Resource _createResource;
            String _setupSrcFolder;
            URI _setupModelGenFolder;
            IProject _createPluginProject;
            this.progressMonitor = m;
            ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
            this.resourceSet = _resourceSetImpl;
            this.project = _createPluginProject = PluginProjectHelper.createPluginProject(this.projectName, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"src"})), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IProject[0])), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[0])), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[0])), m);
            this.modelGenFolderURI = _setupModelGenFolder = this.setupModelGenFolder();
            this.srcFolderPathString = _setupSrcFolder = this.setupSrcFolder();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(this.projectName, "");
            _builder.append("/");
            _builder.append(MODEL_GEN_FOLDER, "");
            _builder.append("/");
            String _name = this.ecoreModel.getName();
            _builder.append(_name, "");
            _builder.append(".ecore");
            URI _createPlatformResourceURI = URI.createPlatformResourceURI((String)_builder.toString(), (boolean)true);
            this.ecoreModelResource = _createResource = this.resourceSet.createResource(_createPlatformResourceURI);
            EList _contents = this.ecoreModelResource.getContents();
            _contents.add((Object)this.ecoreModel);
            this.save(this.ecoreModelResource);
            this.ecoreModelResource.unload();
            this.ecoreModelResource.load(null);
            this.ecoreModelResource.unload();
            this.ecoreModelResource.load(null);
            this.checkReferencedPackages(this.ecoreModelResource);
            EList _contents_1 = this.ecoreModelResource.getContents();
            EObject _get = (EObject)_contents_1.get(0);
            this.genModel = _generateGenModel = this.generateGenModel((EPackage)_get, this.modelGenFolderURI);
            EList _contents_2 = this.ecoreModelResource.getContents();
            Iterable _filter = Iterables.filter((Iterable)_contents_2, EPackage.class);
            Set _set = IterableExtensions.toSet((Iterable)_filter);
            this.rootPackages.addAll(_set);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void generateModelCode(IProgressMonitor m) throws Exception {
        this.generateCode(this.progressMonitor);
    }

    private URI setupModelGenFolder() {
        URI _createPlatformResourceURI;
        boolean _not;
        URI modelGenFolderURI = null;
        IFolder modelGenFolder = this.project.getFolder(MODEL_GEN_FOLDER);
        boolean _exists = modelGenFolder.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            try {
                modelGenFolder.create(true, true, null);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The folder '");
                    _builder.append(MODEL_GEN_FOLDER, "");
                    _builder.append("' could not be created.");
                    throw new RuntimeException(_builder.toString(), (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        IPath _fullPath = modelGenFolder.getFullPath();
        String _string = _fullPath.toString();
        modelGenFolderURI = _createPlatformResourceURI = URI.createPlatformResourceURI((String)_string, (boolean)true);
        return modelGenFolderURI;
    }

    private String setupSrcFolder() {
        String _string;
        boolean _not;
        String srcFolderPathString = null;
        IFolder srcFolder = this.project.getFolder("src");
        boolean _exists = srcFolder.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            try {
                srcFolder.create(true, true, null);
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    throw new RuntimeException("The source folder 'src' could not be created.", (Throwable)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        IPath _fullPath = srcFolder.getFullPath();
        srcFolderPathString = _string = _fullPath.toString();
        return srcFolderPathString;
    }

    private void checkReferencedPackages(Resource xmofModelResource) {
        boolean _greaterThan;
        HashSet<URI> missingPackages = new HashSet<URI>();
        Map externalCrossReferences = EcoreUtil.ExternalCrossReferencer.find((Resource)xmofModelResource);
        Set _keySet = externalCrossReferences.keySet();
        for (EObject eObject : _keySet) {
            boolean _eIsProxy = eObject.eIsProxy();
            if (!_eIsProxy) continue;
            URI _uRI = EcoreUtil.getURI((EObject)eObject);
            URI _trimFragment = _uRI.trimFragment();
            missingPackages.add(_trimFragment);
        }
        int _size = missingPackages.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            String _xifexpression = null;
            int _size_1 = missingPackages.size();
            boolean _equals = _size_1 == 1;
            _xifexpression = _equals ? "" : "s";
            String _plus = "Unable to load the following referenced resource" + _xifexpression;
            String _plus_1 = String.valueOf(_plus) + ": ";
            String _string = ((Object)missingPackages).toString();
            String message = String.valueOf(_plus_1) + _string;
            throw new RuntimeException(message);
        }
    }

    protected GenModel generateGenModel(EPackage rootEPackage, URI modelGenFolderURI) {
        Resource genModelResource = this.createGenModel(rootEPackage);
        EList _contents = genModelResource.getContents();
        EObject _get = (EObject)_contents.get(0);
        GenModel genModel = (GenModel)_get;
        this.setInitializeByLoad(genModel);
        this.save(genModelResource);
        return genModel;
    }

    protected Resource createGenModel(EPackage rootEPackage) {
        Resource ecoreModelResource = rootEPackage.eResource();
        URI _uRI = ecoreModelResource.getURI();
        URI _trimFileExtension = _uRI.trimFileExtension();
        URI _appendFileExtension = _trimFileExtension.appendFileExtension("genmodel");
        String _lastSegment = _appendFileExtension.lastSegment();
        String genModelFileName = _lastSegment.toString();
        URI genModelURI = this.modelGenFolderURI.appendSegment(genModelFileName);
        Resource genModelResource = this.resourceSet.createResource(genModelURI);
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        EList _contents = genModelResource.getContents();
        _contents.add((Object)genModel);
        IFolder srcFolder = this.project.getFolder("src");
        IPath _fullPath = srcFolder.getFullPath();
        String _string = _fullPath.toString();
        genModel.setModelDirectory(_string);
        EList _foreignModel = genModel.getForeignModel();
        URI _uRI_1 = ecoreModelResource.getURI();
        String _string_1 = _uRI_1.toString();
        _foreignModel.add((Object)_string_1);
        String _modelName = this.getModelName(genModelURI);
        genModel.setModelName(_modelName);
        String _pluginID = this.getPluginID(genModelURI);
        genModel.setModelPluginID(_pluginID);
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.impl.MinimalEObjectImpl$Container");
        GenJDKLevel _complicanceLevel = this.getComplicanceLevel();
        genModel.setComplianceLevel(_complicanceLevel);
        genModel.setImportOrganizing(true);
        Set<EPackage> _singleton = Collections.singleton(rootEPackage);
        genModel.initialize(_singleton);
        this.setMissingParameterTypes(genModel);
        this.fixUsedGenPackages(genModel);
        return genModelResource;
    }

    private void fixUsedGenPackages(GenModel genModel) {
        boolean _not;
        boolean _contains = this.fixedGenModels.contains(genModel);
        boolean bl = _not = !_contains;
        if (_not) {
            this.fixedGenModels.add(genModel);
            EList _usedGenPackages = genModel.getUsedGenPackages();
            EList _usedGenPackages_1 = genModel.getUsedGenPackages();
            ImmutableList _immutableCopy = ImmutableList.copyOf((Collection)_usedGenPackages_1);
            Functions.Function1<GenPackage, Boolean> _function = new Functions.Function1<GenPackage, Boolean>(){

                public Boolean apply(GenPackage p) {
                    GenModel _genModel = p.getGenModel();
                    return Objects.equal((Object)_genModel, null);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_immutableCopy, (Functions.Function1)_function);
            CollectionExtensions.removeAll((Collection)_usedGenPackages, (Iterable)_filter);
            List<GenPackage> missingGenPackages = this.computeMissingGenPackages(genModel);
            for (GenPackage genPackage : missingGenPackages) {
                GenModel _genModel = genPackage.getGenModel();
                this.fixUsedGenPackages(_genModel);
            }
            this.referencedGenPackages.addAll(missingGenPackages);
            EList _genPackages = genModel.getGenPackages();
            this.referencedGenPackages.addAll((Collection<GenPackage>)_genPackages);
            EList _usedGenPackages_2 = genModel.getUsedGenPackages();
            _usedGenPackages_2.addAll(missingGenPackages);
        }
    }

    protected String getModelName(URI genModelURI) {
        URI _trimFileExtension = genModelURI.trimFileExtension();
        String genModelFileName = _trimFileExtension.lastSegment();
        String _substring = genModelFileName.substring(0, 1);
        String _upperCase = _substring.toUpperCase();
        String _substring_1 = genModelFileName.substring(1);
        String modelName = String.valueOf(_upperCase) + _substring_1;
        return modelName;
    }

    protected String getPluginID(URI uri) {
        String pluginID = "";
        IFolder _folder = this.project.getFolder("META-INF");
        IFile manifestFile = _folder.getFile("MANIFEST.MF");
        try {
            boolean _notEquals;
            InputStream _contents = manifestFile.getContents();
            Manifest manifest = new Manifest(_contents);
            Attributes _mainAttributes = manifest.getMainAttributes();
            String symbolicName = _mainAttributes.getValue("Bundle-SymbolicName");
            boolean bl = _notEquals = !Objects.equal((Object)symbolicName, null);
            if (_notEquals) {
                String _trim;
                int index = symbolicName.indexOf(";");
                if (index > 0) {
                    String _substring;
                    symbolicName = _substring = symbolicName.substring(0, index);
                }
                pluginID = _trim = symbolicName.trim();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                IPath _fullPath = manifestFile.getFullPath();
                String _string = _fullPath.toString();
                String _plus = "Could not find manifest file '" + _string;
                String _plus_1 = String.valueOf(_plus) + "'.";
                throw new RuntimeException(_plus_1, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return pluginID;
    }

    private GenJDKLevel getComplicanceLevel() {
        String complianceLevel = CodeGenUtil.EclipseUtil.getJavaComplianceLevel((IProject)this.project);
        boolean _equals = "1.4".equals(complianceLevel);
        if (_equals) {
            return GenJDKLevel.JDK14_LITERAL;
        }
        boolean _equals_1 = "1.5".equals(complianceLevel);
        if (_equals_1) {
            return GenJDKLevel.JDK50_LITERAL;
        }
        boolean _equals_2 = "1.6".equals(complianceLevel);
        if (_equals_2) {
            return GenJDKLevel.JDK60_LITERAL;
        }
        boolean _equals_3 = "1.7".equals(complianceLevel);
        if (_equals_3) {
            return GenJDKLevel.JDK70_LITERAL;
        }
        return GenJDKLevel.JDK80_LITERAL;
    }

    private void setMissingParameterTypes(GenModel genModel) {
        TreeIterator _eAllContents = genModel.eAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, GenParameter.class);
        Set _set = IteratorExtensions.toSet((Iterator)_filter);
        for (GenParameter genModelElement : _set) {
            GenParameter genParameter = genModelElement;
            EParameter ecoreParameter = genParameter.getEcoreParameter();
            EClassifier _eType = ecoreParameter.getEType();
            boolean _equals = Objects.equal((Object)_eType, null);
            if (!_equals) continue;
            EClass _eObject = EcorePackage.eINSTANCE.getEObject();
            ecoreParameter.setEType((EClassifier)_eObject);
        }
    }

    protected List<GenPackage> computeMissingGenPackages(GenModel genModel) {
        UniqueEList missingGenPackages = new UniqueEList();
        Map genModelLocationMapTargetEnvironment = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
        Map genModelLocationMapEnvironment = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
        List _missingPackages = genModel.getMissingPackages();
        for (EPackage ePackage : _missingPackages) {
            boolean _equals_1;
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)ePackage, null);
            if (!_notEquals) continue;
            String _nsURI = ePackage.getNsURI();
            URI missingGenModelURI = (URI)genModelLocationMapEnvironment.get(_nsURI);
            boolean _equals = Objects.equal((Object)missingGenModelURI, null);
            if (_equals) {
                URI _get;
                String _nsURI_1 = ePackage.getNsURI();
                missingGenModelURI = _get = (URI)genModelLocationMapTargetEnvironment.get(_nsURI_1);
            }
            if (_equals_1 = Objects.equal((Object)missingGenModelURI, null)) {
                String _nsURI_2 = ePackage.getNsURI();
                String _plus = "Unable to load generator model of required package '" + _nsURI_2;
                String _plus_1 = String.valueOf(_plus) + "'.";
                throw new RuntimeException(_plus_1);
            }
            Resource missingGenModelResource = null;
            try {
                Resource _resource;
                missingGenModelResource = _resource = this.resourceSet.getResource(missingGenModelURI, true);
            }
            catch (Throwable _t) {
                if (_t instanceof RuntimeException) {
                    RuntimeException e = (RuntimeException)_t;
                    String _nsURI_3 = ePackage.getNsURI();
                    String _plus_2 = "Unable to load generator model of required package '" + _nsURI_3;
                    String _plus_3 = String.valueOf(_plus_2) + "'.";
                    throw new RuntimeException(_plus_3);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            EList _contents = missingGenModelResource.getContents();
            EObject _get_1 = (EObject)_contents.get(0);
            GenModel missingGenModel = (GenModel)_get_1;
            EList _genPackages = missingGenModel.getGenPackages();
            missingGenPackages.addAll(_genPackages);
        }
        return missingGenPackages;
    }

    protected void setInitializeByLoad(GenModel genModel) {
        EList _genPackages = genModel.getGenPackages();
        for (GenPackage genPackage : _genPackages) {
            this.setInitializeByLoad(genPackage);
        }
    }

    private void setInitializeByLoad(GenPackage genPackage) {
        genPackage.setLoadInitialization(false);
        List _subGenPackages = genPackage.getSubGenPackages();
        for (GenPackage subGenPackage : _subGenPackages) {
            this.setInitializeByLoad(subGenPackage);
        }
    }

    private List<Diagnostic> expandDiagnostics(Diagnostic d) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        result.add(d);
        List _children = d.getChildren();
        result.addAll(_children);
        List _children_1 = d.getChildren();
        for (Diagnostic c : _children_1) {
            List<Diagnostic> _expandDiagnostics = this.expandDiagnostics(c);
            result.addAll(_expandDiagnostics);
        }
        return result;
    }

    private String exceptionToStackString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter _printWriter = new PrintWriter(sw);
        e.printStackTrace(_printWriter);
        String exceptionAsString = sw.toString();
        return exceptionAsString;
    }

    private String diagnosticErrorsToString(Diagnostic diagnostic) {
        List<Diagnostic> _expandDiagnostics = this.expandDiagnostics(diagnostic);
        Functions.Function1<Diagnostic, Boolean> _function = new Functions.Function1<Diagnostic, Boolean>(){

            public Boolean apply(Diagnostic d) {
                int _severity = d.getSeverity();
                return _severity == 4;
            }
        };
        Iterable _filter = IterableExtensions.filter(_expandDiagnostics, (Functions.Function1)_function);
        Set errors = IterableExtensions.toSet((Iterable)_filter);
        Functions.Function1<Diagnostic, Boolean> _function_1 = new Functions.Function1<Diagnostic, Boolean>(){

            public Boolean apply(Diagnostic e) {
                Throwable _exception = e.getException();
                return !Objects.equal((Object)_exception, null);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)errors, (Functions.Function1)_function_1);
        Functions.Function1<Diagnostic, String> _function_2 = new Functions.Function1<Diagnostic, String>(){

            public String apply(Diagnostic e) {
                Throwable _exception = e.getException();
                return StandaloneEMFProjectGenerator.this.exceptionToStackString(_exception);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_2);
        Set exceptions = IterableExtensions.toSet((Iterable)_map);
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (String e : exceptions) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("Encountered exceptions:\n", "");
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            _builder.append("- ");
            _builder.append(e, "");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append("\n", "");
        }
        boolean _hasElements_1 = false;
        for (Diagnostic e_1 : errors) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
                _builder.append("Encountered diagnostic errors:\n", "");
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            _builder.append("- ");
            String _message = e_1.getMessage();
            _builder.append(_message, "");
            _builder.append(" ");
            _builder.append("\t\t\t");
        }
        if (_hasElements_1) {
            _builder.append("\n", "");
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected void generateCode(IProgressMonitor progressMonitor) throws Exception {
        boolean success = false;
        this.prepareGenModelForCodeGeneration(this.genModel);
        Generator generator = GenModelUtil.createGenerator((GenModel)this.genModel);
        boolean canGenerate = generator.canGenerate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Cannot generate code of EPackage ");
        String _name = this.ecoreModel.getName();
        _builder.append(_name, "");
        String message = _builder.toString();
        if (canGenerate) {
            Diagnostic diagnostic = null;
            String otherMessage = "";
            try {
                Diagnostic _generate;
                Monitor _monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
                diagnostic = _generate = generator.generate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", _monitor);
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    String _exceptionToStackString;
                    Throwable t = _t;
                    otherMessage = _exceptionToStackString = this.exceptionToStackString(t);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            if (!Objects.equal((Object)diagnostic, null) && diagnostic.getSeverity() == 0) {
                success = true;
            } else {
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)diagnostic, null);
                if (_notEquals) {
                    String _message = message;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(": ");
                    String _diagnosticErrorsToString = this.diagnosticErrorsToString(diagnostic);
                    _builder_1.append(_diagnosticErrorsToString, "");
                    _builder_1.append(".");
                    message = String.valueOf(_message) + _builder_1;
                } else {
                    String _message_1 = message;
                    message = String.valueOf(_message_1) + otherMessage;
                }
            }
        } else {
            String _message_2 = message;
            message = String.valueOf(_message_2) + "generator.canGenerate returns false.";
        }
        if (!success) {
            throw new Exception(message);
        }
    }

    protected void prepareGenModelForCodeGeneration(GenModel genModel) {
        genModel.reconcile();
        genModel.setCanGenerate(true);
    }

    private void save(Resource resource) {
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                URI _uRI = resource.getURI();
                String _plus = "Could not save resource '" + _uRI;
                String _plus_1 = String.valueOf(_plus) + "'.";
                throw new RuntimeException(_plus_1, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Pure
    public IProject getProject() {
        return this.project;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    @Pure
    public Set<GenPackage> getReferencedGenPackages() {
        return this.referencedGenPackages;
    }

    @Pure
    public Set<EPackage> getRootPackages() {
        return this.rootPackages;
    }
}

