/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.gemoc.generator;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.trace.commons.CodeGenUtil;
import org.eclipse.gemoc.trace.commons.EclipseUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.ManifestUtil;
import org.eclipse.gemoc.trace.gemoc.generator.codegen.StateManagerGeneratorJava;
import org.eclipse.gemoc.trace.gemoc.generator.codegen.TraceConstructorGeneratorJava;
import org.eclipse.gemoc.trace.gemoc.generator.util.StandaloneEMFProjectGenerator;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerator;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtensionPoint;
import org.eclipse.gemoc.xdsmlframework.ide.ui.builder.pde.PluginXMLHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;

@SuppressWarnings("all")
public class GenericEngineTraceAddonGenerator {
  private final OperationalSemanticsView opsemanticsview;
  
  private final String pluginName;
  
  private final String packageQN;
  
  private final String className;
  
  private final String languageName;
  
  private final String tracedLanguageName;
  
  private final String stepFactoryClassName;
  
  private String traceConstructorClassName;
  
  private String stateManagerClassName;
  
  private TraceMMGenerationTraceability traceability;
  
  private Set<GenPackage> genPackages;
  
  private IPackageFragment packageFragment;
  
  private EPackage tracemm;
  
  private boolean partialTraceManagement = false;
  
  @Accessors({ AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER })
  private IProject project;
  
  public GenericEngineTraceAddonGenerator(final OperationalSemanticsView opsemanticsview, final String pluginName) {
    this.opsemanticsview = opsemanticsview;
    this.pluginName = pluginName;
    this.packageQN = (pluginName + ".tracemanager");
    EPackage _executionMetamodel = opsemanticsview.getExecutionMetamodel();
    String _name = _executionMetamodel.getName();
    this.tracedLanguageName = _name;
    String _replaceAll = this.tracedLanguageName.replaceAll(" ", "");
    String _plus = (_replaceAll + "Trace");
    this.languageName = _plus;
    String _replaceAll_1 = this.languageName.replaceAll(" ", "");
    String _firstUpper = StringExtensions.toFirstUpper(_replaceAll_1);
    String _plus_1 = (_firstUpper + "EngineAddon");
    this.className = _plus_1;
    String _replaceAll_2 = this.languageName.replaceAll(" ", "");
    String _firstUpper_1 = StringExtensions.toFirstUpper(_replaceAll_2);
    String _plus_2 = (_firstUpper_1 + "StepFactory");
    this.stepFactoryClassName = _plus_2;
  }
  
  public void generateCompleteAddon() {
    try {
      IWorkbench _workbench = PlatformUI.getWorkbench();
      IWorkbenchWindow _activeWorkbenchWindow = _workbench.getActiveWorkbenchWindow();
      final IRunnableWithProgress _function = new IRunnableWithProgress() {
        @Override
        public void run(final IProgressMonitor m) throws InvocationTargetException, InterruptedException {
          GenericEngineTraceAddonGenerator.this.generateCompleteAddon(m);
        }
      };
      _activeWorkbenchWindow.run(false, true, _function);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static String getBaseFQN(final Rule r) {
    final EOperation o = r.getOperation();
    final EClass c = r.getContainingClass();
    String _baseFQN = EcoreCraftingUtil.getBaseFQN(c);
    String _plus = (_baseFQN + ".");
    String _name = o.getName();
    return (_plus + _name);
  }
  
  private String getJavaFQN(final EClassifier c) {
    return this.getJavaFQN(c, false);
  }
  
  private String getJavaFQN(final EClassifier c, final boolean enforcePrimitiveJavaClass) {
    return EcoreCraftingUtil.getJavaFQN(c, this.genPackages, enforcePrimitiveJavaClass);
  }
  
  private static Set<GenPackage> findNestedGenpackages(final GenPackage p) {
    EList<GenPackage> _nestedGenPackages = p.getNestedGenPackages();
    final Set<GenPackage> result = IterableExtensions.<GenPackage>toSet(_nestedGenPackages);
    result.add(p);
    EList<GenPackage> _nestedGenPackages_1 = p.getNestedGenPackages();
    for (final GenPackage n : _nestedGenPackages_1) {
      Set<GenPackage> _findNestedGenpackages = GenericEngineTraceAddonGenerator.findNestedGenpackages(n);
      result.addAll(_findNestedGenpackages);
    }
    return result;
  }
  
  public void generateCompleteAddon(final IProgressMonitor m) {
    this.generateTraceMetamodelAndPlugin(m);
    this.prepareManifest(m);
    this.generateTraceManagementCode(m);
    this.addExtensionPoint();
  }
  
  private void generateTraceMetamodelAndPlugin(final IProgressMonitor m) {
    try {
      final TraceMMGenerator tmmgenerator = new TraceMMGenerator(this.opsemanticsview, true);
      tmmgenerator.computeAllMaterial();
      tmmgenerator.sortResult();
      EPackage _tracemmresult = tmmgenerator.getTracemmresult();
      this.tracemm = _tracemmresult;
      final StandaloneEMFProjectGenerator emfGen = new StandaloneEMFProjectGenerator(this.pluginName, this.tracemm);
      emfGen.generateBaseEMFProject(m);
      final Set<GenPackage> referencedGenPackagesRoots = emfGen.getReferencedGenPackages();
      final Function1<GenPackage, Set<GenPackage>> _function = new Function1<GenPackage, Set<GenPackage>>() {
        @Override
        public Set<GenPackage> apply(final GenPackage it) {
          return GenericEngineTraceAddonGenerator.findNestedGenpackages(it);
        }
      };
      Iterable<Set<GenPackage>> _map = IterableExtensions.<GenPackage, Set<GenPackage>>map(referencedGenPackagesRoots, _function);
      Iterable<GenPackage> _flatten = Iterables.<GenPackage>concat(_map);
      Set<GenPackage> _set = IterableExtensions.<GenPackage>toSet(_flatten);
      this.genPackages = _set;
      Set<EPackage> _rootPackages = emfGen.getRootPackages();
      tmmgenerator.addGetCallerEOperations(_rootPackages, this.genPackages);
      Set<EPackage> _rootPackages_1 = emfGen.getRootPackages();
      EPackage _head = IterableExtensions.<EPackage>head(_rootPackages_1);
      Resource _eResource = _head.eResource();
      _eResource.save(null);
      emfGen.generateModelCode(m);
      IProject _project = emfGen.getProject();
      this.project = _project;
      final IJavaProject javaProject = JavaCore.create(this.project);
      final List<IFolder> sourceFolders = EclipseUtil.findSrcFoldersOf(javaProject);
      IFolder _get = sourceFolders.get(0);
      final IPackageFragmentRoot srcFolderFragment = javaProject.getPackageFragmentRoot(_get);
      IPackageFragment _createPackageFragment = srcFolderFragment.createPackageFragment(this.packageQN, true, m);
      this.packageFragment = _createPackageFragment;
      TraceMMGenerationTraceability _traceability = tmmgenerator.getTraceability();
      this.traceability = _traceability;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void generateTraceManagementCode(final IProgressMonitor m) {
    try {
      EPackage _executionMetamodel = this.opsemanticsview.getExecutionMetamodel();
      final TraceConstructorGeneratorJava tconstructorgen = new TraceConstructorGeneratorJava(this.languageName, 
        (this.pluginName + ".tracemanager"), this.tracemm, this.traceability, this.genPackages, _executionMetamodel, this.partialTraceManagement);
      String _className = tconstructorgen.getClassName();
      this.traceConstructorClassName = _className;
      String _generateCode = tconstructorgen.generateCode();
      this.packageFragment.createCompilationUnit((this.traceConstructorClassName + ".java"), _generateCode, true, m);
      final StateManagerGeneratorJava statemanagergem = new StateManagerGeneratorJava(this.languageName, 
        (this.pluginName + ".tracemanager"), this.tracemm, this.traceability, this.genPackages);
      String _className_1 = statemanagergem.getClassName();
      this.stateManagerClassName = _className_1;
      String _generateCode_1 = statemanagergem.generateCode();
      this.packageFragment.createCompilationUnit((this.stateManagerClassName + ".java"), _generateCode_1, true, m);
      final IPackageFragment fragment = this.packageFragment;
      String _generateAddonClassCode = this.generateAddonClassCode();
      final String prettyCode = CodeGenUtil.formatJavaCode(_generateAddonClassCode);
      fragment.createCompilationUnit((this.className + ".java"), prettyCode, true, m);
      final String uglyFactoryCode = this.generateStepFactory();
      final String prettyCodeStepFactory = CodeGenUtil.formatJavaCode(uglyFactoryCode);
      fragment.createCompilationUnit((this.stepFactoryClassName + ".java"), prettyCodeStepFactory, true, m);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private boolean prepareManifest(final IProgressMonitor m) {
    try {
      boolean _xblockexpression = false;
      {
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.emf.transaction");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.emf.compare");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.executionframework.engine");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.xtext");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.commons.eclipse");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.trace.gemoc");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.trace.gemoc.api");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.xdsmlframework.api");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.trace.commons.model");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.addon.multidimensional.timeline");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.timeline");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.trace.commons");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.xdsmlframework.api");
        ManifestUtil.addToPluginManifest(this.project, m, "org.eclipse.gemoc.trace.commons.model");
        _xblockexpression = ManifestUtil.setRequiredExecutionEnvironmentToPluginManifest(this.project, m, "JavaSE-1.8");
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private void addExtensionPoint() {
    this.project = this.project;
    final IFile pluginfile = this.project.getFile(PluginXMLHelper.PLUGIN_FILENAME);
    PluginXMLHelper.createEmptyTemplateFile(pluginfile, false);
    final PluginXMLHelper helper = new PluginXMLHelper();
    helper.loadDocument(pluginfile);
    final Element extensionPoint = helper.getOrCreateExtensionPoint(
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT);
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_CLASS, ((this.packageQN + ".") + this.className));
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_DEFAULT, "false");
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_ID, this.pluginName);
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_NAME, 
      (this.tracedLanguageName + " MultiDimensional Trace"));
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_SHORTDESCRIPTION, 
      (("MultiDimensional Trace support dedicated to " + this.tracedLanguageName) + " language"));
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_OPENVIEWIDS, "org.eclipse.gemoc.addon.multidimensional.timeline.views.timeline.MultidimensionalTimeLineView");
    GenericEngineTraceAddonGenerator.updateDefinitionAttributeInExtensionPoint(extensionPoint, 
      EngineAddonSpecificationExtensionPoint.GEMOC_ENGINE_ADDON_EXTENSION_POINT_ADDONGROUPID, "Sequential.AddonGroup");
    helper.saveDocument(pluginfile);
  }
  
  private static Element updateDefinitionAttributeInExtensionPoint(final Element extensionPoint, final String atributeName, final String value) {
    Element result = null;
    final String defName = "Addon";
    ElementFilter _elementFilter = new ElementFilter(defName);
    final List<Element> elements = extensionPoint.<Element>getContent(_elementFilter);
    int _size = elements.size();
    boolean _equals = (_size == 0);
    if (_equals) {
      Element _element = new Element(defName);
      result = _element;
      extensionPoint.addContent(result);
    } else {
      Element _get = elements.get(0);
      result = _get;
    }
    result.setAttribute(atributeName, value);
    return result;
  }
  
  private String generateAddonClassCode() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(this.packageQN, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import java.util.Map;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.EObject;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.State;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStateManager;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStepFactory;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.gemoc.traceaddon.AbstractTraceAddon;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class ");
    _builder.append(this.className, "");
    _builder.append(" extends AbstractTraceAddon {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private ");
    _builder.append(this.stepFactoryClassName, "\t");
    _builder.append(" factory = null;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ITraceConstructor constructTraceConstructor(Resource modelResource, Resource traceResource, Map<EObject, TracedObject<?>> exeToTraced) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new ");
    _builder.append(this.traceConstructorClassName, "\t\t");
    _builder.append("(modelResource, traceResource, exeToTraced);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public IStateManager<State<?, ?>> constructStateManager(Resource modelResource, Map<TracedObject<?>, EObject> tracedToExe) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new ");
    _builder.append(this.stateManagerClassName, "\t\t");
    _builder.append("(modelResource, tracedToExe);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public IStepFactory getFactory() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (factory == null)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("factory = new ");
    _builder.append(this.stepFactoryClassName, "\t\t\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return factory;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public boolean isAddonForTrace(EObject root) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return root instanceof ");
    TraceMMExplorer _traceMMExplorer = this.traceability.getTraceMMExplorer();
    EClass _specificTraceClass = _traceMMExplorer.getSpecificTraceClass();
    String _javaFQN = this.getJavaFQN(_specificTraceClass);
    _builder.append(_javaFQN, "\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    return _builder.toString();
  }
  
  private Set<EClass> potentialCallerClasses(final EClass stepCallerClass) {
    final HashSet<EClass> possibleCallerClasses = new HashSet<EClass>();
    EPackage _executionMetamodel = this.opsemanticsview.getExecutionMetamodel();
    EList<EClassifier> _eClassifiers = _executionMetamodel.getEClassifiers();
    Iterable<EClass> _filter = Iterables.<EClass>filter(_eClassifiers, EClass.class);
    Iterables.<EClass>addAll(possibleCallerClasses, _filter);
    Set<EClass> _allMutableClasses = this.traceability.getAllMutableClasses();
    possibleCallerClasses.addAll(_allMutableClasses);
    Iterable<EClass> _filter_1 = Iterables.<EClass>filter(possibleCallerClasses, EClass.class);
    final Function1<EClass, Boolean> _function = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass c) {
        return Boolean.valueOf((c.equals(stepCallerClass) || c.getEAllSuperTypes().contains(stepCallerClass)));
      }
    };
    Iterable<EClass> _filter_2 = IterableExtensions.<EClass>filter(_filter_1, _function);
    final Function1<EClass, String> _function_1 = new Function1<EClass, String>() {
      @Override
      public String apply(final EClass it) {
        return it.getName();
      }
    };
    List<EClass> _sortBy = IterableExtensions.<EClass, String>sortBy(_filter_2, _function_1);
    final Set<EClass> filtered = IterableExtensions.<EClass>toSet(_sortBy);
    return filtered;
  }
  
  private String generateStepFactory() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("package ");
    _builder.append(this.packageQN, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("import java.util.List;");
    _builder.newLine();
    _builder.append("import org.eclipse.gemoc.trace.gemoc.api.IStepFactory;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class ");
    _builder.append(this.stepFactoryClassName, "");
    _builder.append(" implements IStepFactory {\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("public org.eclipse.gemoc.trace.commons.model.trace.Step<?> createStep(org.eclipse.gemoc.trace.commons.model.trace.MSE mse, List<Object> parameters, List<Object> result) {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gemoc.trace.commons.model.trace.Step<?> step = null;");
    _builder.newLine();
    _builder.append("org.eclipse.emf.ecore.EClass ec = mse.getCaller().eClass();");
    _builder.newLine();
    _builder.append("String stepRule = org.eclipse.gemoc.trace.commons.EcoreCraftingUtil.getFQN(ec, \".\") + \".\"");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("+ mse.getAction().getName();");
    _builder.newLine();
    _builder.newLine();
    {
      EList<Rule> _rules = this.opsemanticsview.getRules();
      final Function1<Rule, String> _function = new Function1<Rule, String>() {
        @Override
        public String apply(final Rule it) {
          return GenericEngineTraceAddonGenerator.getBaseFQN(it);
        }
      };
      List<Rule> _sortBy = IterableExtensions.<Rule, String>sortBy(_rules, _function);
      boolean _hasElements = false;
      for(final Rule rule : _sortBy) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("else", "\t");
        }
        _builder.newLine();
        _builder.append("\t");
        final EClass stepCallerClass = rule.getContainingClass();
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        final Set<EClass> filtered = this.potentialCallerClasses(stepCallerClass);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        {
          boolean _isEmpty = filtered.isEmpty();
          if (_isEmpty) {
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (stepRule.equalsIgnoreCase(\"");
            String _baseFQN = GenericEngineTraceAddonGenerator.getBaseFQN(rule);
            _builder.append(_baseFQN, "\t");
            _builder.append("\")) {");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("if (");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("mse.getAction().getName().equalsIgnoreCase(\"");
            EOperation _operation = rule.getOperation();
            String _name = _operation.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("&& (");
            _builder.newLine();
            {
              boolean _hasElements_1 = false;
              for(final EClass possibleCallerClass : filtered) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder.appendImmediate(" || ", "\t\t");
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("ec.getClassifierID()== ");
                String _stringClassifierID = EcoreCraftingUtil.stringClassifierID(possibleCallerClass, this.genPackages);
                _builder.append(_stringClassifierID, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("{");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("step = ");
        EClass _stepClassFromStepRule = this.traceability.getStepClassFromStepRule(rule);
        String _stringCreate = EcoreCraftingUtil.stringCreate(_stepClassFromStepRule);
        _builder.append(_stringCreate, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("} ");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
      }
      if (_hasElements) {
        _builder.append("else", "\t");
      }
    }
    _builder.append("\t");
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("step = org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory.eINSTANCE.createGenericSequentialStep();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence mseocc = org.eclipse.gemoc.trace.commons.model.trace.TraceFactory.eINSTANCE.createMSEOccurrence();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mseocc.setMse(mse);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mseocc.getParameters().addAll(parameters);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mseocc.getResult().addAll(result);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("step.setMseoccurrence(mseocc);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return step;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  @Pure
  public IProject getProject() {
    return this.project;
  }
  
  protected void setProject(final IProject project) {
    this.project = project;
  }
}
